/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerafix.mixin;

import com.example.camerafix.CameraFixClient;
import com.example.camerafix.CameraSettings;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4184.class})
public abstract class CameraOffsetMixin {
    @Shadow
    private class_243 field_18712;
    @Unique
    private double cfSmoothLen;

    @Shadow
    public abstract float method_19330();

    @Shadow
    public abstract float method_19329();

    @Shadow
    public abstract void method_19324(float var1, float var2, float var3);

    @Shadow
    public abstract class_243 method_19326();

    @Inject(method={"update"}, at={@At(value="TAIL")})
    private void onUpdate(class_1922 area, class_1297 focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci) {
        double grow;
        if (!thirdPerson) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        class_243 eyePos = focusedEntity != null ? focusedEntity.method_5836(tickDelta) : this.method_19326();
        class_243 currentPos = this.method_19326();
        class_243 baseVec = currentPos.method_1020(eyePos);
        double baseDist = baseVec.method_1033();
        class_243 forward = class_243.method_1030((float)this.method_19329(), (float)this.method_19330()).method_1029();
        class_243 offset = CameraSettings.computeOffset(this.method_19330(), this.method_19329());
        class_243 desired = eyePos.method_1019(forward.method_1021(-baseDist)).method_1019(offset);
        class_243 dir = desired.method_1020(eyePos);
        double len = dir.method_1033();
        if (len <= 1.0E-6) {
            this.field_18712 = desired;
            return;
        }
        class_243 dirN = dir.method_1029();
        double margin = Math.max(0.02, CameraSettings.collisionMargin);
        double epsilon = Math.max(0.1, margin * 0.75);
        class_243 worldUp = new class_243(0.0, 1.0, 0.0);
        class_243 right = dirN.method_1036(worldUp).method_1029();
        if (right.method_1027() < 1.0E-6) {
            right = new class_243(1.0, 0.0, 0.0);
        }
        class_243 up = worldUp;
        int ring = 8;
        class_243[] samples = new class_243[1 + ring * 2];
        samples[0] = class_243.field_1353;
        double r1 = epsilon;
        double r2 = epsilon * 2.0;
        for (int i = 0; i < ring; ++i) {
            double a = Math.PI * 2 * ((double)i / (double)ring);
            class_243 o = right.method_1021(Math.cos(a)).method_1019(up.method_1021(Math.sin(a))).method_1029();
            samples[1 + i] = o.method_1021(r1);
            samples[1 + ring + i] = o.method_1021(r2);
        }
        Double minHitDist = null;
        for (class_243 s : samples) {
            class_3965 h = mc.field_1687.method_17742(new class_3959(eyePos.method_1019(s), desired.method_1019(s), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, focusedEntity));
            if (h.method_17783() != class_239.class_240.field_1332) continue;
            double d = eyePos.method_1022(h.method_17784());
            if (minHitDist != null && !(d < minHitDist)) continue;
            minHitDist = d;
        }
        boolean aimingRaw = GLFW.glfwGetMouseButton((long)mc.method_22683().method_4490(), (int)1) == 1;
        boolean allowZoom = false;
        if (focusedEntity instanceof class_1657) {
            class_1657 player = (class_1657)focusedEntity;
            class_1799 stack = player.method_6047();
            boolean offhandArrow = player.method_6079().method_31574(class_1802.field_8107);
            if (stack.method_31574(class_1802.field_8102)) {
                int arrows = player.method_31548().method_18861(class_1802.field_8107);
                allowZoom = arrows > 0 || offhandArrow;
            } else if (stack.method_31574(class_1802.field_8547)) {
                allowZoom = true;
            }
        }
        boolean aiming = aimingRaw && allowZoom;
        double aimTarget = 2.0;
        boolean alreadyCloseDueToCollision = false;
        if (minHitDist != null) {
            double minCloseLen = Math.max(0.0, minHitDist - margin);
            alreadyCloseDueToCollision = minCloseLen <= aimTarget + 1.0E-6;
        }
        double targetLen = len;
        if (aiming && !alreadyCloseDueToCollision) {
            targetLen = Math.min(len, aimTarget);
        }
        double d = grow = aiming ? 0.08 : 0.18;
        if (baseDist < 0.05) {
            this.cfSmoothLen = 0.0;
        }
        double useLen = this.cfSmoothLen = Math.min(targetLen, this.cfSmoothLen + grow);
        if (minHitDist != null) {
            class_238 b;
            boolean coll;
            boolean underwater;
            double clampDist = Math.max(0.0, Math.min(minHitDist - margin, useLen));
            class_243 clamped = eyePos.method_1019(dirN.method_1021(clampDist));
            boolean bl = underwater = !mc.field_1687.method_8316(class_2338.method_49638((class_2374)eyePos)).method_15769();
            if (focusedEntity != null && !underwater) {
                class_243 to;
                class_243 from;
                class_3965 upHit;
                double ratio = targetLen > 1.0E-6 ? Math.max(0.0, Math.min(1.0, 1.0 - clampDist / targetLen)) : 0.0;
                double maxLift = 0.25;
                double targetLift = maxLift * ratio;
                double step = 0.1;
                double applied = 0.0;
                while (applied + step <= targetLift && (upHit = mc.field_1687.method_17742(new class_3959(from = clamped.method_1031(0.0, applied, 0.0), to = clamped.method_1031(0.0, applied + step, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, focusedEntity))).method_17783() != class_239.class_240.field_1332) {
                    applied += step;
                }
                if (applied > 0.0) {
                    clamped = clamped.method_1031(0.0, applied, 0.0);
                }
            }
            double rCheck = Math.max(0.06, epsilon * 0.75);
            double backStep = Math.max(0.08, epsilon);
            for (int i = 0; i < 12 && (coll = mc.field_1687.method_20812(focusedEntity, b = new class_238(clamped.field_1352 - rCheck, clamped.field_1351 - rCheck, clamped.field_1350 - rCheck, clamped.field_1352 + rCheck, clamped.field_1351 + rCheck, clamped.field_1350 + rCheck)).iterator().hasNext()); ++i) {
                clampDist = Math.max(0.0, clampDist - backStep);
                clamped = eyePos.method_1019(dirN.method_1021(clampDist));
            }
            this.field_18712 = clamped;
            CameraFixClient.lastThirdPersonLen = eyePos.method_1022(this.field_18712);
        } else {
            class_238 b;
            boolean coll;
            class_243 clamped = eyePos.method_1019(dirN.method_1021(useLen));
            double rCheck = Math.max(0.06, epsilon * 0.75);
            double backStep = Math.max(0.08, epsilon);
            for (int i = 0; i < 12 && (coll = mc.field_1687.method_20812(focusedEntity, b = new class_238(clamped.field_1352 - rCheck, clamped.field_1351 - rCheck, clamped.field_1350 - rCheck, clamped.field_1352 + rCheck, clamped.field_1351 + rCheck, clamped.field_1350 + rCheck)).iterator().hasNext()); ++i) {
                useLen = Math.max(0.0, useLen - backStep);
                clamped = eyePos.method_1019(dirN.method_1021(useLen));
            }
            this.field_18712 = clamped;
            CameraFixClient.lastThirdPersonLen = eyePos.method_1022(this.field_18712);
        }
    }
}

