/*
 * Decompiled with CFR 0.152.
 */
package me.andy.mobignoreme.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import me.andy.mobignoreme.config.ConfigManager;
import me.andy.mobignoreme.config.ModConfig;
import me.andy.mobignoreme.permissions.PermissionChecker;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class InternalToggleAllDisableCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mobignoreinternal").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"togglealldisable").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(InternalToggleAllDisableCommand::execute))));
    }

    private static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean shouldEnableAll;
        class_3222 targetPlayer = class_2186.method_9315(context, (String)"player");
        class_2168 source = (class_2168)context.getSource();
        String targetUuid = targetPlayer.method_5845();
        Set<String> mobsToToggle = InternalToggleAllDisableCommand.getAllIgnoresForPlayer(targetPlayer);
        List currentlyDisabled = ConfigManager.getConfig().getDisabledMobs().getOrDefault(targetUuid, new ArrayList());
        boolean bl = shouldEnableAll = currentlyDisabled.containsAll(mobsToToggle) && !mobsToToggle.isEmpty();
        if (shouldEnableAll) {
            currentlyDisabled.clear();
        } else {
            for (String mob : mobsToToggle) {
                if (currentlyDisabled.contains(mob)) continue;
                currentlyDisabled.add(mob);
            }
        }
        ConfigManager.getConfig().getDisabledMobs().put(targetUuid, currentlyDisabled);
        ConfigManager.saveConfig();
        String refreshCommand = String.format("mobignore %s", targetPlayer.method_5477().getString());
        source.method_9211().method_3734().method_44252(source, refreshCommand);
        return 1;
    }

    private static Set<String> getAllIgnoresForPlayer(class_3222 targetPlayer) {
        TreeSet<String> allMobIgnores;
        ModConfig.PermissionMode currentMode;
        block6: {
            block5: {
                currentMode = ConfigManager.getConfig().getPermissionMode();
                allMobIgnores = new TreeSet<String>();
                if (currentMode == ModConfig.PermissionMode.FALSE) break block5;
                if (currentMode != ModConfig.PermissionMode.BOTH) break block6;
            }
            Optional.ofNullable(ConfigManager.getConfig().getPlayers().get(targetPlayer.method_5845())).ifPresent(allMobIgnores::addAll);
        }
        if ((currentMode == ModConfig.PermissionMode.TRUE || currentMode == ModConfig.PermissionMode.BOTH) && PermissionChecker.IS_PERMISSIONS_API_LOADED) {
            boolean hasWildcard = Permissions.check((class_1297)targetPlayer, (String)"mobignoreme.mobs", (boolean)false);
            for (class_2960 id : class_7923.field_41177.method_10235()) {
                if (((class_1299)class_7923.field_41177.method_63535(id)).method_5891() != class_1311.field_6302) continue;
                String mobName = id.method_12832();
                if (!hasWildcard && !Permissions.check((class_1297)targetPlayer, (String)("mobignoreme." + mobName), (boolean)false)) continue;
                allMobIgnores.add(mobName);
            }
        }
        return allMobIgnores;
    }
}

