/*
 * Decompiled with CFR 0.152.
 */
package me.andy.mobignoreme.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.andy.mobignoreme.command.HelpCommand;
import me.andy.mobignoreme.config.ConfigManager;
import me.andy.mobignoreme.config.ModConfig;
import me.andy.mobignoreme.util.MessageHandler;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class MobIgnoreCommand {
    private static final boolean IS_PERMISSIONS_API_LOADED = FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0");

    public static LiteralArgumentBuilder<class_2168> build(String commandName) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandName).requires(source -> source.method_9259(2))).executes(HelpCommand::execute)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(MobIgnoreCommand::listIgnores)).then(class_2170.method_9244((String)"mob", (ArgumentType)StringArgumentType.string()).suggests(MobIgnoreCommand::getMobSuggestions).executes(MobIgnoreCommand::toggleIgnore)));
    }

    private static int listIgnores(CommandContext<class_2168> context) throws CommandSyntaxException {
        Object configMobs;
        class_3222 player = class_2186.method_9315(context, (String)"player");
        String playerName = player.method_5477().getString();
        ModConfig.PermissionMode currentMode = ConfigManager.getConfig().getPermissionMode();
        HashMap<String, IgnoreSource> ignoredMobsMap = new HashMap<String, IgnoreSource>();
        if ((currentMode == ModConfig.PermissionMode.FALSE || currentMode == ModConfig.PermissionMode.BOTH) && (configMobs = ConfigManager.getConfig().getPlayers().get(player.method_5845())) != null) {
            Iterator<String> iterator = configMobs.iterator();
            while (iterator.hasNext()) {
                String mob = iterator.next();
                ignoredMobsMap.put(mob, IgnoreSource.CONFIG);
            }
        }
        if ((currentMode == ModConfig.PermissionMode.TRUE || currentMode == ModConfig.PermissionMode.BOTH) && IS_PERMISSIONS_API_LOADED) {
            for (class_2960 id : class_7923.field_41177.method_10235()) {
                String mobName2;
                String permission;
                class_1299 type = (class_1299)class_7923.field_41177.method_10223(id);
                if (type.method_5891() != class_1311.field_6302 || !Permissions.check((class_1297)player, (String)(permission = "mobignoreme." + (mobName2 = id.method_12832())), (boolean)false)) continue;
                ignoredMobsMap.merge(mobName2, IgnoreSource.PERM, (oldVal, newVal) -> IgnoreSource.BOTH);
            }
        }
        if (ignoredMobsMap.isEmpty()) {
            MessageHandler.sendMessage((class_2168)context.getSource(), "&cThis player %s is not ignored by any mobs.".formatted(playerName));
        } else {
            StringBuilder message = new StringBuilder("&eThis player %s is ignored by these mobs:".formatted(playerName));
            ignoredMobsMap.forEach((mobName, source) -> {
                message.append("\n&7- &f").append((String)mobName);
                if (currentMode == ModConfig.PermissionMode.BOTH) {
                    switch (source.ordinal()) {
                        case 0: {
                            message.append(" &7(Config)");
                            break;
                        }
                        case 1: {
                            message.append(" &7(PermNode)");
                            break;
                        }
                        case 2: {
                            message.append(" &7(Config + PermNode)");
                        }
                    }
                }
            });
            MessageHandler.sendMessage((class_2168)context.getSource(), message.toString());
        }
        return 1;
    }

    private static int toggleIgnore(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (ConfigManager.getConfig().getPermissionMode() == ModConfig.PermissionMode.TRUE) {
            MessageHandler.sendError((class_2168)context.getSource(), "&cThe mod is in pure permission mode. Ignores must be managed with a permissions plugin.");
            return 0;
        }
        class_3222 player = class_2186.method_9315(context, (String)"player");
        String mobNameInput = StringArgumentType.getString(context, (String)"mob");
        class_2960 mobId = class_2960.method_12829((String)mobNameInput);
        if (mobId == null) {
            mobId = class_2960.method_60655((String)"minecraft", (String)mobNameInput);
        }
        if (!class_7923.field_41177.method_10250(mobId)) {
            MessageHandler.sendError((class_2168)context.getSource(), "&cUnknown mob type: " + String.valueOf(mobId));
            return 0;
        }
        String mobPath = mobId.method_12832();
        List ignores = ConfigManager.getConfig().getPlayers().getOrDefault(player.method_5845(), new ArrayList());
        boolean isCurrentlyIgnored = ignores.contains(mobPath);
        ConfigManager.toggleMobIgnore(player.method_5845(), mobPath);
        if (isCurrentlyIgnored) {
            MessageHandler.sendMessage((class_2168)context.getSource(), "&aRemoved &f%s &afrom %s's config ignore list.".formatted(mobPath, player.method_5477().getString()));
        } else {
            MessageHandler.sendMessage((class_2168)context.getSource(), "&aAdded &f%s &ato %s's config ignore list.".formatted(mobPath, player.method_5477().getString()));
        }
        return 1;
    }

    private static CompletableFuture<Suggestions> getMobSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(class_7923.field_41177.method_10235().stream().filter(id -> {
            class_1299 type = (class_1299)class_7923.field_41177.method_10223(id);
            return type.method_5891() == class_1311.field_6302;
        }).map(class_2960::method_12832), (SuggestionsBuilder)builder);
    }

    private static enum IgnoreSource {
        CONFIG,
        PERM,
        BOTH;

    }
}

