/*
 * Decompiled with CFR 0.152.
 */
package me.andy.mobignoreme.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.andy.mobignoreme.config.ConfigManager;
import me.andy.mobignoreme.config.ModConfig;
import me.andy.mobignoreme.permissions.PermissionChecker;
import me.andy.mobignoreme.util.MessageHandler;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class ToggleIgnoreCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"mobignore").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"mob", (ArgumentType)class_2232.method_9441()).suggests(ToggleIgnoreCommand::getMobSuggestions).executes(ToggleIgnoreCommand::execute))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"mi").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"mob", (ArgumentType)class_2232.method_9441()).suggests(ToggleIgnoreCommand::getMobSuggestions).executes(ToggleIgnoreCommand::execute))));
    }

    public static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 targetPlayer = class_2186.method_9315(context, (String)"player");
        class_2960 mobId = class_2232.method_9443(context, (String)"mob");
        class_3222 sourcePlayer = null;
        if (source.method_43737()) {
            sourcePlayer = source.method_9207();
        }
        boolean isSelf = sourcePlayer != null && sourcePlayer.method_5667().equals(targetPlayer.method_5667());
        boolean isOp = source.method_9259(2);
        if (!PermissionChecker.IS_PERMISSIONS_API_LOADED) {
            if (!isOp) {
                MessageHandler.sendError(source, "&cPermissions API not loaded. You need OP to use this command.");
                return 0;
            }
        } else if (isSelf) {
            if (!Permissions.check((class_2172)source, (String)"mobignoreme.modifyme", (boolean)isOp)) {
                MessageHandler.sendError(source, "&cYou do not have permission to modify your own ignore list.");
                return 0;
            }
        } else if (!Permissions.check((class_2172)source, (String)"mobignoreme.modifyothers", (boolean)isOp)) {
            MessageHandler.sendError(source, "&cYou do not have permission to modify the ignore lists of other players.");
            return 0;
        }
        if (ConfigManager.getConfig().getPermissionMode() == ModConfig.PermissionMode.TRUE) {
            MessageHandler.sendError(source, "&cThe mod is in pure permission mode. Config ignores are disabled.");
            return 0;
        }
        if (!class_7923.field_41177.method_10250(mobId)) {
            MessageHandler.sendError(source, "&cUnknown mob type: " + String.valueOf(mobId));
            return 0;
        }
        String mobPath = mobId.method_12832();
        List ignores = ConfigManager.getConfig().getPlayers().getOrDefault(targetPlayer.method_5845(), new ArrayList());
        boolean isCurrentlyIgnored = ignores.contains(mobPath);
        ConfigManager.toggleMobIgnore(targetPlayer.method_5845(), mobPath);
        if (isCurrentlyIgnored) {
            MessageHandler.sendMessage(source, "&aRemoved &f%s &afrom %s's config ignore list.".formatted(mobPath, targetPlayer.method_5477().getString()));
        } else {
            MessageHandler.sendMessage(source, "&aAdded &f%s &ato %s's config ignore list.".formatted(mobPath, targetPlayer.method_5477().getString()));
        }
        return 1;
    }

    private static CompletableFuture<Suggestions> getMobSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(class_7923.field_41177.method_10235().stream().filter(id -> {
            class_1299 type = (class_1299)class_7923.field_41177.method_10223(id);
            return type.method_5891() == class_1311.field_6302;
        }).map(class_2960::method_12832), (SuggestionsBuilder)builder);
    }
}

