/*
 * Decompiled with CFR 0.152.
 */
package me.andy.mobignoreme.permissions;

import java.util.Collections;
import java.util.List;
import me.andy.mobignoreme.config.ConfigManager;
import me.andy.mobignoreme.config.ModConfig;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class PermissionChecker {
    public static final boolean IS_PERMISSIONS_API_LOADED = FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0");
    public static final String PERMISSION_NODE_PREFIX = "mobignoreme.";

    public static boolean shouldIgnore(class_3222 player, class_1308 mob) {
        boolean hasIgnoreSource;
        if (player.method_7337() || player.method_7325()) {
            return false;
        }
        class_2960 mobId = class_1299.method_5890((class_1299)mob.method_5864());
        if (mobId == null) {
            return false;
        }
        String mobName = mobId.method_12832();
        if (player.method_5682().method_3724()) {
            hasIgnoreSource = mob.method_5864().method_5891() == class_1311.field_6302;
        } else {
            ModConfig.PermissionMode currentMode = ConfigManager.getConfig().getPermissionMode();
            switch (currentMode) {
                case TRUE: {
                    hasIgnoreSource = PermissionChecker.hasPermission(player, mobName);
                    break;
                }
                case FALSE: {
                    hasIgnoreSource = PermissionChecker.isInConfig(player, mobName);
                    break;
                }
                case BOTH: {
                    hasIgnoreSource = PermissionChecker.hasPermission(player, mobName) || PermissionChecker.isInConfig(player, mobName);
                    break;
                }
                default: {
                    hasIgnoreSource = false;
                }
            }
        }
        return hasIgnoreSource && !PermissionChecker.isPlayerDisabled(player, mobName);
    }

    public static boolean hasPermission(class_3222 player, String mobName) {
        if (!IS_PERMISSIONS_API_LOADED) {
            return false;
        }
        boolean hasSpecific = Permissions.check((class_1297)player, (String)(PERMISSION_NODE_PREFIX + mobName), (boolean)false);
        boolean hasWildcard = Permissions.check((class_1297)player, (String)"mobignoreme.mobs", (boolean)false);
        return hasSpecific || hasWildcard;
    }

    public static boolean isInConfig(class_3222 player, String mobName) {
        String playerUuid = player.method_5845();
        List<String> ignoredMobs = ConfigManager.getConfig().getPlayers().get(playerUuid);
        return ignoredMobs != null && ignoredMobs.contains(mobName);
    }

    public static boolean isPlayerDisabled(class_3222 player, String mobName) {
        String playerUuid = player.method_5845();
        List disabledMobs = ConfigManager.getConfig().getDisabledMobs().getOrDefault(playerUuid, Collections.emptyList());
        return disabledMobs.contains(mobName);
    }
}

