/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank;

import com.everydayxp.levelingrank.attribute.ModAttributes;
import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.capability.PlayerQuestProvider;
import com.everydayxp.levelingrank.client.quest.DailyQuestOverlay;
import com.everydayxp.levelingrank.client.render.PowerEnchantBER;
import com.everydayxp.levelingrank.client.render.RarityInfusionBER;
import com.everydayxp.levelingrank.client.screentables.PowerEnchantScreen;
import com.everydayxp.levelingrank.client.screentables.RarityDeconstructorScreen;
import com.everydayxp.levelingrank.client.screentables.RarityInfusionScreen;
import com.everydayxp.levelingrank.config.LevelingRankConfig;
import com.everydayxp.levelingrank.handler.DailyQuestHandler;
import com.everydayxp.levelingrank.items.ModBlockEntities;
import com.everydayxp.levelingrank.items.ModBlocks;
import com.everydayxp.levelingrank.items.ModItems;
import com.everydayxp.levelingrank.menu.ModMenus;
import com.everydayxp.levelingrank.network.ModNetworkHandler;
import com.everydayxp.levelingrank.sound.ModSounds;
import com.everydayxp.levelingrank.util.JsonQuestUtil;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="levelingrank")
public class LevelingRankMod {
    public static final String MODID = "levelingrank";

    public LevelingRankMod() {
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[LevelingRank] \u00c2\u00a1Constructor ejecutado!");
        }
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModAttributes.ATTRIBUTES.register(modBus);
        ModBlocks.BLOCKS.register(modBus);
        ModItems.ITEMS.register(modBus);
        ModBlockEntities.BLOCK_ENTITIES.register(modBus);
        ModMenus.MENUS.register(modBus);
        ModSounds.SOUND_EVENTS.register(modBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)LevelingRankConfig.CONFIG, "levelingrank/LevelingRankConfig.toml");
        ModNetworkHandler.register();
        JsonQuestUtil.reloadQuests();
        MinecraftForge.EVENT_BUS.register(DailyQuestHandler.class);
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[DQ-DEBUG] DailyQuestHandler registrado en EVENT_BUS");
        }
    }

    @Mod.EventBusSubscriber(modid="levelingrank", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onRegisterGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAboveAll("daily_quest", (IGuiOverlay)new DailyQuestOverlay());
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.RARITY_DECONSTRUCTOR_MENU.get()), RarityDeconstructorScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.POWER_ENCHANT_TABLE_MENU.get()), PowerEnchantScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.RARITY_INFUSION_MENU.get()), RarityInfusionScreen::new);
            });
        }

        @SubscribeEvent
        public static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.POWER_ENCHANT_TABLE_BE.get(), PowerEnchantBER::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.RARITY_INFUSION_BE.get(), RarityInfusionBER::new);
        }
    }

    @Mod.EventBusSubscriber(modid="levelingrank")
    public static class PlayerEventHandlers {
        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            if (event.getEntity().m_9236_().m_5776_()) {
                return;
            }
            event.getOriginal().reviveCaps();
            event.getOriginal().getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(oldData -> {
                CompoundTag tag = (CompoundTag)oldData.serializeNBT();
                event.getEntity().getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(newData -> newData.deserializeNBT((Tag)tag));
            });
            event.getOriginal().getCapability(PlayerQuestProvider.PLAYER_QUEST).ifPresent(oldData -> {
                CompoundTag tag = new CompoundTag();
                oldData.saveToNBT(tag);
                event.getEntity().getCapability(PlayerQuestProvider.PLAYER_QUEST).ifPresent(newData -> newData.loadFromNBT(tag));
            });
            event.getOriginal().invalidateCaps();
        }

        @SubscribeEvent
        public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)player;
            sp.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> {
                ModNetworkHandler.syncLevelData(sp, data);
                ModNetworkHandler.syncPlayerLevelToOthers(sp, data.getLevel());
            });
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)player;
            sp.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> {
                ModNetworkHandler.syncLevelData(sp, data);
                ModNetworkHandler.syncPlayerLevelToOthers(sp, data.getLevel());
            });
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> {
                ModNetworkHandler.syncLevelData(serverPlayer, data);
                ModNetworkHandler.syncPlayerLevelToOthers(serverPlayer, data.getLevel());
            });
            for (ServerPlayer otherPlayer : serverPlayer.f_8924_.m_6846_().m_11314_()) {
                if (otherPlayer == serverPlayer) continue;
                otherPlayer.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(otherData -> LevelDataProvider.syncToClient((Player)otherPlayer, otherData));
            }
        }
    }
}

