/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.capability;

import com.everydayxp.levelingrank.capability.ILevelData;
import com.everydayxp.levelingrank.capability.LevelData;
import com.everydayxp.levelingrank.network.ModNetworkHandler;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class LevelDataProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final Capability<ILevelData> LEVEL_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ILevelData>(){});
    private final LevelData data = new LevelData();
    private final LazyOptional<ILevelData> optional = LazyOptional.of(() -> this.data);

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == LEVEL_CAPABILITY ? this.optional.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.data.serializeNBT();
    }

    public void deserializeNBT(CompoundTag tag) {
        this.data.deserializeNBT(tag);
    }

    public CompoundTag saveToNBT() {
        return this.serializeNBT();
    }

    public void loadFromNBT(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public static void syncToClient(Player player, ILevelData data) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModNetworkHandler.syncLevelData(serverPlayer, data.getLevel(), data.getXP());
            serverPlayer.refreshTabListName();
            serverPlayer.f_8924_.m_6846_().m_11268_((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, serverPlayer));
        }
    }
}

