/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.capability;

import com.everydayxp.levelingrank.capability.LevelData;
import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.capability.MobLevelDataProvider;
import com.everydayxp.levelingrank.capability.PlayerQuestProvider;
import com.everydayxp.levelingrank.network.ModNetworkHandler;
import com.everydayxp.levelingrank.network.SyncMobLevelS2CPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="levelingrank")
public class PlayerCapabilityAttacher {
    public static final ResourceLocation LEVEL_ID = new ResourceLocation("levelingrank", "level_data");
    public static final ResourceLocation QUEST_ID = new ResourceLocation("levelingrank", "player_quest");

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            LevelDataProvider levelProvider = new LevelDataProvider();
            PlayerQuestProvider questProvider = new PlayerQuestProvider();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                levelProvider.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(cap -> {
                    if (cap instanceof LevelData) {
                        LevelData data = (LevelData)cap;
                        data.setOwnerUUID(serverPlayer.m_20148_());
                    }
                });
            }
            event.addCapability(LEVEL_ID, (ICapabilityProvider)levelProvider);
            event.addCapability(QUEST_ID, (ICapabilityProvider)questProvider);
        } else if (entity instanceof LivingEntity) {
            event.addCapability(LEVEL_ID, (ICapabilityProvider)new MobLevelDataProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        event.getEntity().getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(levelData -> LevelDataProvider.syncToClient(event.getEntity(), levelData));
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof ServerPlayer) {
            ServerPlayer tracked = (ServerPlayer)entity;
            tracked.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(cap -> ModNetworkHandler.syncPlayerLevelToOthers(tracked, cap.getLevel()));
        }
        if ((entity = event.getTarget()) instanceof LivingEntity) {
            ServerPlayer sp;
            Player player;
            LivingEntity mob = (LivingEntity)entity;
            if (!(event.getTarget() instanceof ServerPlayer) && (player = event.getEntity()) instanceof ServerPlayer && !(sp = (ServerPlayer)player).m_9236_().m_5776_()) {
                mob.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(cap -> ModNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new SyncMobLevelS2CPacket(mob.m_19879_(), cap.getLevel())));
            }
        }
    }
}

