/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.capability;

import com.everydayxp.levelingrank.capability.ILevelData;
import com.everydayxp.levelingrank.capability.IPlayerQuestData;
import com.everydayxp.levelingrank.capability.LevelDataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;

public class PlayerQuestData
implements IPlayerQuestData {
    private long lastQuestDay = -1L;
    private String questId = "";
    private String targetEntityId = "";
    private int requiredAmount = 0;
    private int progress = 0;
    private int dailyRewardXp = 0;
    private String dailyRewardItemId = "";
    private int dailyRewardItemCount = 0;

    @Override
    public long getLastQuestDay() {
        return this.lastQuestDay;
    }

    @Override
    public void setLastQuestDay(long day) {
        this.lastQuestDay = day;
    }

    @Override
    public String getQuestId() {
        return this.questId;
    }

    @Override
    public String getTargetEntityId() {
        return this.targetEntityId;
    }

    @Override
    public int getRequiredAmount() {
        return this.requiredAmount;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public void setKillQuest(String questId, String entityId, int required, int progress) {
        this.questId = questId != null ? questId : "";
        this.targetEntityId = entityId != null ? entityId : "";
        this.requiredAmount = Math.max(0, required);
        this.progress = Math.max(0, progress);
    }

    @Override
    public void incrementProgress(int amount) {
        if (amount <= 0) {
            return;
        }
        this.progress = Math.min(this.requiredAmount, this.progress + amount);
    }

    @Override
    public int getPlayerLevelForQuests(ServerPlayer player) {
        return player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(ILevelData::getLevel).orElse(1);
    }

    @Override
    public int getDailyRewardXp() {
        return this.dailyRewardXp;
    }

    @Override
    public void setDailyRewardXp(int xp) {
        this.dailyRewardXp = Math.max(0, xp);
    }

    @Override
    public String getDailyRewardItemId() {
        return this.dailyRewardItemId;
    }

    @Override
    public void setDailyRewardItemId(String id) {
        this.dailyRewardItemId = id == null ? "" : id;
    }

    @Override
    public int getDailyRewardItemCount() {
        return this.dailyRewardItemCount;
    }

    @Override
    public void setDailyRewardItemCount(int count) {
        this.dailyRewardItemCount = Math.max(0, count);
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        tag.m_128356_("LastQuestDay", this.lastQuestDay);
        tag.m_128359_("QuestId", this.questId);
        tag.m_128359_("TargetEntityId", this.targetEntityId);
        tag.m_128405_("RequiredAmount", this.requiredAmount);
        tag.m_128405_("Progress", this.progress);
        tag.m_128405_("DailyRewardXp", this.dailyRewardXp);
        tag.m_128359_("DailyRewardItemId", this.dailyRewardItemId);
        tag.m_128405_("DailyRewardItemCount", this.dailyRewardItemCount);
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        this.lastQuestDay = tag.m_128454_("LastQuestDay");
        this.questId = tag.m_128461_("QuestId");
        this.targetEntityId = tag.m_128461_("TargetEntityId");
        this.requiredAmount = tag.m_128451_("RequiredAmount");
        this.progress = tag.m_128451_("Progress");
        this.dailyRewardXp = tag.m_128451_("DailyRewardXp");
        this.dailyRewardItemId = tag.m_128461_("DailyRewardItemId");
        this.dailyRewardItemCount = tag.m_128451_("DailyRewardItemCount");
    }
}

