/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.client;

import com.everydayxp.levelingrank.capability.ILevelData;
import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.config.LevelingRankConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="levelingrank", value={Dist.CLIENT})
public class RenderLevelEntity {
    @SubscribeEvent
    public static void onRenderEntityLevel(RenderNameTagEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity mob = (LivingEntity)entity;
        if (entity instanceof Player) {
            return;
        }
        if (!((Boolean)LevelingRankConfig.SHOW_MOB_LEVELS.get()).booleanValue()) {
            return;
        }
        String entityId = mob.m_6095_().m_204041_().m_205785_().m_135782_().toString();
        if (LevelingRankConfig.getLifeBonusEntityBlacklist().contains(entityId)) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Entity camera = mc.f_91075_;
        if (camera == null) {
            return;
        }
        double distSq = camera.m_20280_((Entity)mob);
        if (distSq < 4.0) {
            return;
        }
        if (!ForgeHooksClient.isNameplateInRenderDistance((Entity)mob, (double)distSq)) {
            return;
        }
        int level = mob.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(ILevelData::getLevel).orElse(1);
        if (level <= 0) {
            return;
        }
        HitResult hitResult = mc.f_91077_;
        if (hitResult == null || hitResult.m_6662_() != HitResult.Type.ENTITY) {
            return;
        }
        EntityHitResult ehr = (EntityHitResult)hitResult;
        if (ehr.m_82443_() != mob) {
            return;
        }
        Component name = mob.m_6095_().m_20676_();
        MutableComponent levelText = Component.m_237113_((String)("[Lv." + level + "]")).m_130948_(Style.f_131099_.m_178520_(0xFFFF55));
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource buffer = event.getMultiBufferSource();
        Font font = mc.f_91062_;
        poseStack.m_85836_();
        double y = mob.m_20206_() + 0.5f;
        poseStack.m_85837_(0.0, y, 0.0);
        poseStack.m_252781_(mc.m_91290_().m_253208_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Font.DisplayMode mode = !mob.m_20163_() ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL;
        int nameWidth = font.m_92852_((FormattedText)name);
        int levelWidth = font.m_92852_((FormattedText)levelText);
        float nameStartX = (float)(-(nameWidth + 4 + levelWidth)) / 2.0f;
        float nameY = 0.0f;
        float levelX = nameStartX + (float)nameWidth + 4.0f;
        float levelY = 0.0f;
        float bgOpacity = mc.f_91066_.m_92141_(0.25f);
        int alpha = (int)(bgOpacity * 255.0f) << 24;
        font.m_272077_(name, nameStartX, nameY, 0xFFFFFF, false, pose, buffer, mode, alpha, event.getPackedLight());
        font.m_272077_(name, nameStartX, nameY, -1, false, pose, buffer, Font.DisplayMode.NORMAL, 0, event.getPackedLight());
        font.m_272077_((Component)levelText, levelX, levelY, 0xFFFFFF, false, pose, buffer, mode, alpha, event.getPackedLight());
        font.m_272077_((Component)levelText, levelX, levelY, -1, false, pose, buffer, Font.DisplayMode.NORMAL, 0, event.getPackedLight());
        poseStack.m_85849_();
    }
}

