/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.client;

import com.everydayxp.levelingrank.capability.ILevelData;
import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.config.LevelingRankConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="levelingrank", value={Dist.CLIENT})
public class RenderLevelTitleRenderer {
    private static final float SCALE = 0.025f;
    private static final float OFFSET_Y = -10.0f;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRenderName(RenderNameTagEvent event) {
        String custom;
        ILevelData data2;
        boolean isSelf;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer localPlayer = mc.f_91074_;
        if (localPlayer == null) {
            return;
        }
        boolean bl = isSelf = player == localPlayer;
        if (isSelf && !((Boolean)LevelingRankConfig.SHOW_SELF_LEVEL.get()).booleanValue()) {
            return;
        }
        if (!isSelf && !((Boolean)LevelingRankConfig.SHOW_OTHER_PLAYER_LEVELS.get()).booleanValue()) {
            return;
        }
        double hideRadius = 4.0;
        double hideRadiusSq = hideRadius * hideRadius;
        for (LivingEntity nearby : player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82400_(hideRadius))) {
            if (nearby == player || !(player.m_20280_((Entity)nearby) <= hideRadiusSq)) continue;
            return;
        }
        int level = player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(data -> data.getLevel()).orElse(1);
        Rank baseRank = RenderLevelTitleRenderer.getRankForLevel(level);
        if (baseRank == null) {
            return;
        }
        String text = baseRank.text;
        ChatFormatting color = baseRank.color;
        Optional optCap = player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).resolve();
        if (optCap.isPresent() && (data2 = (ILevelData)optCap.get()).isCustomTitleEnabled() && (custom = data2.getCustomTitle()) != null && !custom.isEmpty()) {
            text = custom;
        }
        MutableComponent titleComponent = Component.m_237113_((String)text).m_130940_(color);
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource buffer = event.getMultiBufferSource();
        Font font = mc.f_91062_;
        poseStack.m_85836_();
        float entityHeight = player.m_20206_() + 0.5f;
        poseStack.m_85837_(0.0, (double)entityHeight, 0.0);
        poseStack.m_252781_(mc.m_91290_().m_253208_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        float textWidth = font.m_92852_((FormattedText)titleComponent);
        float xOffset = -textWidth / 2.0f;
        int backgroundColor = 0x66000000;
        int textColor = 0xFFFFFF;
        font.m_272077_((Component)titleComponent, xOffset, -10.0f, textColor, false, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.SEE_THROUGH, backgroundColor, event.getPackedLight());
        poseStack.m_85849_();
    }

    private static Rank getRankForLevel(int level) {
        int tier = level / 10;
        String key = switch (tier) {
            case 0 -> "rank.levelingrank.novice";
            case 1 -> "rank.levelingrank.explorer";
            case 2 -> "rank.levelingrank.guardian";
            case 3 -> "rank.levelingrank.master";
            case 4 -> "rank.levelingrank.walker";
            case 5 -> "rank.levelingrank.forger";
            case 6 -> "rank.levelingrank.lord";
            case 7 -> "rank.levelingrank.unstoppable";
            case 8 -> "rank.levelingrank.legend";
            default -> "rank.levelingrank.immortal";
        };
        ChatFormatting color = switch (tier) {
            case 0 -> ChatFormatting.WHITE;
            case 1 -> ChatFormatting.GREEN;
            case 2 -> ChatFormatting.AQUA;
            case 3 -> ChatFormatting.YELLOW;
            case 4 -> ChatFormatting.GOLD;
            case 5 -> ChatFormatting.LIGHT_PURPLE;
            case 6 -> ChatFormatting.BLUE;
            case 7 -> ChatFormatting.RED;
            case 8 -> ChatFormatting.DARK_PURPLE;
            default -> ChatFormatting.DARK_RED;
        };
        return new Rank(Component.m_237115_((String)key).getString(), color);
    }

    private static class Rank {
        public final String text;
        public final ChatFormatting color;

        public Rank(String text, ChatFormatting color) {
            this.text = text;
            this.color = color;
        }
    }
}

