/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.client.hud;

import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.client.hud.ClientXPHud;
import com.everydayxp.levelingrank.config.HudPosition;
import com.everydayxp.levelingrank.config.LevelingRankConfig;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="levelingrank", value={Dist.CLIENT})
public class LevelingRankHudOverlay {
    private static boolean synced = false;

    public static void markSynced() {
        synced = true;
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (((Boolean)LevelingRankConfig.SHOW_PLAYER_HUD.get()).booleanValue() && synced) {
            LocalPlayer player = mc.f_91074_;
            player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> {
                int x;
                int MAX_LEVEL = 200;
                int level = data.getLevel();
                int xp = data.getXP();
                int xpNeeded = data.getXPForNextLevel();
                boolean isMax = level >= 200;
                double percentXP = isMax ? 100.0 : Math.min((double)xp * 100.0 / (double)xpNeeded, 100.0);
                String xpPercentStr = String.format("%.2f", percentXP).replace('.', ',') + "%";
                Object levelStr = isMax ? level + " " : String.valueOf(level);
                String fullText = "[Lv] " + (String)levelStr + (isMax ? "MAX " : "") + "| [XP] " + xpPercentStr;
                int textWidth = mc.f_91062_.m_92895_(fullText);
                Objects.requireNonNull(mc.f_91062_);
                int textHeight = 9 + 2;
                int screenWidth = mc.m_91268_().m_85445_();
                int screenHeight = mc.m_91268_().m_85446_();
                HudPosition position = (HudPosition)((Object)((Object)LevelingRankConfig.HUD_POSITION_ENUM.get()));
                int y = switch (position) {
                    case HudPosition.TOP_LEFT -> {
                        x = 5;
                        yield 5;
                    }
                    case HudPosition.TOP_RIGHT -> {
                        x = screenWidth - textWidth - 5;
                        yield 5;
                    }
                    case HudPosition.BOTTOM_LEFT -> {
                        x = 5;
                        yield screenHeight - textHeight - 15;
                    }
                    case HudPosition.BOTTOM_RIGHT -> {
                        x = screenWidth - textWidth - 5;
                        yield screenHeight - textHeight - 15;
                    }
                    case HudPosition.CENTER_LEFT -> {
                        x = 5;
                        yield screenHeight / 2 - textHeight / 2;
                    }
                    case HudPosition.CENTER_RIGHT -> {
                        x = screenWidth - textWidth - 5;
                        yield screenHeight / 2 - textHeight / 2;
                    }
                    case HudPosition.TOP_CENTER -> {
                        x = screenWidth / 2 - textWidth / 2;
                        yield 5;
                    }
                    case HudPosition.BOTTOM_CENTER -> {
                        x = screenWidth / 2 - textWidth / 2;
                        yield screenHeight - textHeight - 15;
                    }
                    default -> {
                        x = 5;
                        yield screenHeight - textHeight - 15;
                    }
                };
                GuiGraphics gui = event.getGuiGraphics();
                Font font = mc.f_91062_;
                int padding = 4;
                int bgX1 = x - padding;
                int bgY1 = y - 2;
                int bgX2 = x + textWidth + padding + 4;
                int bgY2 = y + textHeight;
                gui.m_280509_(bgX1, bgY1, bgX2, bgY2, -1308622848);
                gui.m_280509_(bgX1 - 1, bgY1 - 1, bgX2 + 1, bgY2 + 1, 0x40FFFFFF);
                int drawX = x;
                int drawY = y;
                gui.m_280056_(font, "[Lv]", drawX, drawY, 16766720, true);
                gui.m_280056_(font, (String)levelStr, drawX += font.m_92895_("[Lv] "), drawY, 5944831, true);
                drawX += font.m_92895_((String)levelStr + " ");
                if (isMax) {
                    gui.m_280056_(font, "MAX", drawX, drawY, 0xFF3A3A, true);
                    drawX += font.m_92895_("MAX ");
                } else {
                    drawX += font.m_92895_(" ");
                }
                gui.m_280056_(font, "|", drawX, drawY, 0xC0C0C0, true);
                gui.m_280056_(font, "[XP]", drawX += font.m_92895_("| "), drawY, 10813232, true);
                gui.m_280056_(font, xpPercentStr, drawX += font.m_92895_("[XP] "), drawY, 16758605, true);
            });
        }
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        ClientXPHud.render(event.getGuiGraphics(), screenWidth, screenHeight);
    }
}

