/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.client.screendata;

import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.client.screendata.TitleSelectScreen;
import com.everydayxp.levelingrank.handler.LevelRewardHandler;
import com.everydayxp.levelingrank.network.ModNetworkHandler;
import com.everydayxp.levelingrank.util.WeaponRarityUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class LevelingRankInventoryScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("levelingrank", "textures/gui/player_profile.png");
    private static final int REW_PER_PAGE = 10;
    private final Player player;
    private int leftPos;
    private int topPos;
    private int rewardPage = 0;
    private Button openTitlesButton;

    public LevelingRankInventoryScreen(Player player) {
        super((Component)Component.m_237115_((String)"screen.levelingrank.player_profile"));
        this.player = player;
    }

    protected void m_7856_() {
        super.m_7856_();
        int guiWidth = 256;
        int guiHeight = 256;
        this.leftPos = (this.f_96543_ - guiWidth) / 2;
        this.topPos = (this.f_96544_ - guiHeight) / 2 + 36;
        if (this.openTitlesButton == null) {
            this.openTitlesButton = Button.m_253074_((Component)Component.m_237113_((String)"T"), b -> Minecraft.m_91087_().m_91152_((Screen)new TitleSelectScreen(this.player))).m_252987_(this.leftPos + 230, this.topPos + 8, 16, 16).m_253136_();
        }
        this.m_142416_((GuiEventListener)this.openTitlesButton);
    }

    public boolean m_7043_() {
        return false;
    }

    public int getLeftPos() {
        return this.leftPos;
    }

    public int getTopPos() {
        return this.topPos;
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        this.renderMainFrame(gui);
        this.renderXpHeader(gui);
        this.renderLevelInfoLine(gui, mouseX, mouseY);
        this.renderRewards(gui, mouseX, mouseY, partialTick);
        super.m_88315_(gui, mouseX, mouseY, partialTick);
    }

    private void renderMainFrame(GuiGraphics gui) {
        gui.m_280218_(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0, 0, 256, 256);
    }

    private void renderXpHeader(GuiGraphics gui) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        Font font = mc.f_91062_;
        int maxLevel = 200;
        int level = this.player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(data -> data.getLevel()).orElse(1);
        int xp = this.player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(data -> data.getXP()).orElse(0);
        int xpNeeded = this.player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(data -> data.getXPForNextLevel()).orElse(1);
        boolean isMax = level >= maxLevel;
        int nextLevel = isMax ? level : level + 1;
        double percent = isMax ? 1.0 : Math.min((double)xp / (double)xpNeeded, 1.0);
        String playerName = this.player.m_7755_().getString();
        String baseRankName = LevelingRankInventoryScreen.getRankForLevel(level);
        String effectiveRankName = this.player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(data -> {
            if (data.isCustomTitleEnabled() && !data.getCustomTitle().isEmpty()) {
                return data.getCustomTitle();
            }
            return baseRankName;
        }).orElse(baseRankName);
        String titleText = playerName + " - " + effectiveRankName;
        int titleWidth = font.m_92895_(titleText);
        int titleX = this.leftPos + (256 - titleWidth) / 2;
        int titleY = this.topPos + 10;
        gui.m_280056_(font, titleText, titleX, titleY, 0xFFFFFF, true);
        if (this.openTitlesButton != null) {
            int btnX = titleX + titleWidth + 4;
            int btnY = titleY - 2;
            this.openTitlesButton.m_252865_(btnX);
            this.openTitlesButton.m_253211_(btnY);
        }
        int barWidth = 200;
        int barHeight = 12;
        int barX = this.leftPos + (256 - barWidth) / 2;
        int barY = this.topPos + 48;
        gui.m_280509_(barX, barY, barX + barWidth, barY + barHeight, -14671840);
        gui.m_280509_(barX - 1, barY - 1, barX + barWidth + 1, barY, -16777216);
        gui.m_280509_(barX - 1, barY + barHeight, barX + barWidth + 1, barY + barHeight + 1, -16777216);
        gui.m_280509_(barX - 1, barY, barX, barY + barHeight, -16777216);
        gui.m_280509_(barX + barWidth, barY, barX + barWidth + 1, barY + barHeight, -16777216);
        int filledWidth = (int)((double)barWidth * percent);
        int xpColor = isMax ? -10496 : -10832385;
        gui.m_280509_(barX + 1, barY + 1, barX + filledWidth - 1, barY + barHeight - 1, xpColor);
        String xpText = isMax ? Component.m_237110_((String)"tooltip.levelingrank.player_xp_max", (Object[])new Object[]{xp}).getString() : Component.m_237110_((String)"tooltip.levelingrank.player_xp", (Object[])new Object[]{xp, xpNeeded}).getString();
        int xpTextWidth = font.m_92895_(xpText);
        int xpTextX = this.leftPos + (256 - xpTextWidth) / 2;
        Objects.requireNonNull(font);
        int xpTextY = barY + (barHeight - 9) / 2 + 1;
        gui.m_280056_(font, xpText, xpTextX, xpTextY, -3355444, true);
        String leftLv = "Lv " + level;
        Object rightLv = isMax ? "MAX" : "Lv " + nextLevel;
        float scale = 0.8f;
        PoseStack pose = gui.m_280168_();
        pose.m_85836_();
        int rawWidth = font.m_92895_(leftLv);
        int scaledWidth = (int)((float)rawWidth * scale);
        int baseX = barX;
        Objects.requireNonNull(font);
        int baseY = barY - 9 - 4;
        pose.m_252880_((float)baseX, (float)baseY, 0.0f);
        pose.m_85841_(scale, scale, 1.0f);
        gui.m_280056_(font, leftLv, 0, 0, -1052689, false);
        pose.m_85849_();
        pose = gui.m_280168_();
        pose.m_85836_();
        rawWidth = font.m_92895_((String)rightLv);
        scaledWidth = (int)((float)rawWidth * scale);
        baseX = barX + barWidth - scaledWidth;
        Objects.requireNonNull(font);
        baseY = barY - 9 - 4;
        pose.m_252880_((float)baseX, (float)baseY, 0.0f);
        pose.m_85841_(scale, scale, 1.0f);
        gui.m_280056_(font, (String)rightLv, 0, 0, -1052689, false);
        pose.m_85849_();
    }

    private static boolean isRewardClaimedClient(Player player, int level) {
        if (player == null) {
            return false;
        }
        return player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(data -> data.hasClaimedRewardLevel(level)).orElse(false);
    }

    private void renderLevelInfoLine(GuiGraphics gui, int mouseX, int mouseY) {
        int level;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        Font font = mc.f_91062_;
        int slotSize = 18;
        int totalSlots = 10;
        int spacing = 4;
        int lineWidth = totalSlots * slotSize + (totalSlots - 1) * spacing;
        int rewardTitleY = this.topPos + 80;
        int rewardLineY = rewardTitleY + 14;
        int lineX = this.leftPos + (256 - lineWidth) / 2;
        int infoLineY = rewardLineY - (slotSize + 6) + 18 + 7;
        int baseLevel = this.rewardPage * 10 + 1;
        ItemStack infoIcon = new ItemStack((ItemLike)Items.f_42517_);
        for (int i = 0; i < totalSlots && (level = baseLevel + i) <= 200; ++i) {
            int x = lineX + i * (slotSize + spacing);
            int y = infoLineY;
            gui.m_280509_(x, y, x + slotSize, y + slotSize, -2145378272);
            gui.m_280509_(x, y, x + slotSize, y + 1, -16777216);
            gui.m_280509_(x, y + slotSize - 1, x + slotSize, y + slotSize, -16777216);
            gui.m_280509_(x, y, x + 1, y + slotSize, -16777216);
            gui.m_280509_(x + slotSize - 1, y, x + slotSize, y + slotSize, -16777216);
            gui.m_280480_(infoIcon, x + 1, y + 1);
            if (mouseX < x || mouseX > x + slotSize || mouseY < y || mouseY > y + slotSize) continue;
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237110_((String)"tooltip.levelingrank.level_info_header", (Object[])new Object[]{level}));
            tooltip.add(Component.m_237119_());
            tooltip.add(Component.m_237115_((String)"tooltip.levelingrank.level_info_attributes_header"));
            tooltip.add(Component.m_237110_((String)"tooltip.levelingrank.level_info_armor", (Object[])new Object[]{40}));
            tooltip.add(Component.m_237119_());
            tooltip.add(Component.m_237115_((String)"tooltip.levelingrank.level_info_rarity_header"));
            tooltip.add(Component.m_237119_());
            List<WeaponRarityUtil.RarityData> pool = WeaponRarityUtil.getAvailableRarities(level);
            int count = Math.min(3, pool.size());
            for (int idx = pool.size() - count; idx < pool.size(); ++idx) {
                WeaponRarityUtil.RarityData r = pool.get(idx);
                tooltip.add(Component.m_237115_((String)r.rarityKey).m_130938_(style -> style.m_178520_(r.colorHex)));
            }
            gui.m_280666_(font, tooltip, mouseX, mouseY);
        }
    }

    private void renderRewards(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        Font font = mc.f_91062_;
        int playerLevel = mc.f_91074_.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(data -> data.getLevel()).orElse(1);
        String rewardTitle = Component.m_237115_((String)"screen.levelingrank.rewards").getString();
        int titleWidth = font.m_92895_(rewardTitle);
        int titleX = this.leftPos + (256 - titleWidth) / 2;
        int titleY = this.topPos + 80;
        gui.m_280056_(font, rewardTitle, titleX, titleY, 0xFFFFFF, true);
        int slotSize = 18;
        int totalSlots = 10;
        int spacing = 4;
        int lineWidth = totalSlots * slotSize + (totalSlots - 1) * spacing;
        int lineX = this.leftPos + (256 - lineWidth) / 2;
        int lineY = titleY + 14 + 18 + 7;
        List<LevelRewardHandler.LevelReward> rewards = LevelRewardHandler.getRewardsForPage(this.rewardPage, 10);
        for (int i = 0; i < totalSlots; ++i) {
            boolean canClaim;
            LevelRewardHandler.LevelReward reward;
            ItemStack stack;
            int x = lineX + i * (slotSize + spacing);
            int y = lineY;
            gui.m_280509_(x, y, x + slotSize, y + slotSize, Integer.MIN_VALUE);
            gui.m_280509_(x, y, x + slotSize, y + 1, -16777216);
            gui.m_280509_(x, y + slotSize - 1, x + slotSize, y + slotSize, -16777216);
            gui.m_280509_(x, y, x + 1, y + slotSize, -16777216);
            gui.m_280509_(x + slotSize - 1, y, x + slotSize, y + slotSize, -16777216);
            if (i >= rewards.size() || (stack = LevelRewardHandler.toStack(reward = rewards.get(i))).m_41619_()) continue;
            gui.m_280480_(stack, x + 1, y + 1);
            gui.m_280370_(font, stack, x + 1, y + 1);
            boolean claimed = LevelingRankInventoryScreen.isRewardClaimedClient((Player)mc.f_91074_, reward.level);
            boolean bl = canClaim = playerLevel >= reward.level && !claimed;
            int levelColor = claimed ? -5592406 : (canClaim ? -11141291 : -43691);
            String lvlText = "Lv " + reward.level;
            float scale = 0.5f;
            int rawWidth = font.m_92895_(lvlText);
            int scaledWidth = (int)((float)rawWidth * scale);
            int baseX = x + (slotSize - scaledWidth) / 2;
            int baseY = y + slotSize + 4;
            PoseStack pose = gui.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)baseX, (float)baseY, 0.0f);
            pose.m_85841_(scale, scale, 1.0f);
            gui.m_280056_(font, lvlText, 0, 0, levelColor, false);
            pose.m_85849_();
        }
        int arrowY = lineY + slotSize / 2 - 5;
        int leftArrowX = lineX - 16;
        int rightArrowX = lineX + lineWidth + 6;
        String leftArrow = "<";
        String rightArrow = ">";
        int leftColor = this.rewardPage > 0 ? -1 : -11184811;
        int rightColor = LevelRewardHandler.hasNextPage(this.rewardPage, 10) ? -1 : -11184811;
        gui.m_280056_(font, leftArrow, leftArrowX, arrowY, leftColor, false);
        gui.m_280056_(font, rightArrow, rightArrowX, arrowY, rightColor, false);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.handleRewardClick(mouseX, mouseY)) {
                return true;
            }
            if (this.handlePageClick(mouseX, mouseY)) {
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private boolean handlePageClick(double mouseX, double mouseY) {
        int slotSize = 18;
        int spacing = 4;
        int totalSlots = 10;
        int lineWidth = totalSlots * slotSize + (totalSlots - 1) * spacing;
        int lineX = this.leftPos + (256 - lineWidth) / 2;
        int titleY = this.topPos + 80;
        int lineY = titleY + 14 + 18 + 7;
        int arrowY = lineY + slotSize / 2 - 4;
        int leftArrowX = lineX - 16;
        int rightArrowX = lineX + lineWidth + 6;
        if (mouseX >= (double)leftArrowX && mouseX <= (double)(leftArrowX + 10) && mouseY >= (double)arrowY && mouseY <= (double)(arrowY + 10)) {
            if (this.rewardPage > 0) {
                --this.rewardPage;
            }
            return true;
        }
        if (mouseX >= (double)rightArrowX && mouseX <= (double)(rightArrowX + 10) && mouseY >= (double)arrowY && mouseY <= (double)(arrowY + 10)) {
            if (LevelRewardHandler.hasNextPage(this.rewardPage, 10)) {
                ++this.rewardPage;
            }
            return true;
        }
        return false;
    }

    private boolean handleRewardClick(double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return false;
        }
        LocalPlayer player = mc.f_91074_;
        int playerLevel = player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(data -> data.getLevel()).orElse(1);
        int slotSize = 18;
        int spacing = 4;
        int totalSlots = 10;
        int lineWidth = totalSlots * slotSize + (totalSlots - 1) * spacing;
        int lineX = this.leftPos + (256 - lineWidth) / 2;
        int titleY = this.topPos + 80;
        int lineY = titleY + 14 + 18 + 7;
        List<LevelRewardHandler.LevelReward> rewards = LevelRewardHandler.getRewardsForPage(this.rewardPage, 10);
        for (int i = 0; i < totalSlots; ++i) {
            int x = lineX + i * (slotSize + spacing);
            int y = lineY;
            if (!(mouseX >= (double)x) || !(mouseX <= (double)(x + slotSize)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + slotSize))) continue;
            if (i >= rewards.size()) {
                return true;
            }
            LevelRewardHandler.LevelReward reward = rewards.get(i);
            if (playerLevel < reward.level) {
                player.m_5661_((Component)Component.m_237110_((String)"message.levelingrank.reward_locked", (Object[])new Object[]{reward.level}), true);
                return true;
            }
            if (LevelingRankInventoryScreen.isRewardClaimedClient((Player)player, reward.level)) {
                player.m_5661_((Component)Component.m_237110_((String)"message.levelingrank.reward_already_claimed", (Object[])new Object[]{reward.level}), true);
                return true;
            }
            if (this.isInventoryFull((Player)player)) {
                player.m_5661_((Component)Component.m_237115_((String)"message.levelingrank.reward_full_inventory"), true);
                return true;
            }
            ModNetworkHandler.sendClaimReward(reward.level);
            player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> data.addClaimedRewardLevel(reward.level));
            return true;
        }
        return false;
    }

    private boolean isInventoryFull(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    private static String getRankForLevel(int level) {
        int tier = level / 10;
        String key = switch (tier) {
            case 0 -> "rank.levelingrank.novice";
            case 1 -> "rank.levelingrank.explorer";
            case 2 -> "rank.levelingrank.guardian";
            case 3 -> "rank.levelingrank.master";
            case 4 -> "rank.levelingrank.walker";
            case 5 -> "rank.levelingrank.forger";
            case 6 -> "rank.levelingrank.lord";
            case 7 -> "rank.levelingrank.unstoppable";
            case 8 -> "rank.levelingrank.legend";
            default -> "rank.levelingrank.immortal";
        };
        return Component.m_237115_((String)key).getString();
    }
}

