/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.client.screendata;

import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.network.ModNetworkHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class TitleSelectScreen
extends Screen {
    private final Player player;
    private final Screen parent;
    private int leftPos;
    private int topPos;
    private List<TitleOption> unlockedTitles = new ArrayList<TitleOption>();
    private static final TitleOption[] ALL_TITLES = new TitleOption[]{new TitleOption("rank.levelingrank.novice", 1), new TitleOption("rank.levelingrank.explorer", 10), new TitleOption("rank.levelingrank.guardian", 20), new TitleOption("rank.levelingrank.master", 30), new TitleOption("rank.levelingrank.walker", 40), new TitleOption("rank.levelingrank.forger", 50), new TitleOption("rank.levelingrank.lord", 60), new TitleOption("rank.levelingrank.unstoppable", 70), new TitleOption("rank.levelingrank.legend", 80), new TitleOption("rank.levelingrank.immortal", 90)};

    public TitleSelectScreen(Player player) {
        this(player, Minecraft.m_91087_().f_91080_);
    }

    public TitleSelectScreen(Player player, Screen parent) {
        super((Component)Component.m_237115_((String)"screen.levelingrank.title_select"));
        this.player = player;
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        int guiWidth = 200;
        int guiHeight = 180;
        this.leftPos = (this.f_96543_ - guiWidth) / 2;
        this.topPos = (this.f_96544_ - guiHeight) / 2;
        int playerLevel = this.player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(data -> data.getLevel()).orElse(1);
        this.unlockedTitles.clear();
        for (TitleOption opt : ALL_TITLES) {
            if (playerLevel < opt.minLevel) continue;
            this.unlockedTitles.add(opt);
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.back"), b -> this.m_7379_()).m_252987_(this.leftPos + guiWidth - 60, this.topPos + guiHeight - 22, 56, 18).m_253136_());
        int startY = this.topPos + 30;
        int rowHeight = 20;
        int btnWidth = guiWidth - 20;
        for (int i = 0; i < this.unlockedTitles.size(); ++i) {
            TitleOption opt = this.unlockedTitles.get(i);
            int y = startY + i * rowHeight;
            if (y + rowHeight > this.topPos + guiHeight - 30) break;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)opt.getDisplayName(), b -> this.selectTitle(opt)).m_252987_(this.leftPos + 10, y, btnWidth, 18).m_253136_());
        }
    }

    private void selectTitle(TitleOption opt) {
        String titleText = opt.getDisplayName().getString();
        ModNetworkHandler.sendSetCustomTitle(titleText, true);
        this.m_7379_();
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(gui);
        int guiWidth = 200;
        int guiHeight = 180;
        int right = this.leftPos + guiWidth;
        int bottom = this.topPos + guiHeight;
        gui.m_280509_(this.leftPos, this.topPos, right, bottom, -1442840576);
        Font font = Minecraft.m_91087_().f_91062_;
        String title = Component.m_237115_((String)"screen.levelingrank.title_select").getString();
        int tw = font.m_92895_(title);
        gui.m_280056_(font, title, this.leftPos + (guiWidth - tw) / 2, this.topPos + 10, 0xFFFFFF, true);
        super.m_88315_(gui, mouseX, mouseY, partialTick);
    }

    private static class TitleOption {
        final String key;
        final int minLevel;

        TitleOption(String key, int minLevel) {
            this.key = key;
            this.minLevel = minLevel;
        }

        Component getDisplayName() {
            return Component.m_237115_((String)this.key);
        }
    }
}

