/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.commands;

import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.network.ModNetworkHandler;
import com.everydayxp.levelingrank.network.SyncAllJsonConfigsS2CPacket;
import com.everydayxp.levelingrank.sound.ModSounds;
import com.everydayxp.levelingrank.util.JsonRestrictionUtil;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;

@Mod.EventBusSubscriber(modid="levelingrank")
public class LevelCommandHandler {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"level").then(Commands.m_82127_((String)"mylevel").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> player.m_213846_((Component)Component.m_237110_((String)"command.levelingrank.mylevel", (Object[])new Object[]{data.getLevel(), data.getXP()})));
            return 1;
        }))).then(Commands.m_82127_((String)"xpneeded").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> {
                int xpNext = data.getXPForNextLevel();
                int missingXP = xpNext - data.getXP();
                player.m_213846_((Component)Component.m_237110_((String)"command.levelingrank.xpneeded", (Object[])new Object[]{missingXP}));
            });
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"up").requires(src -> src.m_6761_(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> {
                int beforeLevel = data.getLevel();
                int missing = data.getXPForNextLevel() - data.getXP();
                data.addXP(missing);
                if (data.getLevel() > beforeLevel) {
                    player.m_6330_((SoundEvent)ModSounds.LEVEL_UP_CUSTOM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                ModNetworkHandler.syncLevelData(player, data);
                player.m_213846_((Component)Component.m_237110_((String)"command.levelingrank.levelup", (Object[])new Object[]{data.getLevel()}));
            });
            return 1;
        })).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)200)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> {
                for (int i = 0; i < amount && data.getLevel() < 200; ++i) {
                    int missing = data.getXPForNextLevel() - data.getXP();
                    data.addXP(missing);
                }
                ModNetworkHandler.syncLevelData(player, data);
                player.m_213846_((Component)Component.m_237110_((String)"command.levelingrank.levelup", (Object[])new Object[]{data.getLevel()}));
            });
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)200)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            int target = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> {
                int beforeLevel = data.getLevel();
                int safeTarget = Math.min(target, 200);
                data.setLevel(safeTarget);
                data.setXP(0);
                if (data.getLevel() > beforeLevel) {
                    player.m_6330_((SoundEvent)ModSounds.LEVEL_UP_CUSTOM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                ModNetworkHandler.syncLevelData(player, data);
                player.m_213846_((Component)Component.m_237110_((String)"command.levelingrank.setlevel", (Object[])new Object[]{data.getLevel()}));
            });
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"addxp").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> {
                int beforeLevel = data.getLevel();
                int newXP = data.getXP() + amount;
                data.setXP(newXP);
                if (data.getLevel() > beforeLevel) {
                    player.m_6330_((SoundEvent)ModSounds.LEVEL_UP_CUSTOM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                ModNetworkHandler.syncLevelData(player, data);
                player.m_213846_((Component)Component.m_237110_((String)"command.levelingrank.addxp", (Object[])new Object[]{amount, data.getXP()}));
            });
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").requires(src -> src.m_6761_(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> {
                data.setLevel(1);
                data.setXP(0);
                ModNetworkHandler.syncLevelData(player, data);
                player.m_213846_((Component)Component.m_237115_((String)"command.levelingrank.resetlevel"));
            });
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"infoplayer").requires(src -> src.m_6761_(2))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> {
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"target");
            target.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("[" + target.m_7755_().getString() + "] ")).m_7220_((Component)Component.m_237113_((String)("Level: " + data.getLevel() + " XP: " + data.getXP())).m_130940_(ChatFormatting.YELLOW)), false));
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(src -> src.m_6761_(2))).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            MinecraftServer server = source.m_81377_();
            HashMap<String, Map<String, Object>> all = new HashMap<String, Map<String, Object>>();
            all.put("armor", JsonRestrictionUtil.loadRawJson("armor_restrictions.json"));
            all.put("weapon", JsonRestrictionUtil.loadRawJson("weapon_restrictions.json"));
            all.put("gui", JsonRestrictionUtil.loadRawJson("gui_restrictions.json"));
            all.put("mineable", JsonRestrictionUtil.loadRawJson("mineable_restrictions.json"));
            all.put("entity", JsonRestrictionUtil.loadRawJson("entity_levels.json"));
            all.put("reward", JsonRestrictionUtil.loadRawJson("level_rewards.json"));
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                ModNetworkHandler.CHANNEL.sendTo((Object)new SyncAllJsonConfigsS2CPacket(all), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
            source.m_288197_(() -> Component.m_237115_((String)"command.levelingrank.reload").m_130940_(ChatFormatting.GREEN), true);
            return 1;
        })));
    }
}

