/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.config;

import com.everydayxp.levelingrank.config.ArmorRestrictionMode;
import com.everydayxp.levelingrank.config.HudPosition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="levelingrank", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LevelingRankConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec CONFIG;
    public static final ForgeConfigSpec.BooleanValue SHOW_PLAYER_HUD;
    public static final ForgeConfigSpec.BooleanValue SHOW_OTHER_PLAYER_LEVELS;
    public static final ForgeConfigSpec.BooleanValue SHOW_MOB_LEVELS;
    public static final ForgeConfigSpec.BooleanValue SHOW_SELF_LEVEL;
    public static final ForgeConfigSpec.BooleanValue SHOW_VANILLA_ATTRIBUTES;
    public static final ForgeConfigSpec.EnumValue<HudPosition> HUD_POSITION_ENUM;
    public static final ForgeConfigSpec.EnumValue<ArmorRestrictionMode> ARMOR_RESTRICTION_MODE;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> LIFE_BONUS_ENTITY_BLACKLIST;
    public static final ForgeConfigSpec.DoubleValue LIFE_BONUS_SCALE;
    public static final ForgeConfigSpec.DoubleValue LIFE_BONUS_SCALE_BOSS;
    public static final ForgeConfigSpec.BooleanValue ENABLE_ATTACK_BONUS;
    public static final ForgeConfigSpec.DoubleValue ATTACK_BONUS_SCALE;
    public static final ForgeConfigSpec.BooleanValue ENABLE_AFK_TRACKER;
    public static final ForgeConfigSpec.BooleanValue ENABLE_HARD_LEVEL_BLOCK;
    public static final ForgeConfigSpec.DoubleValue MOB_KILL_XP_BASE;
    public static final ForgeConfigSpec.DoubleValue HP_XP_SCALE;
    public static final ForgeConfigSpec.BooleanValue SHOW_XP_FLOATING_HUD;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> DIMENSION_LEVELS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> DIMENSION_XP_BONUS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ULTRA_MINING_BLOCKS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ULTRA_MINING_TAGS;
    public static final ForgeConfigSpec.BooleanValue ENABLE_DEBUG_LOGS;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)CONFIG);
    }

    private static List<String> defaultUltraMiningBlocks() {
        return List.of("minecraft:coal_ore=2", "minecraft:deepslate_coal_ore=2", "minecraft:redstone_ore=3", "minecraft:deepslate_redstone_ore=3", "minecraft:copper_ore=3", "minecraft:deepslate_copper_ore=3", "minecraft:iron_ore=3", "minecraft:deepslate_iron_ore=3", "minecraft:nether_quartz_ore=3", "minecraft:nether_gold_ore=3", "minecraft:lapis_ore=4", "minecraft:deepslate_lapis_ore=4", "minecraft:diamond_ore=5", "minecraft:deepslate_diamond_ore=5", "minecraft:emerald_ore=7", "minecraft:deepslate_emerald_ore=7", "minecraft:ancient_debris=10");
    }

    private static List<? extends String> defaultLevels() {
        return List.of("minecraft:the_nether=50", "minecraft:the_end=60", "twilightforest:twilight_forest=25");
    }

    private static List<? extends String> defaultBlacklist() {
        return List.of("powerful_dummy:dummy_stand", "dummmmmmy:target_dummy", "minecraft:phantom", "minecraft:creeper", "minecraft:armor_stand", "minecraft:vex", "mowziesmobs:umvuthana", "mowziesmobs:umvuthana_crane", "mowziesmobs:umvuthana_follower_raptor");
    }

    public static List<? extends String> getLifeBonusEntityBlacklist() {
        return (List)LIFE_BONUS_ENTITY_BLACKLIST.get();
    }

    public static Map<String, Integer> getDimensionRestrictionMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String entry : (List)DIMENSION_LEVELS.get()) {
            String[] split = entry.split("=");
            if (split.length != 2) continue;
            try {
                map.put(split[0].trim(), Integer.parseInt(split[1].trim()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return map;
    }

    public static Map<String, Integer> getUltraMiningBlockXPMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String entry : (List)ULTRA_MINING_BLOCKS.get()) {
            String[] split = entry.split("=");
            if (split.length != 2) continue;
            try {
                map.put(split[0].trim(), Integer.parseInt(split[1].trim()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return map;
    }

    public static Map<String, Integer> getUltraMiningTagXPMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String entry : (List)ULTRA_MINING_TAGS.get()) {
            String[] split = entry.split("=");
            if (split.length != 2) continue;
            try {
                map.put(split[0].trim(), Integer.parseInt(split[1].trim()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return map;
    }

    public static Map<String, Double> getDimensionXPBonusMap() {
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (String entry : (List)DIMENSION_XP_BONUS.get()) {
            String[] split = entry.split("=");
            if (split.length != 2) continue;
            try {
                map.put(split[0].trim(), Double.parseDouble(split[1].trim()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return map;
    }

    public static double getMobKillXPBase() {
        return (Double)MOB_KILL_XP_BASE.get();
    }

    static {
        BUILDER.comment("Visual options").push("visual");
        SHOW_PLAYER_HUD = BUILDER.comment("Show leveling HUD overlay for the player? (true/false)").define("show_player_hud", true);
        SHOW_OTHER_PLAYER_LEVELS = BUILDER.comment("Show level above other players? (true/false)").define("show_other_player_levels", true);
        SHOW_MOB_LEVELS = BUILDER.comment("Show mob levels above mobs? (true/false)").define("show_mob_levels", true);
        SHOW_SELF_LEVEL = BUILDER.comment("Show your own name and level above yourself in third person? (true/false)").define("show_self_level", true);
        SHOW_VANILLA_ATTRIBUTES = BUILDER.comment("Show vanilla attribute tooltip on weapons? (true = show vanilla, false = hide and only show custom tooltip)").define("show_vanilla_attributes", true);
        HUD_POSITION_ENUM = BUILDER.comment("HUD position on screen.").defineEnum("hud_position", (Enum)HudPosition.BOTTOM_LEFT);
        BUILDER.pop();
        BUILDER.comment("Armor restriction options").push("armor_restriction");
        ARMOR_RESTRICTION_MODE = BUILDER.comment("Armor level restriction mode: NONE, JSON_ONLY, AUTOMATIC").defineEnum("armor_restriction_mode", (Enum)ArmorRestrictionMode.AUTOMATIC);
        BUILDER.pop();
        BUILDER.comment("Mob and weapon scaling options").push("scaling");
        LIFE_BONUS_ENTITY_BLACKLIST = BUILDER.comment("Entity blacklist for health bonus. Use registry names, e.g.: minecraft:villager, minecraft:iron_golem").defineList("life_bonus_entity_blacklist", LevelingRankConfig.defaultBlacklist(), s -> s instanceof String);
        LIFE_BONUS_SCALE = BUILDER.comment("Scaling multiplier per level for health bonus (example: 0.2 = +20% per level)").defineInRange("life_bonus_scale", 0.2, 0.0, 10.0);
        LIFE_BONUS_SCALE_BOSS = BUILDER.comment("Scaling multiplier per level for boss health bonus (example: 0.6 = +60% per level)").defineInRange("life_bonus_scale_boss", 0.6, 0.0, 10.0);
        ENABLE_ATTACK_BONUS = BUILDER.comment("Enable level-based attack bonus? (true/false)").define("enable_attack_bonus", false);
        ATTACK_BONUS_SCALE = BUILDER.comment("Scaling multiplier per level for attack bonus (example: 0.015 = +1.5% per level)").defineInRange("attack_bonus_scale", 0.015, 0.0, 10.0);
        ENABLE_HARD_LEVEL_BLOCK = BUILDER.comment("If true, mobs 9+ levels above the player cannot be damaged. If false, damage is reduced instead.").define("enable_hard_level_block", false);
        BUILDER.pop();
        BUILDER.comment("XP options").push("xp");
        MOB_KILL_XP_BASE = BUILDER.comment("Amount of XP gained for killing a mob (default: 32)").defineInRange("mob_kill_xp_base", 32.0, 0.0, 10000.0);
        HP_XP_SCALE = BUILDER.comment("Scale of the extra XP bonus based on the mob's final maximum health (only affects the bonus, not the base XP).").defineInRange("hp_xp_scale", 0.2, 0.0, 10.0);
        SHOW_XP_FLOATING_HUD = BUILDER.comment("Show floating XP HUD numbers on screen when gaining XP? (true/false)").define("show_xp_floating_hud", true);
        BUILDER.pop();
        BUILDER.comment("Dimension restrictions and bonuses").push("dimensions");
        DIMENSION_LEVELS = BUILDER.comment("List of dimension requirements, format: dimension=level").defineList("dimension_levels", LevelingRankConfig.defaultLevels(), s -> s instanceof String);
        DIMENSION_XP_BONUS = BUILDER.comment("Dimensional XP bonus list. Format: dimension_id=multiplier (e.g. minecraft:the_nether=1.5 for +50% XP).").defineList("dimension_xp_bonus", List.of("minecraft:overworld=1.0", "minecraft:the_nether=1.5", "minecraft:the_end=2.0"), s -> s instanceof String);
        ENABLE_AFK_TRACKER = BUILDER.comment("Enable detection and blocking of XP for AFK (auto/idle) players (default: true)").define("enable_afk_tracker", true);
        BUILDER.pop();
        BUILDER.comment("Ultra Mining options").push("ultra_mining");
        ULTRA_MINING_BLOCKS = BUILDER.comment("List of blocks that give XP in Ultra Mining Day with XP amount (format: blockid=xp), e.g. minecraft:diamond_ore=5").defineList("ultra_mining_blocks", LevelingRankConfig.defaultUltraMiningBlocks(), s -> s instanceof String);
        ULTRA_MINING_TAGS = BUILDER.comment("List of block tags that give XP in Ultra Mining Day with XP amount (format: tag=xp), e.g. forge:ores/diamond=5").defineList("ultra_mining_tags", List.of(), s -> s instanceof String);
        BUILDER.pop();
        BUILDER.comment("Debug and logging options").push("debug");
        ENABLE_DEBUG_LOGS = BUILDER.comment("Enable or disable debug logs for sync and XP events (default: false)").define("enable_debug_logs", false);
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }
}

