/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.events;

import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.network.ModNetworkHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="levelingrank")
public class DailyXPBonusHandler {
    private static long lastDay = -1L;
    private static int dailyXPBonus = 100;
    private static int previousXPBonus = 100;
    private static boolean ultraSpecialMiningDay = false;
    private static final Random random = new Random();
    private static double eventPity = 0.0;
    private static Map<String, Integer> blockXpMap = Map.of();
    private static Map<String, Integer> tagXpMap = Map.of();
    private static final Map<UUID, Integer> xpAccumulated = new HashMap<UUID, Integer>();

    public static void setMiningXpMaps(Map<String, Integer> blockMap, Map<String, Integer> tagMap) {
        blockXpMap = blockMap;
        tagXpMap = tagMap;
    }

    public static void accumulateXPForPlayer(UUID playerUUID, int amount) {
        if (playerUUID == null) {
            return;
        }
        xpAccumulated.merge(playerUUID, amount, Integer::sum);
    }

    public static void forceSetEvent(int bonus, boolean ultra) {
        dailyXPBonus = bonus;
        ultraSpecialMiningDay = ultra;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        block17: {
            MinecraftServer server;
            block19: {
                block18: {
                    boolean dayBeforeHadBonus;
                    if (event.phase != TickEvent.Phase.END) {
                        return;
                    }
                    server = event.getServer();
                    if (server == null) {
                        return;
                    }
                    long currentDay = server.m_129783_().m_46468_() / 24000L;
                    if (currentDay == lastDay) break block17;
                    lastDay = currentDay;
                    previousXPBonus = dailyXPBonus;
                    for (ServerPlayer player : server.m_6846_().m_11314_()) {
                        UUID uuid = player.m_20148_();
                        int totalXP = xpAccumulated.getOrDefault(uuid, 0);
                        if (totalXP > 0) {
                            player.m_213846_((Component)Component.m_237110_((String)"message.levelingrank.daily_xp_total", (Object[])new Object[]{totalXP}).m_130940_(ChatFormatting.GOLD));
                        }
                        if (previousXPBonus == 200) {
                            player.m_213846_((Component)Component.m_237115_((String)"message.levelingrank.daily_event_special_end").m_130940_(ChatFormatting.GOLD));
                            continue;
                        }
                        if (previousXPBonus == 300) {
                            player.m_213846_((Component)Component.m_237115_((String)"message.levelingrank.daily_event_epic_end").m_130940_(ChatFormatting.LIGHT_PURPLE));
                            continue;
                        }
                        if (previousXPBonus != 500) continue;
                        player.m_213846_((Component)Component.m_237115_((String)"message.levelingrank.daily_event_ultra_end").m_130940_(ChatFormatting.AQUA));
                    }
                    xpAccumulated.clear();
                    boolean bl = dayBeforeHadBonus = previousXPBonus > 100;
                    if (dayBeforeHadBonus) {
                        dailyXPBonus = 100;
                        ultraSpecialMiningDay = false;
                        eventPity = 0.0;
                    } else {
                        double baseEventChance = 0.25;
                        double totalEventChance = Math.min(baseEventChance + eventPity, 1.0);
                        double rollEvent = random.nextDouble();
                        if (rollEvent > totalEventChance) {
                            dailyXPBonus = 100;
                            ultraSpecialMiningDay = false;
                            eventPity = Math.min(eventPity + 0.1, 1.0);
                        } else {
                            eventPity = 0.0;
                            int roll = random.nextInt(1000);
                            if (roll < 600) {
                                dailyXPBonus = 200;
                                ultraSpecialMiningDay = false;
                            } else if (roll < 900) {
                                dailyXPBonus = 300;
                                ultraSpecialMiningDay = false;
                            } else {
                                dailyXPBonus = 500;
                                ultraSpecialMiningDay = true;
                            }
                        }
                    }
                    if (dailyXPBonus != 200) break block18;
                    MutableComponent inicioEvento = Component.m_237110_((String)"message.levelingrank.daily_event_special", (Object[])new Object[]{dailyXPBonus}).m_130940_(ChatFormatting.GOLD);
                    server.m_6846_().m_240416_((Component)inicioEvento, false);
                    for (ServerPlayer player : server.m_6846_().m_11314_()) {
                        player.m_5496_(SoundEvents.f_12496_, 1.0f, 1.0f);
                    }
                    break block17;
                }
                if (dailyXPBonus != 300) break block19;
                MutableComponent inicioEvento = Component.m_237110_((String)"message.levelingrank.daily_event_epic", (Object[])new Object[]{dailyXPBonus}).m_130940_(ChatFormatting.LIGHT_PURPLE);
                server.m_6846_().m_240416_((Component)inicioEvento, false);
                for (ServerPlayer player : server.m_6846_().m_11314_()) {
                    player.m_5496_(SoundEvents.f_12496_, 1.0f, 1.0f);
                }
                break block17;
            }
            if (!ultraSpecialMiningDay) break block17;
            MutableComponent inicioEvento = Component.m_237115_((String)"message.levelingrank.daily_event_ultra").m_130940_(ChatFormatting.AQUA);
            server.m_6846_().m_240416_((Component)inicioEvento, false);
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                player.m_5496_(SoundEvents.f_12496_, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!ultraSpecialMiningDay) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null || player.m_9236_().m_5776_()) {
            return;
        }
        ResourceLocation blockKey = ForgeRegistries.BLOCKS.getKey((Object)event.getState().m_60734_());
        if (blockKey == null) {
            return;
        }
        int miningXp = blockXpMap.getOrDefault(blockKey.toString(), 0);
        Set blockTags = event.getState().m_204343_().map(tagKey -> tagKey.f_203868_()).collect(Collectors.toSet());
        if (miningXp <= 0) {
            for (ResourceLocation tag : blockTags) {
                int tagXP = tagXpMap.getOrDefault(tag.toString(), 0);
                if (tagXP <= 0) continue;
                miningXp = tagXP;
                break;
            }
        }
        if (miningXp <= 0 && blockTags.contains(new ResourceLocation("forge:ores"))) {
            miningXp = 2;
        }
        if (miningXp <= 0) {
            return;
        }
        int xpToGive = miningXp;
        player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(cap -> {
            cap.addXP(xpToGive);
            cap.tryLevelUp();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModNetworkHandler.syncLevelData(serverPlayer, cap.getLevel(), cap.getXP());
                xpAccumulated.merge(serverPlayer.m_20148_(), xpToGive, Integer::sum);
            }
        });
        player.m_213846_((Component)Component.m_237113_((String)("XP: " + xpToGive)).m_130940_(ChatFormatting.GREEN));
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        MinecraftServer server = serverPlayer.m_20194_();
        if (server == null) {
            return;
        }
        if (dailyXPBonus == 200) {
            msg = Component.m_237110_((String)"message.levelingrank.daily_event_special", (Object[])new Object[]{dailyXPBonus}).m_130940_(ChatFormatting.GOLD);
            serverPlayer.m_213846_((Component)msg);
        } else if (dailyXPBonus == 300) {
            msg = Component.m_237110_((String)"message.levelingrank.daily_event_epic", (Object[])new Object[]{dailyXPBonus}).m_130940_(ChatFormatting.LIGHT_PURPLE);
            serverPlayer.m_213846_((Component)msg);
        } else if (ultraSpecialMiningDay) {
            msg = Component.m_237115_((String)"message.levelingrank.daily_event_ultra").m_130940_(ChatFormatting.AQUA);
            serverPlayer.m_213846_((Component)msg);
        }
        int totalXP = xpAccumulated.getOrDefault(serverPlayer.m_20148_(), 0);
        if (totalXP > 0) {
            MutableComponent xpMsg = Component.m_237110_((String)"message.levelingrank.daily_xp_total", (Object[])new Object[]{totalXP}).m_130940_(ChatFormatting.GOLD);
            serverPlayer.m_213846_((Component)xpMsg);
        }
    }

    public static int getCurrentXPBonus() {
        return dailyXPBonus;
    }

    public static double getCurrentXPMultiplier() {
        return (double)dailyXPBonus / 100.0;
    }

    public static boolean isUltraSpecialMiningDay() {
        return ultraSpecialMiningDay;
    }
}

