/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.handler;

import com.everydayxp.levelingrank.capability.ILevelData;
import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.config.LevelingRankConfig;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="levelingrank")
public class DimensionRestrictionHandler {
    @SubscribeEvent
    public static void onTravelToDimension(EntityTravelToDimensionEvent event) {
        int playerLevel;
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ResourceLocation dimKey = event.getDimension().m_135782_();
        Map<String, Integer> restrictions = LevelingRankConfig.getDimensionRestrictionMap();
        Integer requiredLevel = restrictions.get(dimKey.toString());
        if (requiredLevel != null && (playerLevel = DimensionRestrictionHandler.getPlayerLevel((Player)player)) < requiredLevel) {
            event.setCanceled(true);
            player.m_5661_((Component)Component.m_237110_((String)"message.levelingrank.dimension_requirement", (Object[])new Object[]{requiredLevel}).m_130940_(ChatFormatting.RED), true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onJoinLevel(EntityJoinLevelEvent event) {
        int playerLevel;
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ResourceLocation dim = level.m_46472_().m_135782_();
        Map<String, Integer> restrictions = LevelingRankConfig.getDimensionRestrictionMap();
        Integer requiredLevel = restrictions.get(dim.toString());
        if (requiredLevel != null && (playerLevel = DimensionRestrictionHandler.getPlayerLevel((Player)player)) < requiredLevel) {
            event.setCanceled(true);
            player.m_5661_((Component)Component.m_237110_((String)"message.levelingrank.dimension_requirement", (Object[])new Object[]{requiredLevel}).m_130940_(ChatFormatting.RED), true);
        }
    }

    private static int getPlayerLevel(Player player) {
        return player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(ILevelData::getLevel).orElse(1);
    }
}

