/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.handler;

import com.everydayxp.levelingrank.attribute.ModAttributes;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="levelingrank")
public class DynamicAttributeApplier {
    private static final UUID DYNAMIC_PIERCE_UUID = UUID.fromString("aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee");
    private static final UUID DYNAMIC_ARMOR_SCORE_UUID = UUID.fromString("ffffffff-eeee-dddd-cccc-bbbbbbbbbbbb");

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        AttributeInstance armorScoreAttr;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        AttributeInstance pierceAttr = player.m_21051_((Attribute)ModAttributes.PIERCE.get());
        if (pierceAttr != null) {
            AttributeModifier old = pierceAttr.m_22111_(DYNAMIC_PIERCE_UUID);
            if (old != null) {
                pierceAttr.m_22130_(old);
            }
            double totalWeaponPierce = 0.0;
            ItemStack mainHand = player.m_6844_(EquipmentSlot.MAINHAND);
            if (!mainHand.m_41619_() && mainHand.m_41782_()) {
                totalWeaponPierce += mainHand.m_41783_().m_128459_("WeaponPierce");
            }
            if (totalWeaponPierce != 0.0) {
                pierceAttr.m_22125_(new AttributeModifier(DYNAMIC_PIERCE_UUID, "dynamic_weapon_pierce", totalWeaponPierce, AttributeModifier.Operation.ADDITION));
            }
        }
        if ((armorScoreAttr = player.m_21051_((Attribute)ModAttributes.ARMOR_SCORE.get())) != null) {
            AttributeModifier oldArmor = armorScoreAttr.m_22111_(DYNAMIC_ARMOR_SCORE_UUID);
            if (oldArmor != null) {
                armorScoreAttr.m_22130_(oldArmor);
            }
            double totalArmorScore = 0.0;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack armorPiece;
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (armorPiece = player.m_6844_(slot)).m_41619_() || !armorPiece.m_41782_()) continue;
                totalArmorScore += (double)armorPiece.m_41783_().m_128451_("ArmorScore");
            }
            if (totalArmorScore != 0.0) {
                armorScoreAttr.m_22125_(new AttributeModifier(DYNAMIC_ARMOR_SCORE_UUID, "dynamic_armor_score", totalArmorScore, AttributeModifier.Operation.ADDITION));
            }
        }
    }
}

