/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.handler;

import com.everydayxp.levelingrank.config.LevelingRankConfig;
import com.everydayxp.levelingrank.util.JsonRestrictionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="levelingrank")
public class LevelRewardHandler {
    private static final List<LevelReward> ALL_REWARDS = new ArrayList<LevelReward>();
    private static JsonRestrictionUtil.RestrictionData REWARD_DATA = JsonRestrictionUtil.forType("reward");

    public static void reload() {
        ALL_REWARDS.clear();
        REWARD_DATA = JsonRestrictionUtil.forType("reward");
        Object rewardsObj = LevelRewardHandler.REWARD_DATA.items.get("rewards");
        if (rewardsObj instanceof List) {
            List list = (List)rewardsObj;
            for (Object o : list) {
                Object countObj;
                if (!(o instanceof Map)) continue;
                Map m = (Map)o;
                LevelReward r2 = new LevelReward();
                Object levelObj = m.get("level");
                if (levelObj instanceof Number) {
                    Number n = (Number)levelObj;
                    r2.level = n.intValue();
                } else if (levelObj != null) {
                    try {
                        r2.level = (int)Double.parseDouble(levelObj.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Object itemObj = m.get("item");
                if (itemObj != null) {
                    r2.item = itemObj.toString();
                }
                if ((countObj = m.get("count")) instanceof Number) {
                    Number n = (Number)countObj;
                    r2.count = Math.max(1, n.intValue());
                } else if (countObj != null) {
                    try {
                        r2.count = Math.max(1, (int)Double.parseDouble(countObj.toString()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (r2.level <= 0 || r2.item == null) continue;
                ALL_REWARDS.add(r2);
            }
        }
        ALL_REWARDS.sort(Comparator.comparingInt(r -> r.level));
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[LevelingRank] Cargadas " + ALL_REWARDS.size() + " recompensas de nivel.");
        }
    }

    public static List<LevelReward> getAllRewards() {
        return Collections.unmodifiableList(ALL_REWARDS);
    }

    public static List<LevelReward> getRewardsForPage(int pageIndex, int pageSize) {
        int from = pageIndex * pageSize;
        int to = Math.min(from + pageSize, ALL_REWARDS.size());
        if (from >= ALL_REWARDS.size()) {
            return Collections.emptyList();
        }
        return ALL_REWARDS.subList(from, to);
    }

    public static ItemStack toStack(LevelReward reward) {
        if (reward == null || reward.item == null) {
            return ItemStack.f_41583_;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(reward.item));
        if (item == null) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)item, Math.max(1, reward.count));
    }

    public static boolean hasNextPage(int pageIndex, int pageSize) {
        return ALL_REWARDS.size() > (pageIndex + 1) * pageSize;
    }

    static {
        LevelRewardHandler.reload();
    }

    public static class LevelReward {
        public int level;
        public String item;
        public int count = 1;
    }
}

