/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.items.powerenchant;

import com.everydayxp.levelingrank.handler.WeaponRestrictionHandler;
import com.everydayxp.levelingrank.items.ModItems;
import com.everydayxp.levelingrank.items.powerenchant.PowerEnchantBlockEntity;
import com.everydayxp.levelingrank.menu.ModMenus;
import com.everydayxp.levelingrank.util.ArmorRarityUtil;
import com.everydayxp.levelingrank.util.WeaponRarityUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PowerEnchantMenu
extends AbstractContainerMenu {
    private static final int PLAYER_INV_X_OFFSET = 26;
    private static final int PLAYER_INV_Y_OFFSET = 36;
    @Nullable
    private final PowerEnchantBlockEntity blockEntity;
    private final Container container;
    public static final int MAX_TIER = 10;
    public static final int FREE_SAFE_TIER = 5;

    public PowerEnchantMenu(int id, Inventory playerInv, final @Nullable PowerEnchantBlockEntity blockEntity, @Nullable ContainerData data) {
        super((MenuType)ModMenus.POWER_ENCHANT_TABLE_MENU.get(), id);
        this.blockEntity = blockEntity;
        this.container = new SimpleContainer(1){

            public ItemStack m_8020_(int slot) {
                return blockEntity != null ? blockEntity.getItem(slot) : super.m_8020_(slot);
            }

            public void m_6836_(int slot, ItemStack stack) {
                if (blockEntity != null) {
                    blockEntity.setItem(slot, stack);
                } else {
                    super.m_6836_(slot, stack);
                }
            }

            public ItemStack m_7407_(int slot, int amount) {
                if (blockEntity != null) {
                    ItemStack stack = blockEntity.getItem(slot);
                    if (stack.m_41619_()) {
                        return ItemStack.f_41583_;
                    }
                    ItemStack result = stack.m_41620_(amount);
                    blockEntity.setItem(slot, stack);
                    return result;
                }
                return super.m_7407_(slot, amount);
            }

            public ItemStack m_8016_(int slot) {
                if (blockEntity != null) {
                    ItemStack stack = blockEntity.getItem(slot);
                    blockEntity.setItem(slot, ItemStack.f_41583_);
                    return stack;
                }
                return super.m_8016_(slot);
            }
        };
        ContainerData usedData = data != null ? data : new SimpleContainerData(2);
        this.m_38897_(new Slot(this.container, 0, 71, 30));
        int armorX = 34;
        int baseArmorY = 12;
        this.m_38897_(new Slot((Container)playerInv, 39, armorX, baseArmorY));
        this.m_38897_(new Slot((Container)playerInv, 38, armorX, baseArmorY + 18));
        this.m_38897_(new Slot((Container)playerInv, 37, armorX, baseArmorY + 36));
        this.m_38897_(new Slot((Container)playerInv, 36, armorX, baseArmorY + 54));
        this.m_38897_(new Slot((Container)playerInv, 40, armorX, baseArmorY + 72));
        this.addPlayerInventory(playerInv);
        this.addPlayerHotbar(playerInv);
        this.m_38884_(usedData);
    }

    public PowerEnchantMenu(int id, Inventory playerInv) {
        this(id, playerInv, null, (ContainerData)new SimpleContainerData(2));
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    private void addPlayerInventory(Inventory playerInv) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18 + 26, 84 + row * 18 + 36));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInv) {
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18 + 26, 178));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public int getCostForTier(String rarityKey, int tier) {
        if (tier < 0 || tier >= 10) {
            return 0;
        }
        int nextTier = tier + 1;
        int rarityIndex = WeaponRarityUtil.getRarityIndex(rarityKey);
        int baseLow = 1 + rarityIndex;
        int baseHigh = 2 + rarityIndex;
        if (nextTier <= 5) {
            return baseLow;
        }
        return baseHigh;
    }

    public double getSuccessChanceForTier(int tier) {
        if (tier < 5) {
            return 1.0;
        }
        return switch (tier) {
            case 5 -> 0.8;
            case 6 -> 0.6;
            case 7 -> 0.4;
            case 8 -> 0.3;
            case 9 -> 0.2;
            default -> 0.0;
        };
    }

    private int countCostItem(Player player, Item costItem) {
        int count = 0;
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack s = inv.m_8020_(i);
            if (s.m_41619_() || s.m_41720_() != costItem) continue;
            count += s.m_41613_();
        }
        return count;
    }

    private void consumeCostItem(Player player, Item costItem, int amount) {
        int remaining = amount;
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.m_6643_() && remaining > 0; ++i) {
            ItemStack s = inv.m_8020_(i);
            if (s.m_41619_() || s.m_41720_() != costItem) continue;
            int toRemove = Math.min(remaining, s.m_41613_());
            s.m_41774_(toRemove);
            if (s.m_41619_()) {
                inv.m_6836_(i, ItemStack.f_41583_);
            }
            remaining -= toRemove;
        }
    }

    public boolean m_6366_(Player player, int id) {
        if (id == 0) {
            this.onPowerEnchantServer(player);
            return true;
        }
        return false;
    }

    private void onPowerEnchantServer(Player player) {
        int tier;
        String rarityKeyTag;
        if (this.blockEntity == null || this.blockEntity.m_58904_() == null || this.blockEntity.m_58904_().m_5776_()) {
            return;
        }
        ItemStack stack = this.blockEntity.getItem(0);
        if (stack.m_41619_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        boolean isArmor = stack.m_41720_() instanceof ArmorItem;
        String string = rarityKeyTag = isArmor ? "ArmorRarity" : "WeaponRarity";
        if (!tag.m_128441_(rarityKeyTag)) {
            return;
        }
        String rarityKey = tag.m_128461_(rarityKeyTag);
        if (rarityKey == null || rarityKey.isEmpty()) {
            return;
        }
        int n = tier = tag.m_128441_("RarityTier") ? tag.m_128451_("RarityTier") : 0;
        if (tier >= 10) {
            return;
        }
        int cost = this.getCostForTier(rarityKey, tier);
        Item costItem = (Item)ModItems.FUSION_FRAGMENT.get();
        int have = this.countCostItem(player, costItem);
        if (have < cost) {
            return;
        }
        double successChance = this.getSuccessChanceForTier(tier);
        boolean success = true;
        if (successChance < 1.0) {
            double roll = this.blockEntity.m_58904_().m_213780_().m_188500_();
            success = roll < successChance;
        }
        this.consumeCostItem(player, costItem, cost);
        if (!success) {
            Level level = this.blockEntity.m_58904_();
            if (level instanceof ServerLevel) {
                ServerLevel s = (ServerLevel)level;
                s.m_5594_(null, this.blockEntity.m_58899_(), SoundEvents.f_11668_, SoundSource.BLOCKS, 0.8f, 0.8f);
            }
            return;
        }
        tier = Math.min(10, tier + 1);
        tag.m_128405_("RarityTier", tier);
        if (!isArmor) {
            double baseDamage = tag.m_128459_("WeaponBaseDmg");
            if (baseDamage <= 0.0) {
                baseDamage = WeaponRestrictionHandler.getWeaponBaseDamage(stack);
                tag.m_128347_("WeaponBaseDmg", baseDamage);
            }
            double tierBonusPct = WeaponRarityUtil.getTierBonusPct(rarityKey, tier);
            tag.m_128347_("WeaponBonusPct", tierBonusPct);
            double bonus = baseDamage * tierBonusPct;
            tag.m_128347_("WeaponBonusDmg", bonus);
            tag.m_128347_("WeaponTotalDmg", baseDamage + bonus);
            double pierce = WeaponRarityUtil.getTierPierce(rarityKey, tier);
            tag.m_128347_("WeaponPierce", pierce);
        } else {
            double baseArmorScore;
            tag.m_128405_("ArmorRarityTier", tier);
            double d = baseArmorScore = tag.m_128441_("ArmorBaseScore") ? tag.m_128459_("ArmorBaseScore") : 0.0;
            if (!tag.m_128441_("ArmorBaseScore")) {
                tag.m_128347_("ArmorBaseScore", baseArmorScore);
            }
            double armorScoreFromRarity = ArmorRarityUtil.getTierArmorScore(rarityKey, tier);
            double finalScore = baseArmorScore + armorScoreFromRarity;
            tag.m_128347_("ArmorBonusPct", 0.0);
            tag.m_128347_("ArmorScore", finalScore);
        }
        stack.m_41751_(tag);
        this.blockEntity.setItem(0, stack);
        this.blockEntity.m_6596_();
        Level level = this.blockEntity.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_5594_(null, this.blockEntity.m_58899_(), SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean hasItem() {
        ItemStack stack = this.container.m_8020_(0);
        return !stack.m_41619_();
    }

    public boolean isArmorItem() {
        ItemStack stack = this.container.m_8020_(0);
        return !stack.m_41619_() && stack.m_41720_() instanceof ArmorItem;
    }

    public ItemStack getInputStack() {
        return this.container.m_8020_(0);
    }

    public void setPreviewStack(ItemStack preview) {
    }

    public int getCurrentTier() {
        ItemStack stack = this.container.m_8020_(0);
        if (stack.m_41619_() || !stack.m_41782_()) {
            return 0;
        }
        return stack.m_41783_().m_128451_("RarityTier");
    }

    public double getCurrentBonusPct() {
        ItemStack stack = this.container.m_8020_(0);
        if (stack.m_41619_() || !stack.m_41782_()) {
            return 0.0;
        }
        boolean isArmor = stack.m_41720_() instanceof ArmorItem;
        String rarityKeyTag = isArmor ? "ArmorRarity" : "WeaponRarity";
        String rarityKey = stack.m_41783_().m_128461_(rarityKeyTag);
        if (rarityKey == null || rarityKey.isEmpty()) {
            return 0.0;
        }
        int tier = stack.m_41783_().m_128451_("RarityTier");
        if (isArmor) {
            return 0.0;
        }
        return WeaponRarityUtil.getTierBonusPct(rarityKey, tier);
    }

    public double getNextBonusPct() {
        ItemStack stack = this.container.m_8020_(0);
        if (stack.m_41619_() || !stack.m_41782_()) {
            return 0.0;
        }
        boolean isArmor = stack.m_41720_() instanceof ArmorItem;
        String rarityKeyTag = isArmor ? "ArmorRarity" : "WeaponRarity";
        String rarityKey = stack.m_41783_().m_128461_(rarityKeyTag);
        if (rarityKey == null || rarityKey.isEmpty()) {
            return 0.0;
        }
        int tier = stack.m_41783_().m_128451_("RarityTier");
        if (tier >= 10) {
            return this.getCurrentBonusPct();
        }
        if (isArmor) {
            return 0.0;
        }
        return WeaponRarityUtil.getTierBonusPct(rarityKey, tier + 1);
    }

    public int getCostForCurrent() {
        ItemStack stack = this.container.m_8020_(0);
        if (stack.m_41619_() || !stack.m_41782_()) {
            return 0;
        }
        boolean isArmor = stack.m_41720_() instanceof ArmorItem;
        String rarityKeyTag = isArmor ? "ArmorRarity" : "WeaponRarity";
        String rarityKey = stack.m_41783_().m_128461_(rarityKeyTag);
        if (rarityKey == null || rarityKey.isEmpty()) {
            return 0;
        }
        int tier = stack.m_41783_().m_128451_("RarityTier");
        if (tier >= 10) {
            return 0;
        }
        return this.getCostForTier(rarityKey, tier);
    }

    public double getSuccessChanceForCurrent() {
        ItemStack stack = this.container.m_8020_(0);
        if (stack.m_41619_() || !stack.m_41782_()) {
            return 0.0;
        }
        int tier = stack.m_41783_().m_128451_("RarityTier");
        if (tier >= 10) {
            return 0.0;
        }
        return this.getSuccessChanceForTier(tier);
    }

    public int getPlayerCostHave(Player player) {
        return this.countCostItem(player, (Item)ModItems.FUSION_FRAGMENT.get());
    }

    public Component getRarityInfoLine() {
        ItemStack stack = this.container.m_8020_(0);
        if (stack.m_41619_() || !stack.m_41782_()) {
            return null;
        }
        boolean isArmor = stack.m_41720_() instanceof ArmorItem;
        String rarityKeyTag = isArmor ? "ArmorRarity" : "WeaponRarity";
        String rarityKey = stack.m_41783_().m_128461_(rarityKeyTag);
        if (rarityKey == null || rarityKey.isEmpty()) {
            return null;
        }
        int tier = stack.m_41783_().m_128451_("RarityTier");
        if (tier < 0) {
            tier = 0;
        }
        if (isArmor) {
            int currentScore = ArmorRarityUtil.getArmorScoreFor(rarityKey, tier);
            if (tier >= 10) {
                return Component.m_237113_((String)String.format("Rarity Tier %d: %d \u00e2\u2020\u2019 MAX", tier, currentScore));
            }
            int nextScore = ArmorRarityUtil.getArmorScoreFor(rarityKey, tier + 1);
            return Component.m_237113_((String)String.format("Rarity Tier %d: %d \u00e2\u2020\u2019 Tier %d: %d", tier, currentScore, tier + 1, nextScore));
        }
        double currentPct = WeaponRarityUtil.getTierBonusPct(rarityKey, tier) * 100.0;
        if (tier >= 10) {
            return Component.m_237113_((String)String.format("Rarity Tier %d: %.0f%% \u00e2\u2020\u2019 MAX", tier, currentPct));
        }
        int nextTier = tier + 1;
        double nextPct = WeaponRarityUtil.getTierBonusPct(rarityKey, nextTier) * 100.0;
        return Component.m_237113_((String)String.format("Rarity Tier %d: %.0f%% \u00e2\u2020\u2019 Tier %d: %.0f%%", tier, currentPct, nextTier, nextPct));
    }
}

