/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.items.raritytable;

import com.everydayxp.levelingrank.handler.ArmorRestrictionHandler;
import com.everydayxp.levelingrank.handler.WeaponRestrictionHandler;
import com.everydayxp.levelingrank.items.ModItems;
import com.everydayxp.levelingrank.items.raritytable.RarityInfusionBlockEntity;
import com.everydayxp.levelingrank.menu.ModMenus;
import com.everydayxp.levelingrank.util.ArmorRarityUtil;
import com.everydayxp.levelingrank.util.WeaponRarityUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RarityInfusionMenu
extends AbstractContainerMenu {
    private static final int PLAYER_INV_X_OFFSET = 26;
    private static final int PLAYER_INV_Y_OFFSET = 36;
    public static final int COST_AMOUNT = 9;
    public static final Item COST_ITEM = (Item)ModItems.FUSION_FRAGMENT.get();
    private static final Component NO_RARITY_TEXT = Component.m_237113_((String)"???");
    @Nullable
    private final RarityInfusionBlockEntity blockEntity;
    private final Container container;
    private int ritualState = 0;
    private Component currentRarityName = NO_RARITY_TEXT;

    public RarityInfusionMenu(int id, Inventory playerInv, final @Nullable RarityInfusionBlockEntity blockEntity, @Nullable ContainerData data) {
        super((MenuType)ModMenus.RARITY_INFUSION_MENU.get(), id);
        this.blockEntity = blockEntity;
        this.container = new SimpleContainer(1){

            public ItemStack m_8020_(int slot) {
                return blockEntity != null ? blockEntity.getItem(slot) : super.m_8020_(slot);
            }

            public void m_6836_(int slot, ItemStack stack) {
                if (blockEntity != null) {
                    blockEntity.setItem(slot, stack);
                } else {
                    super.m_6836_(slot, stack);
                }
            }

            public ItemStack m_7407_(int slot, int amount) {
                if (blockEntity != null) {
                    ItemStack stack = blockEntity.getItem(slot);
                    if (stack.m_41619_()) {
                        return ItemStack.f_41583_;
                    }
                    ItemStack result = stack.m_41620_(amount);
                    blockEntity.setItem(slot, stack);
                    return result;
                }
                return super.m_7407_(slot, amount);
            }

            public ItemStack m_8016_(int slot) {
                if (blockEntity != null) {
                    ItemStack stack = blockEntity.getItem(slot);
                    blockEntity.setItem(slot, ItemStack.f_41583_);
                    return stack;
                }
                return super.m_8016_(slot);
            }
        };
        ContainerData usedData = data != null ? data : new SimpleContainerData(1);
        this.m_38897_(new Slot(this.container, 0, 135, 32));
        int armorX = 34;
        int baseArmorY = 12;
        this.m_38897_(new Slot((Container)playerInv, 39, armorX, baseArmorY));
        this.m_38897_(new Slot((Container)playerInv, 38, armorX, baseArmorY + 18));
        this.m_38897_(new Slot((Container)playerInv, 37, armorX, baseArmorY + 36));
        this.m_38897_(new Slot((Container)playerInv, 36, armorX, baseArmorY + 54));
        this.m_38897_(new Slot((Container)playerInv, 40, armorX, baseArmorY + 72));
        this.addPlayerInventory(playerInv);
        this.addPlayerHotbar(playerInv);
        this.m_38884_(usedData);
    }

    public RarityInfusionMenu(int id, Inventory playerInv) {
        this(id, playerInv, null, (ContainerData)new SimpleContainerData(1));
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    private void addPlayerInventory(Inventory playerInv) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18 + 26, 84 + row * 18 + 36));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInv) {
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18 + 26, 178));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6366_(Player player, int id) {
        if (id == 0) {
            this.onRitualServer(player);
            return true;
        }
        return false;
    }

    private int countCostItem(Player player) {
        int count = 0;
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack s = inv.m_8020_(i);
            if (s.m_41619_() || s.m_41720_() != COST_ITEM) continue;
            count += s.m_41613_();
        }
        return count;
    }

    private void consumeCostItem(Player player, int amount) {
        int remaining = amount;
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.m_6643_() && remaining > 0; ++i) {
            ItemStack s = inv.m_8020_(i);
            if (s.m_41619_() || s.m_41720_() != COST_ITEM) continue;
            int toRemove = Math.min(remaining, s.m_41613_());
            s.m_41774_(toRemove);
            if (s.m_41619_()) {
                inv.m_6836_(i, ItemStack.f_41583_);
            }
            remaining -= toRemove;
        }
    }

    private void onRitualServer(Player player) {
        if (this.blockEntity == null || this.blockEntity.m_58904_() == null || this.blockEntity.m_58904_().m_5776_()) {
            return;
        }
        ItemStack center = this.blockEntity.getItem(0);
        this.ritualState = 0;
        boolean isArmor = center.m_41720_() instanceof ArmorItem;
        boolean isWeapon = WeaponRestrictionHandler.isWeapon(center);
        if (center.m_41619_() || !isWeapon && !isArmor) {
            this.ritualState = 2;
            return;
        }
        int available = this.countCostItem(player);
        if (available < 9) {
            this.ritualState = 2;
            return;
        }
        int playerLevel = WeaponRestrictionHandler.getPlayerLevel(player);
        if (isWeapon) {
            int highIndex;
            int midIndex;
            int lowIndex;
            List<WeaponRarityUtil.RarityData> availableRarities = WeaponRarityUtil.getAvailableRarities(playerLevel);
            if (availableRarities.isEmpty()) {
                this.ritualState = 2;
                return;
            }
            if (playerLevel < 25) {
                lowIndex = 0;
                midIndex = 1;
                highIndex = 2;
            } else if (playerLevel < 60) {
                lowIndex = 1;
                midIndex = 2;
                highIndex = 3;
            } else if (playerLevel < 95) {
                lowIndex = 2;
                midIndex = 3;
                highIndex = 4;
            } else if (playerLevel < 130) {
                lowIndex = 3;
                midIndex = 4;
                highIndex = 5;
            } else if (playerLevel < 165) {
                lowIndex = 4;
                midIndex = 5;
                highIndex = 6;
            } else if (playerLevel < 185) {
                lowIndex = 5;
                midIndex = 6;
                highIndex = 7;
            } else if (playerLevel < 200) {
                lowIndex = 6;
                midIndex = 7;
                highIndex = 8;
            } else {
                lowIndex = 7;
                midIndex = 8;
                highIndex = 9;
            }
            WeaponRarityUtil.RarityData lowRarity = availableRarities.get(lowIndex);
            WeaponRarityUtil.RarityData midRarity = availableRarities.get(midIndex);
            WeaponRarityUtil.RarityData highRarity = availableRarities.get(highIndex);
            double[] chances = WeaponRarityUtil.getRarityChances(playerLevel);
            double roll = this.blockEntity.m_58904_().m_213780_().m_188500_();
            WeaponRarityUtil.RarityData chosen = roll < chances[0] ? lowRarity : (roll < chances[0] + chances[1] ? midRarity : highRarity);
            String rarityKey = chosen.rarityKey;
            CompoundTag tag = center.m_41784_();
            tag.m_128359_("WeaponRarity", rarityKey);
            int rarityTier = 0;
            tag.m_128405_("RarityTier", rarityTier);
            double baseDamage = WeaponRestrictionHandler.getWeaponBaseDamage(center);
            tag.m_128347_("WeaponBaseDmg", baseDamage);
            tag.m_128347_("WeaponBonusPct", 0.0);
            tag.m_128347_("WeaponBonusDmg", 0.0);
            tag.m_128347_("WeaponTotalDmg", baseDamage);
            double pierce = WeaponRarityUtil.getTierPierce(rarityKey, rarityTier);
            tag.m_128347_("WeaponPierce", pierce);
            center.m_41751_(tag);
            this.blockEntity.setItem(0, center);
            this.consumeCostItem(player, 9);
            this.blockEntity.m_6596_();
            Level level = this.blockEntity.m_58904_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_5594_(null, this.blockEntity.m_58899_(), SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.ritualState = 1;
            int color = WeaponRarityUtil.getRarityColor(rarityKey);
            this.currentRarityName = Component.m_237115_((String)rarityKey).m_130938_(style -> style.m_178520_(color));
        } else {
            int highIndex;
            int midIndex;
            int lowIndex;
            List<ArmorRarityUtil.RarityData> availableRarities = ArmorRarityUtil.getAvailableRarities(playerLevel);
            if (availableRarities.isEmpty()) {
                this.ritualState = 2;
                return;
            }
            if (playerLevel < 25) {
                lowIndex = 0;
                midIndex = 1;
                highIndex = 2;
            } else if (playerLevel < 60) {
                lowIndex = 1;
                midIndex = 2;
                highIndex = 3;
            } else if (playerLevel < 95) {
                lowIndex = 2;
                midIndex = 3;
                highIndex = 4;
            } else if (playerLevel < 130) {
                lowIndex = 3;
                midIndex = 4;
                highIndex = 5;
            } else if (playerLevel < 165) {
                lowIndex = 4;
                midIndex = 5;
                highIndex = 6;
            } else if (playerLevel < 185) {
                lowIndex = 5;
                midIndex = 6;
                highIndex = 7;
            } else if (playerLevel < 200) {
                lowIndex = 6;
                midIndex = 7;
                highIndex = 8;
            } else {
                lowIndex = 7;
                midIndex = 8;
                highIndex = 9;
            }
            ArmorRarityUtil.RarityData lowRarity = availableRarities.get(lowIndex);
            ArmorRarityUtil.RarityData midRarity = availableRarities.get(midIndex);
            ArmorRarityUtil.RarityData highRarity = availableRarities.get(highIndex);
            double[] chances = ArmorRarityUtil.getRarityChances(playerLevel);
            double roll = this.blockEntity.m_58904_().m_213780_().m_188500_();
            ArmorRarityUtil.RarityData chosen = roll < chances[0] ? lowRarity : (roll < chances[0] + chances[1] ? midRarity : highRarity);
            String rarityKey = chosen.rarityKey;
            ArmorRestrictionHandler.ensureArmorNBT(center);
            CompoundTag tag = center.m_41784_();
            tag.m_128359_("ArmorRarity", rarityKey);
            tag.m_128405_("RarityTier", 0);
            tag.m_128405_("ArmorBaseScore", 0);
            tag.m_128405_("ArmorScore", 0);
            tag.m_128347_("ArmorBonusPct", 0.0);
            center.m_41751_(tag);
            this.blockEntity.setItem(0, center);
            this.consumeCostItem(player, 9);
            this.blockEntity.m_6596_();
            Level level = this.blockEntity.m_58904_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_5594_(null, this.blockEntity.m_58899_(), SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.ritualState = 1;
            int color = ArmorRarityUtil.getRarityColor(rarityKey);
            this.currentRarityName = Component.m_237115_((String)rarityKey).m_130938_(style -> style.m_178520_(color));
        }
    }

    public Component getCurrentRarityNameOrDefault() {
        CompoundTag tag;
        ItemStack center = this.container.m_8020_(0);
        if (!center.m_41619_() && center.m_41782_() && (tag = center.m_41783_()) != null) {
            String key = "";
            if (tag.m_128441_("WeaponRarity")) {
                key = tag.m_128461_("WeaponRarity");
            } else if (tag.m_128441_("ArmorRarity")) {
                key = tag.m_128461_("ArmorRarity");
            }
            if (!key.isEmpty()) {
                boolean isArmor = center.m_41720_() instanceof ArmorItem;
                int color = isArmor ? ArmorRarityUtil.getRarityColor(key) : WeaponRarityUtil.getRarityColor(key);
                return Component.m_237115_((String)key).m_130938_(style -> style.m_178520_(color));
            }
        }
        return NO_RARITY_TEXT;
    }

    public int getCostHave(Player player) {
        return this.countCostItem(player);
    }

    public int getCostNeed() {
        return 9;
    }

    public ItemStack getCenterItem() {
        return this.container.m_8020_(0);
    }

    public Component getRitualStatusLine() {
        if (this.ritualState == 1) {
            return Component.m_237115_((String)"message.levelingrank.ritual_success");
        }
        if (this.ritualState == 2) {
            return Component.m_237115_((String)"message.levelingrank.ritual_fail");
        }
        return null;
    }
}

