/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.network;

import com.everydayxp.levelingrank.config.LevelingRankConfig;
import com.everydayxp.levelingrank.handler.ArmorRestrictionHandler;
import com.everydayxp.levelingrank.handler.GuiRestrictionHandler;
import com.everydayxp.levelingrank.handler.LevelRewardHandler;
import com.everydayxp.levelingrank.handler.MineableRestrictionHandler;
import com.everydayxp.levelingrank.util.JsonQuestUtil;
import com.everydayxp.levelingrank.util.JsonRestrictionUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SyncAllJsonConfigsS2CPacket {
    private static final Gson GSON = new Gson();
    private static final Type TYPE = new TypeToken<Map<String, Map<String, Object>>>(){}.getType();
    private final Map<String, Map<String, Object>> configs;

    public SyncAllJsonConfigsS2CPacket(Map<String, Map<String, Object>> configs) {
        this.configs = configs;
    }

    public Map<String, Map<String, Object>> getConfigs() {
        return this.configs;
    }

    public static void encode(SyncAllJsonConfigsS2CPacket msg, FriendlyByteBuf buf) {
        String json = GSON.toJson(msg.configs, TYPE);
        byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
        buf.m_130130_(bytes.length);
        buf.writeBytes(bytes);
    }

    public static SyncAllJsonConfigsS2CPacket decode(FriendlyByteBuf buf) {
        int len = buf.m_130242_();
        byte[] bytes = new byte[len];
        buf.readBytes(bytes);
        String json = new String(bytes, StandardCharsets.UTF_8);
        HashMap<String, Map<String, Object>> map = (HashMap<String, Map<String, Object>>)GSON.fromJson(json, TYPE);
        if (map == null) {
            map = new HashMap<String, Map<String, Object>>();
        }
        return new SyncAllJsonConfigsS2CPacket(map);
    }

    public static void handle(SyncAllJsonConfigsS2CPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            JsonRestrictionUtil.updateFromServer(msg.getConfigs());
            GuiRestrictionHandler.reloadRestrictions();
            LevelRewardHandler.reload();
            MineableRestrictionHandler.reloadRestrictions();
            ArmorRestrictionHandler.reloadRestrictions();
            JsonQuestUtil.reloadQuests();
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                System.out.println("[LevelingRank] JSONs sincronizados y handlers (incluyendo quests) recargados en cliente.");
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

