/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.network;

import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.client.hud.ClientXPHud;
import com.everydayxp.levelingrank.client.hud.LevelingRankHudOverlay;
import com.everydayxp.levelingrank.config.LevelingRankConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkEvent;

public class SyncLevelDataS2CPacket {
    private final int level;
    private final int xp;
    private final String customTitle;
    private final boolean customTitleEnabled;
    private final List<Integer> claimedRewards;

    public SyncLevelDataS2CPacket(int level, int xp, String customTitle, boolean customTitleEnabled, List<Integer> claimedRewards) {
        this.level = level;
        this.xp = xp;
        this.customTitle = customTitle;
        this.customTitleEnabled = customTitleEnabled;
        this.claimedRewards = claimedRewards;
    }

    public static void encode(SyncLevelDataS2CPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.level);
        buf.m_130130_(msg.xp);
        buf.m_130072_(msg.customTitle, 64);
        buf.writeBoolean(msg.customTitleEnabled);
        buf.m_130130_(msg.claimedRewards.size());
        for (int lv : msg.claimedRewards) {
            buf.m_130130_(lv);
        }
    }

    public static SyncLevelDataS2CPacket decode(FriendlyByteBuf buf) {
        int level = buf.m_130242_();
        int xp = buf.m_130242_();
        String title = buf.m_130136_(64);
        boolean enabled = buf.readBoolean();
        int size = buf.m_130242_();
        ArrayList<Integer> claimed = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            claimed.add(buf.m_130242_());
        }
        return new SyncLevelDataS2CPacket(level, xp, title, enabled, claimed);
    }

    public static void handle(SyncLevelDataS2CPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                mc.f_91074_.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> {
                    int oldXP = data.getXP();
                    int oldLevel = data.getLevel();
                    data.setLevel(msg.level);
                    data.setXP(msg.xp);
                    data.setCustomTitle(msg.customTitle);
                    data.setCustomTitleEnabled(msg.customTitleEnabled);
                    data.clearClaimedRewardLevels();
                    for (int lv : msg.claimedRewards) {
                        data.addClaimedRewardLevel(lv);
                    }
                    ClientXPHud.onXPUpdated(msg.xp, oldXP);
                    LevelingRankHudOverlay.markSynced();
                    if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                        System.out.println("[LevelingRank] [DEBUG] SyncLevelDataS2CPacket - Cliente actualizado -> Level: " + msg.level + " | XP: " + msg.xp + " | Title: \"" + msg.customTitle + "\" enabled=" + msg.customTitleEnabled + " (oldLevel=" + oldLevel + ", oldXP=" + oldXP + ")");
                    }
                });
                mc.execute(() -> {
                    if (mc.f_91080_ == null) {
                        mc.f_91065_.m_93063_((Component)Component.m_237119_(), false);
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

