/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.network;

import com.everydayxp.levelingrank.capability.LevelDataProvider;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class SyncMobLevelS2CPacket {
    private final int entityId;
    private final int level;

    public SyncMobLevelS2CPacket(int entityId, int level) {
        this.entityId = entityId;
        this.level = level;
    }

    public static void encode(SyncMobLevelS2CPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.entityId);
        buf.m_130130_(msg.level);
    }

    public static SyncMobLevelS2CPacket decode(FriendlyByteBuf buf) {
        int id = buf.m_130242_();
        int lvl = buf.m_130242_();
        return new SyncMobLevelS2CPacket(id, lvl);
    }

    public static void handle(SyncMobLevelS2CPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                return;
            }
            Entity e = mc.f_91073_.m_6815_(msg.entityId);
            if (!(e instanceof LivingEntity)) {
                return;
            }
            LivingEntity mob = (LivingEntity)e;
            mob.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(cap -> cap.setLevel(msg.level));
        });
        ctx.get().setPacketHandled(true);
    }
}

