/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.network;

import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.config.LevelingRankConfig;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SyncOtherPlayerLevelPacket {
    private final UUID playerId;
    private final int level;

    public SyncOtherPlayerLevelPacket(UUID playerId, int level) {
        this.playerId = playerId;
        this.level = level;
    }

    public static void encode(SyncOtherPlayerLevelPacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.playerId);
        buf.writeInt(msg.level);
    }

    public static SyncOtherPlayerLevelPacket decode(FriendlyByteBuf buf) {
        return new SyncOtherPlayerLevelPacket(buf.m_130259_(), buf.readInt());
    }

    public static void handle(SyncOtherPlayerLevelPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player target;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && (target = mc.f_91073_.m_46003_(msg.playerId)) != null) {
                target.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(cap -> {
                    cap.setLevel(msg.level);
                    if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                        System.out.println("[LevelingRank] Cliente actualiz\u00c3\u00b3 nivel/rango remoto: " + target.m_7755_().getString() + " -> " + msg.level);
                    }
                });
                target.refreshDisplayName();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

