/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.util;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;

public class ArmorRarityUtil {
    public static final int MAX_TIER = 10;
    public static final List<RarityData> RARITIES = List.of(new RarityData("rarity.levelingrank.common", 1.0, 0xB0B0B0), new RarityData("rarity.levelingrank.uncommon", 1.5, 0x4EFF4E), new RarityData("rarity.levelingrank.rare", 2.0, 3963903), new RarityData("rarity.levelingrank.epic", 2.5, 13782783), new RarityData("rarity.levelingrank.legendary", 3.0, 16766720), new RarityData("rarity.levelingrank.mythic", 3.5, 0xFF5A5A), new RarityData("rarity.levelingrank.divine", 4.0, 5316223), new RarityData("rarity.levelingrank.exotic", 4.5, 1998622), new RarityData("rarity.levelingrank.celestial", 5.0, 6610175), new RarityData("rarity.levelingrank.infernal", 5.5, 9180180));

    public static int getRarityIndex(String rarityKey) {
        for (int i = 0; i < RARITIES.size(); ++i) {
            if (!ArmorRarityUtil.RARITIES.get((int)i).rarityKey.equals(rarityKey)) continue;
            return i;
        }
        return 0;
    }

    @Nullable
    public static RarityData getRarityData(String rarityKey) {
        for (RarityData d : RARITIES) {
            if (!d.rarityKey.equals(rarityKey)) continue;
            return d;
        }
        return null;
    }

    public static int getRarityColor(String rarityKey) {
        RarityData d = ArmorRarityUtil.getRarityData(rarityKey);
        return d != null ? d.colorHex : 0xAAAAAA;
    }

    public static List<RarityData> getAvailableRarities(int seedLevel) {
        if (seedLevel < 25) {
            return RARITIES.subList(0, 3);
        }
        if (seedLevel < 60) {
            return RARITIES.subList(0, 4);
        }
        if (seedLevel < 95) {
            return RARITIES.subList(0, 5);
        }
        if (seedLevel < 130) {
            return RARITIES.subList(0, 6);
        }
        if (seedLevel < 165) {
            return RARITIES.subList(0, 7);
        }
        if (seedLevel < 185) {
            return RARITIES.subList(0, 8);
        }
        if (seedLevel < 200) {
            return RARITIES.subList(0, 9);
        }
        return RARITIES;
    }

    public static double[] getRarityChances(int playerLevel) {
        if (playerLevel < 25) {
            return new double[]{0.7, 0.25, 0.05};
        }
        return new double[]{0.5, 0.45, 0.05};
    }

    public static RarityData generateRarity(int playerLevel) {
        int highIndex;
        int midIndex;
        int lowIndex;
        List<RarityData> available = ArmorRarityUtil.getAvailableRarities(playerLevel);
        double[] chances = ArmorRarityUtil.getRarityChances(playerLevel);
        if (playerLevel < 25) {
            lowIndex = 0;
            midIndex = 1;
            highIndex = 2;
        } else if (playerLevel < 60) {
            lowIndex = 1;
            midIndex = 2;
            highIndex = 3;
        } else if (playerLevel < 95) {
            lowIndex = 2;
            midIndex = 3;
            highIndex = 4;
        } else if (playerLevel < 130) {
            lowIndex = 3;
            midIndex = 4;
            highIndex = 5;
        } else if (playerLevel < 165) {
            lowIndex = 4;
            midIndex = 5;
            highIndex = 6;
        } else if (playerLevel < 185) {
            lowIndex = 5;
            midIndex = 6;
            highIndex = 7;
        } else if (playerLevel < 200) {
            lowIndex = 6;
            midIndex = 7;
            highIndex = 8;
        } else {
            lowIndex = 7;
            midIndex = 8;
            highIndex = 9;
        }
        RarityData low = available.get(lowIndex);
        RarityData mid = available.get(midIndex);
        RarityData high = available.get(highIndex);
        double roll = ThreadLocalRandom.current().nextDouble();
        if (roll < chances[0]) {
            return low;
        }
        if (roll < chances[0] + chances[1]) {
            return mid;
        }
        return high;
    }

    public static double getPlayerArmorAtLevel(int level) {
        return 37.0 * (double)level;
    }

    public static int getUnlockLevelForRarity(String rarityKey) {
        switch (rarityKey) {
            case "rarity.levelingrank.common": {
                return 1;
            }
            case "rarity.levelingrank.uncommon": {
                return 1;
            }
            case "rarity.levelingrank.rare": {
                return 1;
            }
            case "rarity.levelingrank.epic": {
                return 30;
            }
            case "rarity.levelingrank.legendary": {
                return 50;
            }
            case "rarity.levelingrank.mythic": {
                return 75;
            }
            case "rarity.levelingrank.divine": {
                return 100;
            }
            case "rarity.levelingrank.exotic": {
                return 130;
            }
            case "rarity.levelingrank.celestial": {
                return 165;
            }
            case "rarity.levelingrank.infernal": {
                return 200;
            }
        }
        return 1;
    }

    public static int getArmorReferenceLevel(String rarityKey) {
        switch (rarityKey) {
            case "rarity.levelingrank.common": {
                return 1;
            }
            case "rarity.levelingrank.uncommon": {
                return 10;
            }
            case "rarity.levelingrank.rare": {
                return 20;
            }
        }
        return ArmorRarityUtil.getUnlockLevelForRarity(rarityKey);
    }

    public static double getMaxArmorScoreForRarity(String rarityKey) {
        int refLevel = ArmorRarityUtil.getArmorReferenceLevel(rarityKey);
        return ArmorRarityUtil.getPlayerArmorAtLevel(refLevel);
    }

    public static double getTier0ArmorScore(String rarityKey) {
        return 37.0;
    }

    public static double getTierArmorScore(String rarityKey, int tier) {
        if (tier <= 0) {
            return 37.0;
        }
        double maxScore = ArmorRarityUtil.getMaxArmorScoreForRarity(rarityKey);
        int clampedTier = Math.min(10, tier);
        double fraction = 0.5 + 0.5 * (double)clampedTier / 10.0;
        return maxScore * fraction;
    }

    public static int getArmorScoreFor(String rarityKey, int tier) {
        double v = ArmorRarityUtil.getTierArmorScore(rarityKey, tier);
        return (int)Math.round(v);
    }

    public static class RarityData {
        public final String rarityKey;
        public final double armorScale;
        public final int colorHex;

        public RarityData(String rarityKey, double armorScale, int colorHex) {
            this.rarityKey = rarityKey;
            this.armorScale = armorScale;
            this.colorHex = colorHex;
        }
    }
}

