/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.util;

import com.everydayxp.levelingrank.config.LevelingRankConfig;
import com.everydayxp.levelingrank.util.JsonRestrictionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class JsonQuestUtil {
    private static List<KillQuestDefinition> KILL_QUESTS = Collections.emptyList();

    public static List<KillQuestDefinition> getKillQuests() {
        return KILL_QUESTS;
    }

    public static void reloadQuests() {
        JsonRestrictionUtil.RestrictionData raw = JsonRestrictionUtil.forType("quest");
        Map<String, Object> map = raw.items;
        if (map == null || map.isEmpty()) {
            KILL_QUESTS = Collections.emptyList();
            return;
        }
        ArrayList<KillQuestDefinition> list = new ArrayList<KillQuestDefinition>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Map questMap;
            String type;
            String questId = entry.getKey();
            Object val = entry.getValue();
            if (!(val instanceof Map) || !"kill_mobs".equals(type = String.valueOf((questMap = (Map)val).getOrDefault("type", "kill_mobs")))) continue;
            int minLevel = JsonQuestUtil.parseIntOrDefault(questMap.get("min_player_level"), 1);
            int maxLevel = JsonQuestUtil.parseIntOrDefault(questMap.get("max_player_level"), 200);
            Object poolObj = questMap.get("entity_pool");
            ArrayList<KillQuestEntityEntry> entityPool = new ArrayList<KillQuestEntityEntry>();
            if (poolObj instanceof List) {
                List poolList = (List)poolObj;
                for (Object el : poolList) {
                    Map eMap;
                    String eid;
                    if (!(el instanceof Map) || (eid = String.valueOf((eMap = (Map)el).getOrDefault("id", ""))).isEmpty()) continue;
                    int min = JsonQuestUtil.parseIntOrDefault(eMap.get("min"), 1);
                    int max = JsonQuestUtil.parseIntOrDefault(eMap.get("max"), min);
                    int eMinLvl = JsonQuestUtil.parseIntOrDefault(eMap.get("min_player_level"), 1);
                    entityPool.add(new KillQuestEntityEntry(eid, min, max, eMinLvl));
                }
            }
            if (entityPool.isEmpty()) continue;
            list.add(new KillQuestDefinition(questId, minLevel, maxLevel, entityPool));
        }
        KILL_QUESTS = Collections.unmodifiableList(list);
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[LevelingRank] JsonQuestUtil recarg\u00c3\u00b3 " + KILL_QUESTS.size() + " kill quests.");
        }
    }

    private static int parseIntOrDefault(Object obj, int def) {
        if (obj instanceof Number) {
            Number n = (Number)obj;
            return n.intValue();
        }
        if (obj != null) {
            try {
                return Integer.parseInt(obj.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public static class KillQuestEntityEntry {
        public final String id;
        public final int min;
        public final int max;
        public final int minPlayerLevel;

        public KillQuestEntityEntry(String id, int min, int max, int minPlayerLevel) {
            this.id = id;
            this.min = min;
            this.max = max;
            this.minPlayerLevel = minPlayerLevel;
        }
    }

    public static class KillQuestDefinition {
        public final String id;
        public final int minPlayerLevel;
        public final int maxPlayerLevel;
        public final List<KillQuestEntityEntry> entityPool;

        public KillQuestDefinition(String id, int minPlayerLevel, int maxPlayerLevel, List<KillQuestEntityEntry> entityPool) {
            this.id = id;
            this.minPlayerLevel = minPlayerLevel;
            this.maxPlayerLevel = maxPlayerLevel;
            this.entityPool = entityPool;
        }
    }
}

