/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.util;

import com.everydayxp.levelingrank.config.LevelingRankConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.loading.FMLPaths;

public class JsonRestrictionUtil {
    private static final String[] TYPES = new String[]{"armor_restrictions.json", "weapon_restrictions.json", "gui_restrictions.json", "mineable_restrictions.json", "entity_levels.json", "level_rewards.json", "quests.json"};
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<String, RestrictionData> CACHE = new ConcurrentHashMap<String, RestrictionData>();
    private static final Map<String, Map<String, Object>> SERVER_CONFIGS = new ConcurrentHashMap<String, Map<String, Object>>();

    private static void copyDefaultConfigIfMissing(String fileName) {
        File configDir = FMLPaths.CONFIGDIR.get().toFile();
        File configFile = new File(configDir, "levelingrank/" + fileName);
        if (!configFile.exists()) {
            configFile.getParentFile().mkdirs();
            String internalPath = "/config/levelingrank/" + fileName;
            try (InputStream in = JsonRestrictionUtil.class.getResourceAsStream(internalPath);
                 FileOutputStream out = new FileOutputStream(configFile);){
                if (in != null) {
                    int len;
                    byte[] buffer = new byte[4096];
                    while ((len = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                        System.out.println("[LevelingRank] Config por defecto copiado desde .jar: " + configFile.getAbsolutePath());
                    }
                }
            }
            catch (Exception e) {
                System.out.println("[LevelingRank] Error copiando config por defecto: " + configFile.getAbsolutePath() + ": " + e.getMessage());
            }
        }
    }

    private static Map<String, Object> mergeMaps(Map<String, Object> base, Map<String, Object> add) {
        if (base == null) {
            return add != null ? new LinkedHashMap<String, Object>(add) : new LinkedHashMap();
        }
        if (add == null) {
            return new LinkedHashMap<String, Object>(base);
        }
        LinkedHashMap<String, Object> merged = new LinkedHashMap<String, Object>(add);
        for (String key : base.keySet()) {
            Object baseVal = base.get(key);
            Object addVal = add.get(key);
            if (baseVal instanceof Map && addVal instanceof Map) {
                merged.put(key, JsonRestrictionUtil.mergeMaps((Map)baseVal, (Map)addVal));
                continue;
            }
            merged.put(key, baseVal);
        }
        return merged;
    }

    private static String compactJsonItems(Map<String, Object> items) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        int count = 0;
        for (Map.Entry<String, Object> entry : items.entrySet()) {
            Object object;
            sb.append("  \"").append(entry.getKey()).append("\": ");
            if ("rewards".equals(entry.getKey()) && (object = entry.getValue()) instanceof List) {
                List list = (List)object;
                sb.append("[\n");
                for (int i = 0; i < list.size(); ++i) {
                    Object r = list.get(i);
                    sb.append("    ").append(GSON.toJson(r));
                    if (i < list.size() - 1) {
                        sb.append(",");
                    }
                    sb.append("\n");
                }
                sb.append("  ]");
            } else {
                sb.append(GSON.toJson(entry.getValue()));
            }
            if (++count < items.size()) {
                sb.append(",");
            }
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private static void writeMergedJsonToFile(File file, Map<String, Object> mergedData) {
        block11: {
            try {
                Map items = mergedData.get("items") instanceof Map ? (Map)mergedData.get("items") : Collections.emptyMap();
                Map tags = mergedData.get("tags") instanceof Map ? (Map)mergedData.get("tags") : Collections.emptyMap();
                String itemsJson = JsonRestrictionUtil.compactJsonItems(items);
                String tagsJson = JsonRestrictionUtil.compactJsonItems(tags);
                StringBuilder finalJson = new StringBuilder();
                finalJson.append("{\n");
                finalJson.append("  \"items\": ").append(itemsJson);
                if (tags != null && !tags.isEmpty()) {
                    finalJson.append(",\n  \"tags\": ").append(tagsJson).append("\n");
                } else {
                    finalJson.append("\n");
                }
                finalJson.append("}");
                String jsonString = finalJson.toString();
                String currentContent = "";
                if (file.exists()) {
                    currentContent = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
                }
                if (jsonString.equals(currentContent)) break block11;
                try (FileOutputStream fos = new FileOutputStream(file, false);){
                    fos.write(jsonString.getBytes(StandardCharsets.UTF_8));
                    if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                        System.out.println("[LevelingRank] Archivo JSON actualizado/guardado: " + file.getAbsolutePath());
                    }
                }
            }
            catch (Exception e) {
                System.out.println("[LevelingRank] Error al guardar JSON en disco: " + e.getMessage());
            }
        }
    }

    private static Map<String, Object> safeMap(Object obj) {
        return obj instanceof Map ? (Map)obj : Collections.emptyMap();
    }

    public static Map<String, Object> loadRawJson(String fileName) {
        File configDir = FMLPaths.CONFIGDIR.get().toFile();
        File file = new File(configDir, "levelingrank/" + fileName);
        Map diskData = Collections.emptyMap();
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                diskData = (Map)GSON.fromJson((Reader)reader, new TypeToken<Map<String, Object>>(){}.getType());
            }
            catch (Exception e) {
                System.out.println("[LevelingRank] Error al leer " + file.getAbsolutePath() + ": " + e.getMessage());
            }
        }
        Map embeddedData = Collections.emptyMap();
        String resourcePath = "/config/levelingrank/" + fileName;
        try (InputStream in = JsonRestrictionUtil.class.getResourceAsStream(resourcePath);){
            if (in != null) {
                embeddedData = (Map)GSON.fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), new TypeToken<Map<String, Object>>(){}.getType());
            }
        }
        catch (Exception e) {
            System.out.println("[LevelingRank] Error al leer recurso embebido: " + resourcePath + ": " + e.getMessage());
        }
        Map<String, Object> mergedData = JsonRestrictionUtil.mergeMaps(diskData, embeddedData);
        if (!"quests.json".equals(fileName)) {
            File jsonFile = new File(configDir, "levelingrank/" + fileName);
            JsonRestrictionUtil.writeMergedJsonToFile(jsonFile, mergedData);
        }
        return mergedData;
    }

    public static void updateFromServer(Map<String, Map<String, Object>> allConfigs) {
        SERVER_CONFIGS.clear();
        if (allConfigs != null) {
            SERVER_CONFIGS.putAll(allConfigs);
        }
        CACHE.clear();
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[LevelingRank] Cache JSON actualizado desde servidor: " + SERVER_CONFIGS.keySet());
        }
    }

    public static RestrictionData forType(String type) {
        Object replaceObj;
        String fileName;
        if (SERVER_CONFIGS.containsKey(type)) {
            Object replaceObj2;
            Map<String, Object> mergedData = SERVER_CONFIGS.get(type);
            boolean replaceGlobal = false;
            if (mergedData != null && !mergedData.isEmpty() && (replaceObj2 = mergedData.get("replace")) instanceof Boolean) {
                Boolean b = (Boolean)replaceObj2;
                replaceGlobal = b;
            }
            Map<String, Object> items = JsonRestrictionUtil.safeMap(mergedData != null ? mergedData.get("items") : null);
            Map<String, Object> tags = JsonRestrictionUtil.safeMap(mergedData != null ? mergedData.get("tags") : null);
            RestrictionData data = new RestrictionData(items, tags, replaceGlobal);
            CACHE.put(type, data);
            return data;
        }
        if (CACHE.containsKey(type)) {
            return CACHE.get(type);
        }
        switch (type) {
            case "armor": {
                String string = "armor_restrictions.json";
                break;
            }
            case "weapon": {
                String string = "weapon_restrictions.json";
                break;
            }
            case "gui": {
                String string = "gui_restrictions.json";
                break;
            }
            case "mineable": {
                String string = "mineable_restrictions.json";
                break;
            }
            case "entity": {
                String string = "entity_levels.json";
                break;
            }
            case "reward": {
                String string = "level_rewards.json";
                break;
            }
            case "quest": {
                String string = "quests.json";
                break;
            }
            default: {
                String string = fileName = null;
            }
        }
        if (fileName == null) {
            return new RestrictionData(Collections.emptyMap(), Collections.emptyMap(), false);
        }
        Map<String, Object> mergedData = JsonRestrictionUtil.loadRawJson(fileName);
        boolean replaceGlobal = false;
        if (!mergedData.isEmpty() && (replaceObj = mergedData.get("replace")) instanceof Boolean) {
            replaceGlobal = (Boolean)replaceObj;
        }
        Map<String, Object> items = JsonRestrictionUtil.safeMap(mergedData.get("items"));
        Map<String, Object> tags = JsonRestrictionUtil.safeMap(mergedData.get("tags"));
        RestrictionData data = new RestrictionData(items, tags, replaceGlobal);
        CACHE.put(type, data);
        return data;
    }

    public static void reloadAll() {
        CACHE.clear();
        for (String fileName : TYPES) {
            JsonRestrictionUtil.copyDefaultConfigIfMissing(fileName);
        }
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[LevelingRank] Config recargada desde disco.");
        }
    }

    public static Boolean extractReplace(Object configObj) {
        Map map;
        Object replaceVal;
        if (configObj instanceof Map && (replaceVal = (map = (Map)configObj).get("replace")) instanceof Boolean) {
            return (Boolean)replaceVal;
        }
        return null;
    }

    public static boolean shouldReplace(ItemStack stack, RestrictionData data) {
        ResourceLocation itemID = stack.m_41720_().m_204114_().m_205785_().m_135782_();
        Object configObj = data.items.get(itemID.toString());
        Boolean replace = JsonRestrictionUtil.extractReplace(configObj);
        if (replace != null) {
            return replace;
        }
        for (String tagName : data.tags.keySet()) {
            TagKey tag;
            ResourceLocation tagLoc = ResourceLocation.m_135820_((String)tagName);
            if (tagLoc == null || !stack.m_204117_(tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagLoc))) continue;
            Object tagConfig = data.tags.get(tagName);
            replace = JsonRestrictionUtil.extractReplace(tagConfig);
            if (replace == null) break;
            return replace;
        }
        return data.replaceGlobal;
    }

    static {
        for (String fileName : TYPES) {
            JsonRestrictionUtil.copyDefaultConfigIfMissing(fileName);
        }
    }

    public static class RestrictionData {
        public final Map<String, Object> items;
        public final Map<String, Object> tags;
        public final boolean replaceGlobal;

        public RestrictionData(Map<String, Object> items, Map<String, Object> tags, boolean replaceGlobal) {
            this.items = items;
            this.tags = tags;
            this.replaceGlobal = replaceGlobal;
        }
    }
}

