/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.util;

import com.everydayxp.levelingrank.items.ModItems;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;

public class WeaponRarityUtil {
    public static final int MAX_TIER = 10;
    public static final List<RarityData> RARITIES = List.of(new RarityData("rarity.levelingrank.common", 0.25, 0xB0B0B0), new RarityData("rarity.levelingrank.uncommon", 0.7, 0x4EFF4E), new RarityData("rarity.levelingrank.rare", 1.3, 3963903), new RarityData("rarity.levelingrank.epic", 2.1, 13782783), new RarityData("rarity.levelingrank.legendary", 3.0, 16766720), new RarityData("rarity.levelingrank.mythic", 4.1, 0xFF5A5A), new RarityData("rarity.levelingrank.divine", 5.3, 5316223), new RarityData("rarity.levelingrank.exotic", 6.6, 1998622), new RarityData("rarity.levelingrank.celestial", 8.0, 6610175), new RarityData("rarity.levelingrank.infernal", 9.0, 9180180));

    public static List<RarityData> getAvailableRarities(int seedLevel) {
        if (seedLevel < 25) {
            return RARITIES.subList(0, 3);
        }
        if (seedLevel < 60) {
            return RARITIES.subList(0, 4);
        }
        if (seedLevel < 95) {
            return RARITIES.subList(0, 5);
        }
        if (seedLevel < 130) {
            return RARITIES.subList(0, 6);
        }
        if (seedLevel < 165) {
            return RARITIES.subList(0, 7);
        }
        if (seedLevel < 185) {
            return RARITIES.subList(0, 8);
        }
        if (seedLevel < 200) {
            return RARITIES.subList(0, 9);
        }
        return RARITIES;
    }

    public static List<RarityData> getAllowedRarities(int playerLevel) {
        if (playerLevel < 25) {
            return RARITIES.subList(0, 3);
        }
        if (playerLevel < 60) {
            return RARITIES.subList(0, 4);
        }
        if (playerLevel < 95) {
            return RARITIES.subList(0, 5);
        }
        if (playerLevel < 130) {
            return RARITIES.subList(0, 6);
        }
        if (playerLevel < 165) {
            return RARITIES.subList(0, 7);
        }
        if (playerLevel < 185) {
            return RARITIES.subList(0, 8);
        }
        if (playerLevel < 200) {
            return RARITIES.subList(0, 9);
        }
        return RARITIES;
    }

    public static double[] getRarityChances(int playerLevel) {
        if (playerLevel < 25) {
            return new double[]{0.7, 0.25, 0.05};
        }
        return new double[]{0.5, 0.45, 0.05};
    }

    public static RarityData generateRarity(int playerLevel) {
        int highIndex;
        int midIndex;
        int lowIndex;
        List<RarityData> available = WeaponRarityUtil.getAvailableRarities(playerLevel);
        double[] chances = WeaponRarityUtil.getRarityChances(playerLevel);
        if (playerLevel < 25) {
            lowIndex = 0;
            midIndex = 1;
            highIndex = 2;
        } else if (playerLevel < 60) {
            lowIndex = 1;
            midIndex = 2;
            highIndex = 3;
        } else if (playerLevel < 95) {
            lowIndex = 2;
            midIndex = 3;
            highIndex = 4;
        } else if (playerLevel < 130) {
            lowIndex = 3;
            midIndex = 4;
            highIndex = 5;
        } else if (playerLevel < 165) {
            lowIndex = 4;
            midIndex = 5;
            highIndex = 6;
        } else if (playerLevel < 185) {
            lowIndex = 5;
            midIndex = 6;
            highIndex = 7;
        } else if (playerLevel < 200) {
            lowIndex = 6;
            midIndex = 7;
            highIndex = 8;
        } else {
            lowIndex = 7;
            midIndex = 8;
            highIndex = 9;
        }
        RarityData low = available.get(lowIndex);
        RarityData mid = available.get(midIndex);
        RarityData high = available.get(highIndex);
        double roll = ThreadLocalRandom.current().nextDouble();
        if (roll < chances[0]) {
            return low;
        }
        if (roll < chances[0] + chances[1]) {
            return mid;
        }
        return high;
    }

    public static int getRarityColor(String rarityKey) {
        for (RarityData d : RARITIES) {
            if (!d.rarityKey.equals(rarityKey)) continue;
            return d.colorHex;
        }
        return 0xAAAAAA;
    }

    @Nullable
    public static RarityData getRarityData(String rarityKey) {
        for (RarityData d : RARITIES) {
            if (!d.rarityKey.equals(rarityKey)) continue;
            return d;
        }
        return null;
    }

    public static int getRarityIndex(String rarityKey) {
        for (int i = 0; i < RARITIES.size(); ++i) {
            if (!WeaponRarityUtil.RARITIES.get((int)i).rarityKey.equals(rarityKey)) continue;
            return i;
        }
        return 0;
    }

    public static double getTierBonusPct(String rarityKey, int tier) {
        RarityData data = WeaponRarityUtil.getRarityData(rarityKey);
        if (data == null) {
            return 0.0;
        }
        int clampedTier = Math.max(1, Math.min(10, tier));
        double fraction = (double)clampedTier / 10.0;
        return data.bonusPct * fraction;
    }

    public static double getMonsterArmorAtLevel(int level) {
        return 4.0 + 41.0 * (double)level;
    }

    public static int getUnlockLevelForRarity(String rarityKey) {
        switch (rarityKey) {
            case "rarity.levelingrank.common": {
                return 1;
            }
            case "rarity.levelingrank.uncommon": {
                return 1;
            }
            case "rarity.levelingrank.rare": {
                return 1;
            }
            case "rarity.levelingrank.epic": {
                return 30;
            }
            case "rarity.levelingrank.legendary": {
                return 50;
            }
            case "rarity.levelingrank.mythic": {
                return 75;
            }
            case "rarity.levelingrank.divine": {
                return 100;
            }
            case "rarity.levelingrank.exotic": {
                return 130;
            }
            case "rarity.levelingrank.celestial": {
                return 165;
            }
            case "rarity.levelingrank.infernal": {
                return 200;
            }
        }
        return 1;
    }

    public static int getPierceReferenceLevel(String rarityKey) {
        switch (rarityKey) {
            case "rarity.levelingrank.common": {
                return 1;
            }
            case "rarity.levelingrank.uncommon": {
                return 10;
            }
            case "rarity.levelingrank.rare": {
                return 20;
            }
        }
        return WeaponRarityUtil.getUnlockLevelForRarity(rarityKey);
    }

    public static double getMaxPierceForRarity(String rarityKey) {
        int refLevel = WeaponRarityUtil.getPierceReferenceLevel(rarityKey);
        return WeaponRarityUtil.getMonsterArmorAtLevel(refLevel);
    }

    public static double getTier0Pierce(String rarityKey) {
        double maxPierce = WeaponRarityUtil.getMaxPierceForRarity(rarityKey);
        return maxPierce * 0.5;
    }

    public static double getTierPierce(String rarityKey, int tier) {
        double maxPierce = WeaponRarityUtil.getMaxPierceForRarity(rarityKey);
        if (tier <= 0) {
            return maxPierce * 0.5;
        }
        int clampedTier = Math.min(10, tier);
        double fraction = 0.5 + 0.5 * (double)clampedTier / 10.0;
        return maxPierce * fraction;
    }

    public static Item getFragmentForRarity(String rarityKey) {
        return (Item)ModItems.FUSION_FRAGMENT.get();
    }

    public static class RarityData {
        public final String rarityKey;
        public final double bonusPct;
        public final int colorHex;

        public RarityData(String rarityKey, double bonusPct, int colorHex) {
            this.rarityKey = rarityKey;
            this.bonusPct = bonusPct;
            this.colorHex = colorHex;
        }
    }
}

