/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.capability;

import com.everydayxp.levelingrank.attribute.ModAttributes;
import com.everydayxp.levelingrank.capability.ILevelData;
import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.config.LevelingRankConfig;
import com.everydayxp.levelingrank.events.DailyXPBonusHandler;
import com.everydayxp.levelingrank.network.ModNetworkHandler;
import com.everydayxp.levelingrank.util.WeaponRarityUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.server.ServerLifecycleHooks;

public class LevelData
implements ILevelData,
INBTSerializable<CompoundTag> {
    private int level = 1;
    private int xp = 0;
    private static final int MAX_LEVEL = (Integer)LevelingRankConfig.MAX_LEVEL.get();
    private UUID ownerUUID;
    private final Set<Integer> claimedRewardLevels = new HashSet<Integer>();
    private String customTitle = "";
    private boolean customTitleEnabled = false;

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getXP() {
        return this.xp;
    }

    public static int getMaxLevel() {
        return (Integer)LevelingRankConfig.MAX_LEVEL.get();
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }

    @Override
    public Set<Integer> getClaimedRewardLevels() {
        return this.claimedRewardLevels;
    }

    @Override
    public void setClaimedRewardLevels(Set<Integer> levels) {
        this.claimedRewardLevels.clear();
        if (levels != null) {
            this.claimedRewardLevels.addAll(levels);
        }
    }

    @Override
    public void addClaimedRewardLevel(int level) {
        this.claimedRewardLevels.add(level);
    }

    @Override
    public boolean hasClaimedRewardLevel(int level) {
        return this.claimedRewardLevels.contains(level);
    }

    @Override
    public void clearClaimedRewardLevels() {
        this.claimedRewardLevels.clear();
    }

    @Override
    public String getCustomTitle() {
        return this.customTitle;
    }

    @Override
    public void setCustomTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.customTitle = title;
    }

    @Override
    public boolean isCustomTitleEnabled() {
        return this.customTitleEnabled;
    }

    @Override
    public void setCustomTitleEnabled(boolean enabled) {
        this.customTitleEnabled = enabled;
    }

    @Override
    public void addXP(int amount) {
        if (this.level >= LevelData.getMaxLevel()) {
            return;
        }
        this.xp += amount;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && this.ownerUUID != null) {
            DailyXPBonusHandler.accumulateXPForPlayer(this.ownerUUID, amount);
        }
        this.tryLevelUp();
    }

    @Override
    public void tryLevelUp() {
        while (this.level < LevelData.getMaxLevel() && this.xp >= this.getXPForNextLevel()) {
            ServerPlayer player;
            this.xp -= this.getXPForNextLevel();
            ++this.level;
            if (ServerLifecycleHooks.getCurrentServer() == null || this.ownerUUID == null || (player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.ownerUUID)) == null) continue;
            this.applyLevelArmorScore(player);
            this.sendLevelUpMilestone(player, this.level);
            player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> ModNetworkHandler.syncLevelData(player, data));
            ModNetworkHandler.syncPlayerLevelToOthers(player, this.level);
            player.refreshTabListName();
            player.f_8924_.m_6846_().m_11268_((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, player));
            LevelDataProvider.syncToClient((Player)player, (ILevelData)player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).orElseThrow(() -> new IllegalStateException("No capability found")));
        }
    }

    private void sendLevelUpMilestone(ServerPlayer player, int level) {
        if (level % 10 != 0) {
            return;
        }
        String displayLevel = level >= LevelData.getMaxLevel() ? "MAX" : String.valueOf(level);
        player.m_213846_((Component)Component.m_237113_((String)("Level reached: " + displayLevel)).m_130940_(ChatFormatting.GOLD));
        List<WeaponRarityUtil.RarityData> rarezas = WeaponRarityUtil.getAvailableRarities(level);
        double[] chances = WeaponRarityUtil.getRarityChances(level);
        player.m_213846_((Component)Component.m_237115_((String)"message.levelingrank.rarity_pool_updated").m_130940_(ChatFormatting.AQUA));
        for (int i = 0; i < rarezas.size(); ++i) {
            WeaponRarityUtil.RarityData data = rarezas.get(i);
            double pct = (double)Math.round(chances[i] * 1000.0) / 10.0;
            MutableComponent rarityText = Component.m_237115_((String)data.rarityKey).m_130938_(style -> style.m_178520_(data.colorHex));
            player.m_213846_((Component)Component.m_237110_((String)"message.levelingrank.rarity_with_chance", (Object[])new Object[]{rarityText, pct}).m_130938_(style -> style.m_178520_(data.colorHex)));
        }
    }

    @Override
    public void setXP(int xp) {
        this.xp = xp;
        this.tryLevelUp();
    }

    @Override
    public void setLevel(int level) {
        this.level = Math.min(level, LevelData.getMaxLevel());
        if (ServerLifecycleHooks.getCurrentServer() != null && this.ownerUUID != null) {
            ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.ownerUUID);
            if (player == null) {
                return;
            }
            this.applyLevelArmorScore(player);
            this.sendLevelUpMilestone(player, level);
            player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> ModNetworkHandler.syncLevelData(player, data));
            ModNetworkHandler.syncPlayerLevelToOthers(player, level);
            player.refreshTabListName();
            player.f_8924_.m_6846_().m_11268_((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, player));
            LevelDataProvider.syncToClient((Player)player, (ILevelData)player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).orElseThrow(() -> new IllegalStateException("No capability found")));
        }
    }

    private void applyLevelArmorScore(ServerPlayer player) {
        AttributeInstance armorAttr = player.m_21051_((Attribute)ModAttributes.ARMOR_SCORE.get());
        if (armorAttr == null) {
            return;
        }
        UUID lvlArmorId = UUID.nameUUIDFromBytes("levelingrank_player_level_armor_score".getBytes());
        AttributeModifier old = armorAttr.m_22111_(lvlArmorId);
        if (old != null) {
            armorAttr.m_22130_(old);
        }
        double levelArmorScore = 40.0 * (double)this.level;
        armorAttr.m_22125_(new AttributeModifier(lvlArmorId, "levelingrank_player_level_armor_score", levelArmorScore, AttributeModifier.Operation.ADDITION));
    }

    @Override
    public int getXPForNextLevel() {
        return 1067 + (this.level - 1) * 448;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Level", this.level);
        tag.m_128405_("XP", this.xp);
        if (this.ownerUUID != null) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
        int[] claimedArray = this.claimedRewardLevels.stream().mapToInt(Integer::intValue).toArray();
        tag.m_128385_("ClaimedRewardLevels", claimedArray);
        tag.m_128359_("CustomTitle", this.customTitle);
        tag.m_128379_("CustomTitleEnabled", this.customTitleEnabled);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.level = 1;
        this.xp = 0;
        this.claimedRewardLevels.clear();
        this.customTitle = "";
        this.customTitleEnabled = false;
        if (tag.m_128441_("Level")) {
            this.level = tag.m_128451_("Level");
        }
        if (tag.m_128441_("XP")) {
            this.xp = tag.m_128451_("XP");
        }
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
        if (tag.m_128441_("ClaimedRewardLevels")) {
            for (int lvl : tag.m_128465_("ClaimedRewardLevels")) {
                this.claimedRewardLevels.add(lvl);
            }
        }
        if (tag.m_128441_("CustomTitle")) {
            this.customTitle = tag.m_128461_("CustomTitle");
        }
        if (tag.m_128441_("CustomTitleEnabled")) {
            this.customTitleEnabled = tag.m_128471_("CustomTitleEnabled");
        }
    }

    @Override
    public void copyFrom(ILevelData source) {
        this.level = source.getLevel();
        this.xp = source.getXP();
        this.claimedRewardLevels.clear();
        this.claimedRewardLevels.addAll(source.getClaimedRewardLevels());
        this.customTitle = source.getCustomTitle();
        this.customTitleEnabled = source.isCustomTitleEnabled();
    }
}

