/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.capability;

import com.everydayxp.levelingrank.capability.ILevelData;
import com.everydayxp.levelingrank.config.LevelingRankConfig;
import java.util.Collections;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;

public class LevelDataMob
implements ILevelData,
INBTSerializable<CompoundTag> {
    private int level = 1;
    private int xp = 0;
    private String customTitle = "";
    private boolean customTitleEnabled = false;

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getXP() {
        return this.xp;
    }

    @Override
    public void addXP(int amount) {
        this.xp += amount;
        this.tryLevelUp();
    }

    @Override
    public void tryLevelUp() {
        while (this.level < LevelingRankConfig.getMaxLevel() && this.xp >= this.getXPForNextLevel()) {
            this.xp -= this.getXPForNextLevel();
            ++this.level;
        }
    }

    @Override
    public void setXP(int xp) {
        this.xp = xp;
        this.tryLevelUp();
    }

    @Override
    public void setLevel(int level) {
        this.level = Math.min(level, LevelingRankConfig.getMaxLevel());
    }

    @Override
    public void copyFrom(ILevelData source) {
        this.level = source.getLevel();
        this.xp = source.getXP();
        this.customTitle = source.getCustomTitle();
        this.customTitleEnabled = source.isCustomTitleEnabled();
        this.setClaimedRewardLevels(source.getClaimedRewardLevels());
    }

    @Override
    public int getXPForNextLevel() {
        return 1067 + (this.level - 1) * 448;
    }

    @Override
    public Set<Integer> getClaimedRewardLevels() {
        return Collections.emptySet();
    }

    @Override
    public void setClaimedRewardLevels(Set<Integer> levels) {
    }

    @Override
    public void addClaimedRewardLevel(int level) {
    }

    @Override
    public boolean hasClaimedRewardLevel(int level) {
        return false;
    }

    @Override
    public void clearClaimedRewardLevels() {
    }

    @Override
    public String getCustomTitle() {
        return this.customTitle;
    }

    @Override
    public void setCustomTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.customTitle = title;
    }

    @Override
    public boolean isCustomTitleEnabled() {
        return this.customTitleEnabled;
    }

    @Override
    public void setCustomTitleEnabled(boolean enabled) {
        this.customTitleEnabled = enabled;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Level", this.level);
        tag.m_128405_("XP", this.xp);
        tag.m_128359_("CustomTitle", this.customTitle);
        tag.m_128379_("CustomTitleEnabled", this.customTitleEnabled);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.level = tag.m_128441_("Level") ? Math.min(tag.m_128451_("Level"), LevelingRankConfig.getMaxLevel()) : 1;
        this.xp = tag.m_128441_("XP") ? tag.m_128451_("XP") : 0;
        this.customTitle = tag.m_128441_("CustomTitle") ? tag.m_128461_("CustomTitle") : "";
        this.customTitleEnabled = tag.m_128441_("CustomTitleEnabled") && tag.m_128471_("CustomTitleEnabled");
    }
}

