/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.capability;

import com.everydayxp.levelingrank.capability.IPlayerQuestData;
import com.everydayxp.levelingrank.capability.PlayerQuestData;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerQuestProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final ResourceLocation ID = new ResourceLocation("levelingrank", "player_quest");
    public static final Capability<IPlayerQuestData> PLAYER_QUEST = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerQuestData>(){});
    private final IPlayerQuestData backend = new PlayerQuestData();
    private final LazyOptional<IPlayerQuestData> optional = LazyOptional.of(() -> this.backend);

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == PLAYER_QUEST ? this.optional.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.backend.saveToNBT(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.backend.loadFromNBT(nbt);
    }

    public static void clone(Player original, Player clone) {
        original.reviveCaps();
        clone.reviveCaps();
        original.getCapability(PLAYER_QUEST).ifPresent(oldData -> clone.getCapability(PLAYER_QUEST).ifPresent(newData -> {
            CompoundTag tag = new CompoundTag();
            oldData.saveToNBT(tag);
            newData.loadFromNBT(tag);
        }));
    }
}

