/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.client.hud;

import com.everydayxp.levelingrank.config.LevelingRankConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class ClientXPHud {
    private static final List<XpEntry> ENTRIES = new ArrayList<XpEntry>();
    private static final long FLOAT_LIFE_MS = 1000L;
    private static final float FLOAT_SPEED_Y = 18.0f;
    private static final int MAX_ENTRIES = 20;
    private static final int LINE_SPACING = 10;
    private static final long ACCUM_WINDOW_MS = 5000L;
    private static int accumulatedXp = 0;
    private static long lastGainTime = 0L;

    public static void onXPUpdated(int newXP, int oldXP) {
        int gained = newXP - oldXP;
        if (gained <= 0) {
            return;
        }
        long now = System.currentTimeMillis();
        accumulatedXp = now - lastGainTime > 5000L ? gained : (accumulatedXp += gained);
        lastGainTime = now;
        if (ENTRIES.size() >= 20) {
            ENTRIES.remove(0);
        }
        ENTRIES.add(new XpEntry(gained, now));
    }

    public static void render(GuiGraphics gfx, int width, int height) {
        if (!((Boolean)LevelingRankConfig.SHOW_XP_FLOATING_HUD.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (accumulatedXp <= 0 || now - lastGainTime > 5000L) {
            accumulatedXp = 0;
        }
        int baseX = width / 2 + 10;
        int baseY = height / 2 - 14;
        int mainColor = 65280;
        if (accumulatedXp > 0) {
            String mainText = "+" + accumulatedXp + " XP";
            float scaleMain = 1.25f;
            PoseStack pose = gfx.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)baseX, (float)baseY, 0.0f);
            pose.m_85841_(scaleMain, scaleMain, 1.0f);
            gfx.m_280056_(mc.f_91062_, mainText, 0, 0, mainColor, false);
            pose.m_85849_();
        }
        if (ENTRIES.isEmpty()) {
            return;
        }
        Iterator<XpEntry> it = ENTRIES.iterator();
        while (it.hasNext()) {
            XpEntry e = it.next();
            long elapsed = now - e.startTime;
            if (elapsed <= 1000L) continue;
            it.remove();
        }
        if (ENTRIES.isEmpty()) {
            return;
        }
        ArrayList<XpEntry> snapshot = new ArrayList<XpEntry>(ENTRIES);
        for (int i = 0; i < snapshot.size(); ++i) {
            XpEntry e = (XpEntry)snapshot.get(i);
            long elapsed = now - e.startTime;
            if (elapsed > 1000L) continue;
            float progress = (float)elapsed / 1000.0f;
            float totalRise = 18.0f;
            e.offsetY = progress * totalRise;
            String text = "+" + e.amount;
            int rawX = baseX + 20;
            int rawY = (int)((float)baseY - e.offsetY - (float)(i * 10));
            int alpha = (int)(255.0f * (1.0f - progress));
            int color = alpha << 24 | 0xFF00;
            float scaleFloat = 0.85f;
            PoseStack pose = gfx.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)rawX, (float)rawY, 0.0f);
            pose.m_85841_(scaleFloat, scaleFloat, 1.0f);
            gfx.m_280056_(mc.f_91062_, text, 0, 0, color, false);
            pose.m_85849_();
        }
    }

    private static class XpEntry {
        final int amount;
        final long startTime;
        float offsetY;

        XpEntry(int amount, long startTime) {
            this.amount = amount;
            this.startTime = startTime;
            this.offsetY = 0.0f;
        }
    }
}

