/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.client.quest;

import com.everydayxp.levelingrank.config.LevelingRankConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class DailyQuestOverlay
implements IGuiOverlay {
    public static boolean HAS_QUEST = false;
    public static boolean QUEST_COMPLETED = false;
    public static String TARGET_NAME = "";
    public static int REQUIRED = 0;
    public static int PROGRESS = 0;
    public static int REWARD_XP = 0;
    public static int REWARD_ITEM_COUNT = 0;
    public static Component REWARD_ITEM_NAME = Component.m_237115_((String)"levelingrank.daily_quest.item_placeholder");
    private static boolean DEBUG_SHOWN = false;

    public static void setQuest(boolean hasQuest, String targetName, int required, int progress, int rewardXp, int rewardItemCount, Component rewardItemName) {
        HAS_QUEST = hasQuest;
        TARGET_NAME = targetName;
        REQUIRED = required;
        PROGRESS = progress;
        REWARD_XP = rewardXp;
        REWARD_ITEM_COUNT = rewardItemCount;
        REWARD_ITEM_NAME = rewardItemName;
        QUEST_COMPLETED = hasQuest && required > 0 && progress >= required;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && ((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            mc.f_91074_.m_213846_((Component)Component.m_237113_((String)("[DQ-DEBUG] HUD setQuest: hasQuest=" + hasQuest + " target=" + targetName + " req=" + required + " prog=" + progress + " completed=" + QUEST_COMPLETED)));
        }
    }

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        if (!HAS_QUEST) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        int boxWidth = 130;
        int boxHeight = 78;
        int x = screenWidth - boxWidth - 6;
        int y = screenHeight / 2 - boxHeight / 2;
        RenderSystem.enableBlend();
        graphics.m_280509_(x, y, x + boxWidth, y + boxHeight, -2013265920);
        int textX = x + 5;
        int lineY = y + 5;
        graphics.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"levelingrank.daily_quest.title"), textX, lineY, 0xFFFFFF, false);
        lineY += 12;
        if (QUEST_COMPLETED) {
            graphics.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"levelingrank.daily_quest.completed"), textX, lineY, 0x55FF55, false);
            lineY += 11;
        } else {
            Object rawName = TARGET_NAME;
            if (((String)rawName).contains(":")) {
                rawName = ((String)rawName).substring(((String)rawName).indexOf(58) + 1);
            }
            if (!((String)(rawName = ((String)rawName).replace('_', ' '))).isEmpty()) {
                rawName = Character.toUpperCase(((String)rawName).charAt(0)) + ((String)rawName).substring(1);
            }
            String base = Component.m_237110_((String)"levelingrank.daily_quest.objective", (Object[])new Object[]{REQUIRED}).getString() + " ";
            graphics.m_280056_(mc.f_91062_, base, textX, lineY, 0xFFDD88, false);
            int baseWidth = mc.f_91062_.m_92895_(base);
            graphics.m_280056_(mc.f_91062_, (String)rawName, textX + baseWidth, lineY, 0xFF5555, false);
            String progressLine = Component.m_237110_((String)"levelingrank.daily_quest.progress", (Object[])new Object[]{PROGRESS, REQUIRED}).getString();
            graphics.m_280056_(mc.f_91062_, progressLine, textX, lineY += 11, 0xAAAAAA, false);
            lineY += 11;
        }
        graphics.m_280614_(mc.f_91062_, (Component)Component.m_237115_((String)"levelingrank.daily_quest.rewards"), textX, lineY += 6, 0xFFFFFF, false);
        String xpLine = Component.m_237110_((String)"levelingrank.daily_quest.xp", (Object[])new Object[]{REWARD_XP}).getString();
        graphics.m_280056_(mc.f_91062_, xpLine, textX, lineY += 12, 0x80FF80, false);
        String itemLine = Component.m_237110_((String)"levelingrank.daily_quest.item", (Object[])new Object[]{REWARD_ITEM_COUNT, REWARD_ITEM_NAME}).getString();
        graphics.m_280056_(mc.f_91062_, itemLine, textX, lineY += 11, 8438015, false);
    }
}

