/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.handler;

import com.everydayxp.levelingrank.capability.ILevelData;
import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.config.ArmorRestrictionMode;
import com.everydayxp.levelingrank.config.LevelingRankConfig;
import com.everydayxp.levelingrank.util.ArmorRarityUtil;
import com.everydayxp.levelingrank.util.JsonRestrictionUtil;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="levelingrank")
public class ArmorRestrictionHandler {
    private static JsonRestrictionUtil.RestrictionData ARMOR_RESTRICTIONS = JsonRestrictionUtil.forType("armor");

    private static JsonRestrictionUtil.RestrictionData getRestrictions() {
        return ARMOR_RESTRICTIONS;
    }

    public static void reloadRestrictions() {
        ARMOR_RESTRICTIONS = JsonRestrictionUtil.forType("armor");
        System.out.println("[LevelingRank] ArmorRestrictionHandler recarg\u00c3\u00b3 restricciones de armadura.");
    }

    public static boolean isArmor(ItemStack stack) {
        return stack.m_41720_() instanceof ArmorItem;
    }

    public static int getArmorRequiredLevel(ItemStack stack) {
        Map map;
        ArmorRestrictionMode mode = (ArmorRestrictionMode)((Object)LevelingRankConfig.ARMOR_RESTRICTION_MODE.get());
        if (mode == ArmorRestrictionMode.NONE) {
            return 1;
        }
        String id = stack.m_41720_().m_204114_().m_205785_().m_135782_().toString();
        Object dataObj = ArmorRestrictionHandler.getRestrictions().items.get(id);
        if (dataObj instanceof Map && (map = (Map)dataObj).containsKey("min_level")) {
            Object rawLvl = map.get("min_level");
            if (rawLvl instanceof Number) {
                return ((Number)rawLvl).intValue();
            }
            try {
                return Integer.parseInt(rawLvl.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (mode == ArmorRestrictionMode.JSON_ONLY) {
            return 1;
        }
        return ArmorRestrictionHandler.getAutomaticArmorLevel(stack);
    }

    public static int getAutomaticArmorLevel(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return 1;
        }
        ArmorItem armorItem = (ArmorItem)item;
        EquipmentSlot slot = armorItem.m_40402_();
        int armor = armorItem.m_40404_();
        float toughness = armorItem.m_40405_();
        if (toughness >= 3.0f) {
            ++armor;
        }
        switch (slot) {
            case HEAD: {
                if (armor >= 6) {
                    return 50;
                }
                if (armor == 5) {
                    return 40;
                }
                if (armor == 4) {
                    return 30;
                }
                if (armor == 3) {
                    return 20;
                }
                if (armor == 2) {
                    return 10;
                }
                return 1;
            }
            case CHEST: {
                if (armor >= 10) {
                    return 50;
                }
                if (armor == 9) {
                    return 40;
                }
                if (armor == 8) {
                    return 30;
                }
                if (armor == 7) {
                    return 20;
                }
                if (armor == 6) {
                    return 10;
                }
                if (armor == 5) {
                    return 5;
                }
                return 1;
            }
            case LEGS: {
                if (armor >= 9) {
                    return 50;
                }
                if (armor == 8) {
                    return 40;
                }
                if (armor == 7) {
                    return 30;
                }
                if (armor == 6) {
                    return 20;
                }
                if (armor == 5) {
                    return 10;
                }
                if (armor == 4) {
                    return 5;
                }
                return 1;
            }
            case FEET: {
                if (armor >= 6) {
                    return 50;
                }
                if (armor == 5) {
                    return 40;
                }
                if (armor == 4) {
                    return 30;
                }
                if (armor == 3) {
                    return 20;
                }
                if (armor == 2) {
                    return 10;
                }
                return 1;
            }
        }
        return 1;
    }

    private static double getBaseCraftedArmorScore(ItemStack stack) {
        return 37.0;
    }

    public static void ensureArmorScore(ItemStack stack) {
        if (!ArmorRestrictionHandler.isArmor(stack) || stack.m_41619_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("ArmorScore")) {
            return;
        }
        if (tag.m_128441_("ArmorRarity") && !tag.m_128461_("ArmorRarity").isEmpty()) {
            String rarityKey = tag.m_128461_("ArmorRarity");
            int tier = tag.m_128441_("ArmorRarityTier") ? tag.m_128451_("ArmorRarityTier") : 0;
            double score = ArmorRarityUtil.getTierArmorScore(rarityKey, tier);
            tag.m_128347_("ArmorBaseScore", score);
            tag.m_128347_("ArmorScore", score);
        } else {
            double base = ArmorRestrictionHandler.getBaseCraftedArmorScore(stack);
            tag.m_128347_("ArmorBaseScore", base);
            tag.m_128347_("ArmorScore", base);
        }
        stack.m_41751_(tag);
    }

    private static int rollInitialArmorTier(RandomSource random) {
        double r = random.m_188500_();
        if (r < 0.4) {
            return 0;
        }
        if (r < 0.7) {
            return 1;
        }
        if (r < 0.95) {
            return 2 + random.m_188503_(3);
        }
        if (r < 0.99) {
            return 5 + random.m_188503_(3);
        }
        if (r < 0.999) {
            return 8 + random.m_188503_(2);
        }
        return 10;
    }

    private static void applyArmorLevelToNBT(ItemStack stack) {
        if (!ArmorRestrictionHandler.isArmor(stack)) {
            return;
        }
        int configLevel = ArmorRestrictionHandler.getArmorRequiredLevel(stack);
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("ArmorLevel") || tag.m_128451_("ArmorLevel") != configLevel) {
            tag.m_128405_("ArmorLevel", configLevel);
        }
        stack.m_41751_(tag);
    }

    public static void ensureArmorNBT(ItemStack stack) {
        ArmorRestrictionHandler.applyArmorLevelToNBT(stack);
        ArmorRestrictionHandler.ensureArmorScore(stack);
    }

    @SubscribeEvent
    public static void setArmorLevelOnCraft(PlayerEvent.ItemCraftedEvent event) {
        ItemStack stack = event.getCrafting();
        ArmorRestrictionHandler.applyArmorLevelToNBT(stack);
        if (ArmorRestrictionHandler.isArmor(stack)) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128379_("PlayerCrafted", true);
            stack.m_41751_(tag);
            ArmorRestrictionHandler.ensureArmorScore(stack);
        }
    }

    @SubscribeEvent
    public static void enforceArmorLevelOnSmithingPickup(PlayerContainerEvent.Close event) {
        AbstractContainerMenu menu = event.getContainer();
        if (menu.getClass().getSimpleName().toLowerCase().contains("smithing")) {
            for (int i = 0; i < menu.f_38839_.size(); ++i) {
                ItemStack stack = ((Slot)menu.f_38839_.get(i)).m_7993_();
                if (stack.m_41619_() || !ArmorRestrictionHandler.isArmor(stack)) continue;
                ArmorRestrictionHandler.applyArmorLevelToNBT(stack);
                stack.m_41784_().m_128379_("PlayerCrafted", true);
                ArmorRestrictionHandler.ensureArmorScore(stack);
            }
        }
    }

    @SubscribeEvent
    public static void onChestOpen(PlayerContainerEvent.Open event) {
        AbstractContainerMenu menu = event.getContainer();
        Player player = event.getEntity();
        int playerLevel = ArmorRestrictionHandler.getPlayerLevel(player);
        for (int i = 0; i < menu.f_38839_.size(); ++i) {
            ItemStack stack = ((Slot)menu.f_38839_.get(i)).m_7993_();
            if (stack.m_41619_()) continue;
            ArmorRestrictionHandler.applyArmorLevelToNBT(stack);
            if (!ArmorRestrictionHandler.isArmor(stack)) continue;
            CompoundTag tag = stack.m_41784_();
            boolean crafted = tag.m_128471_("PlayerCrafted");
            if (crafted) {
                ArmorRestrictionHandler.ensureArmorScore(stack);
                continue;
            }
            if (tag.m_128441_("ArmorRarity") && !tag.m_128461_("ArmorRarity").isEmpty()) {
                ArmorRestrictionHandler.ensureArmorScore(stack);
                continue;
            }
            int armorLevel = tag.m_128451_("ArmorLevel");
            int seedLevel = Math.max(playerLevel, armorLevel);
            ArmorRarityUtil.RarityData rarity = ArmorRarityUtil.generateRarity(seedLevel);
            String rarityKey = rarity.rarityKey;
            tag.m_128359_("ArmorRarity", rarityKey);
            int tier = ArmorRestrictionHandler.rollInitialArmorTier(player.m_9236_().m_213780_());
            tag.m_128405_("ArmorRarityTier", tier);
            stack.m_41751_(tag);
            ArmorRestrictionHandler.ensureArmorScore(stack);
        }
    }

    @SubscribeEvent
    public static void onMobDrop(LivingDropsEvent event) {
        LivingEntity mobEntity = event.getEntity();
        int mobLevel = mobEntity.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(ILevelData::getLevel).orElse(1);
        Level level = event.getEntity().m_9236_();
        event.getDrops().forEach(drop -> {
            ItemStack stack = drop.m_32055_();
            if (stack.m_41619_()) {
                return;
            }
            ArmorRestrictionHandler.applyArmorLevelToNBT(stack);
            if (ArmorRestrictionHandler.isArmor(stack)) {
                CompoundTag tag = stack.m_41784_();
                boolean crafted = tag.m_128471_("PlayerCrafted");
                if (crafted) {
                    ArmorRestrictionHandler.ensureArmorScore(stack);
                    return;
                }
                if (tag.m_128441_("ArmorRarity") && !tag.m_128461_("ArmorRarity").isEmpty()) {
                    ArmorRestrictionHandler.ensureArmorScore(stack);
                    return;
                }
                if (level.m_213780_().m_188500_() > 0.3) {
                    ArmorRestrictionHandler.ensureArmorScore(stack);
                    return;
                }
                int armorLevel = tag.m_128451_("ArmorLevel");
                int seedLevel = Math.max(mobLevel, armorLevel);
                ArmorRarityUtil.RarityData rarity = ArmorRarityUtil.generateRarity(seedLevel);
                String rarityKey = rarity.rarityKey;
                tag.m_128359_("ArmorRarity", rarityKey);
                int tier = ArmorRestrictionHandler.rollInitialArmorTier(level.m_213780_());
                tag.m_128405_("ArmorRarityTier", tier);
                stack.m_41751_(tag);
                ArmorRestrictionHandler.ensureArmorScore(stack);
            }
        });
    }

    @SubscribeEvent
    public static void onArmorEquip(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        EquipmentSlot slot = event.getSlot();
        ItemStack newArmor = event.getTo();
        if (ArmorRestrictionHandler.isArmor(newArmor) && ArmorRestrictionHandler.isArmorSlot(slot)) {
            int armorLevel;
            ArmorRestrictionHandler.applyArmorLevelToNBT(newArmor);
            ArmorRestrictionHandler.ensureArmorScore(newArmor);
            int requiredLevel = ArmorRestrictionHandler.getArmorRequiredLevel(newArmor);
            int playerLevel = ArmorRestrictionHandler.getPlayerLevel(player);
            int n = armorLevel = newArmor.m_41782_() && newArmor.m_41783_().m_128441_("ArmorLevel") ? newArmor.m_41783_().m_128451_("ArmorLevel") : requiredLevel;
            if (playerLevel < armorLevel && !newArmor.m_41619_()) {
                player.m_8061_(slot, ItemStack.f_41583_);
                player.m_7197_(newArmor, false, true);
                player.m_5661_((Component)Component.m_237110_((String)"message.levelingrank.armor_level_requirement", (Object[])new Object[]{armorLevel}).m_130940_(ChatFormatting.RED), true);
            }
        }
    }

    private static boolean isArmorSlot(EquipmentSlot slot) {
        return slot == EquipmentSlot.HEAD || slot == EquipmentSlot.CHEST || slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET;
    }

    private static int getPlayerLevel(Player player) {
        return player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(ILevelData::getLevel).orElse(1);
    }
}

