/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.handler;

import com.everydayxp.levelingrank.capability.ILevelData;
import com.everydayxp.levelingrank.capability.IPlayerQuestData;
import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.capability.PlayerQuestProvider;
import com.everydayxp.levelingrank.config.LevelingRankConfig;
import com.everydayxp.levelingrank.network.ModNetworkHandler;
import com.everydayxp.levelingrank.network.SyncDailyQuestS2CPacket;
import com.everydayxp.levelingrank.util.JsonQuestUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="levelingrank", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DailyQuestHandler {
    private static final Random RANDOM = new Random();
    private static long lastDay = -1L;
    private static final List<String> DAILY_REWARD_ITEM_IDS = List.of("levelingrank:fusion_fragment");

    private static int getDailyQuestXpReward(ServerPlayer player) {
        int xpNeeded = player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(ILevelData::getXPForNextLevel).orElse(0);
        int reward = (int)Math.floor((float)xpNeeded * 0.3f);
        return Math.max(reward, 1);
    }

    private static ItemStack getRandomDailyRewardItem() {
        if (DAILY_REWARD_ITEM_IDS.isEmpty()) {
            return ItemStack.f_41583_;
        }
        String id = DAILY_REWARD_ITEM_IDS.get(RANDOM.nextInt(DAILY_REWARD_ITEM_IDS.size()));
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(id));
        if (item == null) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)item, 3);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = event.getServer();
        if (server == null) {
            return;
        }
        long currentDay = server.m_129783_().m_46468_() / 24000L;
        if (currentDay != lastDay) {
            lastDay = currentDay;
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                player.getCapability(PlayerQuestProvider.PLAYER_QUEST).ifPresent(data -> {
                    DailyQuestHandler.assignNewDailyQuest(player, data);
                    data.setLastQuestDay(currentDay);
                    if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                        player.m_213846_((Component)Component.m_237113_((String)("[DQ-DEBUG] Nuevo d\u00c3\u00ada " + currentDay + " \u00e2\u2020\u2019 asignando daily.")));
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        boolean dayChangedForPlayer;
        LazyOptional opt;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            player2.m_213846_((Component)Component.m_237113_((String)"[DQ-DEBUG] onPlayerLoggedIn (DailyQuestHandler)"));
        }
        if (!(opt = player2.getCapability(PlayerQuestProvider.PLAYER_QUEST)).isPresent()) {
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                player2.m_213846_((Component)Component.m_237113_((String)"[DQ-DEBUG] Login: SIN capability PlayerQuestProvider.PLAYER_QUEST"));
            }
            return;
        }
        IPlayerQuestData data = opt.resolve().orElse(null);
        if (data == null) {
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                player2.m_213846_((Component)Component.m_237113_((String)"[DQ-DEBUG] Login: capability presente pero data=null"));
            }
            return;
        }
        long currentDay = player2.f_8924_.m_129783_().m_46468_() / 24000L;
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            player2.m_213846_((Component)Component.m_237113_((String)("[DQ-DEBUG] Login: questId='" + data.getQuestId() + "' lastDay=" + data.getLastQuestDay() + " currentDay=" + currentDay)));
        }
        boolean noQuest = data.getQuestId() == null || data.getQuestId().trim().isEmpty();
        boolean bl = dayChangedForPlayer = data.getLastQuestDay() != currentDay;
        if (noQuest || dayChangedForPlayer) {
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                player2.m_213846_((Component)Component.m_237113_((String)("[DQ-DEBUG] Login: asignando NUEVA daily (noQuest=" + noQuest + ", dayChanged=" + dayChangedForPlayer + ")")));
            }
            DailyQuestHandler.assignNewDailyQuest(player2, data);
            data.setLastQuestDay(currentDay);
        } else {
            MutableComponent itemName;
            String targetName = data.getTargetEntityId();
            int xpReward = data.getDailyRewardXp();
            Item rewardItem = data.getDailyRewardItemId() == null || data.getDailyRewardItemId().isEmpty() ? null : (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(data.getDailyRewardItemId()));
            int itemCount = data.getDailyRewardItemCount();
            Object object = itemName = rewardItem == null ? Component.m_237113_((String)"No reward") : new ItemStack((ItemLike)rewardItem).m_41786_();
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                player2.m_213846_((Component)Component.m_237113_((String)("[DQ-DEBUG] Login: re-sincronizando daily existente. target=" + targetName + " prog=" + data.getProgress() + "/" + data.getRequiredAmount())));
            }
            ModNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SyncDailyQuestS2CPacket(true, targetName, data.getRequiredAmount(), data.getProgress(), xpReward, itemCount, (Component)itemName));
        }
    }

    private static void assignNewDailyQuest(ServerPlayer player, IPlayerQuestData data) {
        int playerLevel = DailyQuestHandler.getPlayerLevel(player);
        List<JsonQuestUtil.KillQuestDefinition> quests = JsonQuestUtil.getKillQuests();
        if (quests.isEmpty()) {
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                player.m_213846_((Component)Component.m_237113_((String)"[DQ-DEBUG] assignNewDailyQuest: NO hay quests cargadas."));
            }
            return;
        }
        List<JsonQuestUtil.KillQuestDefinition> eligible = quests.stream().filter(q -> playerLevel >= q.minPlayerLevel && playerLevel <= q.maxPlayerLevel).toList();
        if (eligible.isEmpty()) {
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                player.m_213846_((Component)Component.m_237113_((String)("[DQ-DEBUG] assignNewDailyQuest: sin quests elegibles para nivel " + playerLevel)));
            }
            return;
        }
        JsonQuestUtil.KillQuestDefinition quest = eligible.get(RANDOM.nextInt(eligible.size()));
        List<JsonQuestUtil.KillQuestEntityEntry> entityPool = quest.entityPool.stream().filter(e -> playerLevel >= e.minPlayerLevel).toList();
        if (entityPool.isEmpty()) {
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                player.m_213846_((Component)Component.m_237113_((String)("[DQ-DEBUG] assignNewDailyQuest: quest '" + quest.id + "' sin entidades elegibles para nivel " + playerLevel)));
            }
            return;
        }
        JsonQuestUtil.KillQuestEntityEntry entry = entityPool.get(RANDOM.nextInt(entityPool.size()));
        int baseMax = entry.max;
        int baseMin = entry.min;
        if (baseMax < baseMin) {
            baseMax = baseMin;
        }
        int required = baseMin + RANDOM.nextInt(baseMax - baseMin + 1);
        data.setKillQuest(quest.id, entry.id, required, 0);
        int xpReward = DailyQuestHandler.getDailyQuestXpReward(player);
        ItemStack rewardStack = DailyQuestHandler.getRandomDailyRewardItem();
        int itemCount = rewardStack.m_41613_();
        String rewardItemId = rewardStack.m_41619_() ? "" : BuiltInRegistries.f_257033_.m_7981_((Object)rewardStack.m_41720_()).toString();
        data.setDailyRewardXp(xpReward);
        data.setDailyRewardItemId(rewardItemId);
        data.setDailyRewardItemCount(itemCount);
        MutableComponent itemName = rewardStack.m_41619_() ? Component.m_237113_((String)"No reward") : rewardStack.m_41786_();
        String targetId = entry.id;
        MutableComponent prettyName = Component.m_237115_((String)("entity." + targetId.replace(":", ".")));
        String prettyNameStr = prettyName.getString();
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            player.m_213846_((Component)Component.m_237113_((String)("[DQ-DEBUG] Nueva daily: questId=" + quest.id + " targetId=" + targetId + " pretty='" + prettyNameStr + "' required=" + required + " xpReward=" + xpReward + " rewardItem=" + (rewardItemId.isEmpty() ? "none" : rewardItemId) + " x" + itemCount)));
        }
        player.m_5661_((Component)Component.m_237113_((String)"New daily mission: ").m_7220_((Component)Component.m_237113_((String)("Kill " + required + " " + prettyNameStr))), false);
        ModNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncDailyQuestS2CPacket(true, prettyNameStr, required, 0, xpReward, itemCount, (Component)itemName));
    }

    @SubscribeEvent
    public static void onMobDeath(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        String killedId = event.getEntity().m_6095_().m_204041_().m_205785_().m_135782_().toString();
        player.getCapability(PlayerQuestProvider.PLAYER_QUEST).ifPresent(data -> {
            if (data.getQuestId() == null || data.getQuestId().isEmpty()) {
                return;
            }
            if (!killedId.equals(data.getTargetEntityId())) {
                return;
            }
            if (data.getProgress() >= data.getRequiredAmount()) {
                return;
            }
            data.incrementProgress(1);
            int xpReward = data.getDailyRewardXp();
            Item rewardItem = data.getDailyRewardItemId() == null || data.getDailyRewardItemId().isEmpty() ? null : (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(data.getDailyRewardItemId()));
            int itemCount = data.getDailyRewardItemCount();
            MutableComponent itemName = rewardItem == null ? Component.m_237113_((String)"No reward") : new ItemStack((ItemLike)rewardItem).m_41786_();
            String targetName = data.getTargetEntityId();
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                player.m_213846_((Component)Component.m_237113_((String)("[DQ-DEBUG] Kill " + killedId + " \u00e2\u2020\u2019 prog=" + data.getProgress() + "/" + data.getRequiredAmount())));
            }
            ModNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncDailyQuestS2CPacket(true, targetName, data.getRequiredAmount(), data.getProgress(), xpReward, itemCount, (Component)itemName));
            if (data.getProgress() >= data.getRequiredAmount()) {
                ItemStack reward;
                player.m_6330_(SoundEvents.f_12496_, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(levelData -> {
                    levelData.addXP(xpReward);
                    ModNetworkHandler.syncLevelData(player, levelData);
                });
                if (rewardItem != null && itemCount > 0 && !player.m_36356_(reward = new ItemStack((ItemLike)rewardItem, itemCount))) {
                    player.m_36176_(reward, false);
                }
                player.m_5661_((Component)Component.m_237113_((String)"Daily mission completed!").m_130938_(style -> style.m_178520_(0x55FF55)), false);
                if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                    player.m_213846_((Component)Component.m_237113_((String)("[DQ-DEBUG] Daily COMPLETADA. XP=" + xpReward + " + " + (String)(rewardItem == null || itemCount <= 0 ? "sin reward" : itemCount + "x " + itemName.getString()))));
                }
            }
        });
    }

    private static int getPlayerLevel(ServerPlayer player) {
        return player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(ILevelData::getLevel).orElse(1);
    }
}

