/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.handler;

import com.everydayxp.levelingrank.capability.ILevelData;
import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.util.JsonRestrictionUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="levelingrank")
public class GuiRestrictionHandler {
    private static final int NO_RESTRICTION = -1;
    private static final Map<String, Integer> BLOCK_LEVELS = new HashMap<String, Integer>();
    private static final Map<TagKey<Block>, Integer> TAG_LEVELS = new HashMap<TagKey<Block>, Integer>();
    private static boolean initialized = false;

    public static void reloadRestrictions() {
        Integer value;
        BLOCK_LEVELS.clear();
        TAG_LEVELS.clear();
        JsonRestrictionUtil.RestrictionData data = JsonRestrictionUtil.forType("gui");
        for (Map.Entry<String, Object> entry : data.items.entrySet()) {
            value = GuiRestrictionHandler.parseInt(entry.getValue());
            if (value == null) continue;
            BLOCK_LEVELS.put(entry.getKey(), value);
        }
        for (Map.Entry<String, Object> entry : data.tags.entrySet()) {
            ResourceLocation loc;
            value = GuiRestrictionHandler.parseInt(entry.getValue());
            if (value == null || (loc = ResourceLocation.m_135820_((String)entry.getKey())) == null) continue;
            TAG_LEVELS.put((TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)loc), value);
        }
        initialized = true;
    }

    private static Integer parseInt(Object value) {
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.intValue();
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        if (!initialized) {
            GuiRestrictionHandler.reloadRestrictions();
        }
        if (event.getLevel().m_5776_()) {
            return;
        }
        Player player = event.getEntity();
        BlockState state = event.getLevel().m_8055_(event.getPos());
        ResourceLocation blockKey = state.m_60734_().m_204297_().m_205785_().m_135782_();
        int requiredLevel = BLOCK_LEVELS.getOrDefault(blockKey.toString(), -1);
        if (requiredLevel == -1) {
            for (Map.Entry<TagKey<Block>, Integer> entry : TAG_LEVELS.entrySet()) {
                if (!state.m_204336_(entry.getKey())) continue;
                requiredLevel = entry.getValue();
                break;
            }
        }
        if (requiredLevel > 0 && GuiRestrictionHandler.getPlayerLevel(player) < requiredLevel) {
            event.setCanceled(true);
            player.m_5661_((Component)Component.m_237110_((String)"message.levelingrank.block_interact_requirement", (Object[])new Object[]{requiredLevel}).m_130940_(ChatFormatting.RED), true);
        }
    }

    private static int getPlayerLevel(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            return sp.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(ILevelData::getLevel).orElse(1);
        }
        return 1;
    }
}

