/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.handler;

import com.everydayxp.levelingrank.capability.ILevelData;
import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.config.LevelingRankConfig;
import com.everydayxp.levelingrank.handler.WeaponRestrictionHandler;
import com.everydayxp.levelingrank.util.WeaponRarityUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="levelingrank")
public class LootRarityHandler {
    private static int rollInitialTier(RandomSource random) {
        double r = random.m_188500_();
        if (r < 0.4) {
            return 0;
        }
        if (r < 0.7) {
            return 1;
        }
        if (r < 0.95) {
            return 2 + random.m_188503_(3);
        }
        if (r < 0.99) {
            return 5 + random.m_188503_(3);
        }
        if (r < 0.999) {
            return 8 + random.m_188503_(2);
        }
        return 10;
    }

    private static int getPlayerLevel(Player player) {
        return player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(ILevelData::getLevel).orElse(1);
    }

    @SubscribeEvent
    public static void onChestOpen(PlayerContainerEvent.Open event) {
        AbstractContainerMenu menu = event.getContainer();
        Player player = event.getEntity();
        String name = menu.getClass().getSimpleName().toLowerCase();
        if (!name.contains("chest")) {
            return;
        }
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[LevelingRank DEBUG] Chest opened by " + player.m_7755_().getString());
        }
        int playerLevel = LootRarityHandler.getPlayerLevel(player);
        int totalSlots = menu.f_38839_.size();
        int playerInvSlots = 36;
        int chestSlots = Math.max(0, totalSlots - playerInvSlots);
        for (int i = 0; i < chestSlots; ++i) {
            CompoundTag tag;
            ItemStack stack = ((Slot)menu.f_38839_.get(i)).m_7993_();
            if (stack == null || stack.m_41619_() || !WeaponRestrictionHandler.isWeapon(stack) || (tag = stack.m_41784_()).m_128441_("WeaponRarity") && !tag.m_128461_("WeaponRarity").isEmpty() || tag.m_128471_("PlayerCrafted")) continue;
            double baseDamage = WeaponRestrictionHandler.getWeaponBaseDamage(stack);
            int reqLevel = WeaponRestrictionHandler.getWeaponRequiredLevel(stack);
            int raritySeedLevel = Math.max(playerLevel, reqLevel);
            WeaponRestrictionHandler.attachWeaponLevelOnly(stack, raritySeedLevel, baseDamage);
            WeaponRarityUtil.RarityData rarityData = WeaponRarityUtil.generateRarity(raritySeedLevel);
            String rarityKey = rarityData.rarityKey;
            tag.m_128359_("WeaponRarity", rarityKey);
            int rarityTier = LootRarityHandler.rollInitialTier(player.m_9236_().m_213780_());
            tag.m_128405_("RarityTier", rarityTier);
            tag.m_128347_("WeaponBaseDmg", baseDamage);
            if (rarityTier <= 0) {
                tag.m_128347_("WeaponBonusPct", 0.0);
                tag.m_128347_("WeaponBonusDmg", 0.0);
                tag.m_128347_("WeaponTotalDmg", baseDamage);
            } else {
                double tierBonusPct = WeaponRarityUtil.getTierBonusPct(rarityKey, rarityTier);
                tag.m_128347_("WeaponBonusPct", tierBonusPct);
                double bonus = baseDamage * tierBonusPct;
                tag.m_128347_("WeaponBonusDmg", bonus);
                tag.m_128347_("WeaponTotalDmg", baseDamage + bonus);
            }
            stack.m_41751_(tag);
            WeaponRestrictionHandler.ensurePierce(stack);
        }
    }

    @SubscribeEvent
    public static void onMobDrop(LivingDropsEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[LevelingRank DEBUG] Mob drops processed by " + player.m_7755_().getString());
        }
        int playerLevel = LootRarityHandler.getPlayerLevel(player);
        event.getDrops().forEach(drop -> {
            ItemStack stack = drop.m_32055_();
            if (stack == null || stack.m_41619_()) {
                return;
            }
            if (!WeaponRestrictionHandler.isWeapon(stack)) {
                return;
            }
            double baseDamage = WeaponRestrictionHandler.getWeaponBaseDamage(stack);
            int reqLevel = WeaponRestrictionHandler.getWeaponRequiredLevel(stack);
            int raritySeedLevel = Math.max(playerLevel, reqLevel);
            WeaponRestrictionHandler.attachWeaponLevelOnly(stack, raritySeedLevel, baseDamage);
            if (stack.m_41782_() && stack.m_41783_().m_128441_("WeaponRarity") && !stack.m_41783_().m_128461_("WeaponRarity").isEmpty()) {
                return;
            }
            if (event.getEntity().m_9236_().m_213780_().m_188500_() > 0.3) {
                return;
            }
            CompoundTag tag = stack.m_41784_();
            WeaponRarityUtil.RarityData rarityData = WeaponRarityUtil.generateRarity(raritySeedLevel);
            String rarityKey = rarityData.rarityKey;
            tag.m_128359_("WeaponRarity", rarityKey);
            int rarityTier = LootRarityHandler.rollInitialTier(event.getEntity().m_9236_().m_213780_());
            tag.m_128405_("RarityTier", rarityTier);
            tag.m_128347_("WeaponBaseDmg", baseDamage);
            if (rarityTier <= 0) {
                tag.m_128347_("WeaponBonusPct", 0.0);
                tag.m_128347_("WeaponBonusDmg", 0.0);
                tag.m_128347_("WeaponTotalDmg", baseDamage);
            } else {
                double tierBonusPct = WeaponRarityUtil.getTierBonusPct(rarityKey, rarityTier);
                tag.m_128347_("WeaponBonusPct", tierBonusPct);
                double bonus = baseDamage * tierBonusPct;
                tag.m_128347_("WeaponBonusDmg", bonus);
                tag.m_128347_("WeaponTotalDmg", baseDamage + bonus);
            }
            stack.m_41751_(tag);
            WeaponRestrictionHandler.ensurePierce(stack);
        });
    }
}

