/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.handler;

import com.everydayxp.levelingrank.capability.ILevelData;
import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.util.JsonRestrictionUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="levelingrank")
public class MineableRestrictionHandler {
    private static JsonRestrictionUtil.RestrictionData MINEABLE_DATA = JsonRestrictionUtil.forType("mineable");
    private static final Map<String, TagKey<Block>> TAG_CACHE = new HashMap<String, TagKey<Block>>();
    private static boolean initialized = false;

    public static void reloadRestrictions() {
        MINEABLE_DATA = JsonRestrictionUtil.forType("mineable");
        TAG_CACHE.clear();
        initialized = true;
        System.out.println("[LevelingRank] MineableRestrictionHandler: restricciones recargadas.");
    }

    private static Integer tryParseInt(Object value) {
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.intValue();
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static int getRequiredLevel(BlockState state) {
        Map map;
        Object lvlObj;
        if (!initialized) {
            MineableRestrictionHandler.reloadRestrictions();
        }
        ResourceLocation blockKey = state.m_60734_().m_204297_().m_205785_().m_135782_();
        Object direct = MineableRestrictionHandler.MINEABLE_DATA.items.get(blockKey.toString());
        Integer requiredLevel = null;
        if (direct instanceof Number) {
            Number n = (Number)direct;
            requiredLevel = n.intValue();
        } else if (direct instanceof Map && (lvlObj = (map = (Map)direct).get("min_level")) != null) {
            requiredLevel = MineableRestrictionHandler.tryParseInt(lvlObj);
        }
        if (requiredLevel == null) {
            for (Map.Entry<String, Object> entry : MineableRestrictionHandler.MINEABLE_DATA.tags.entrySet()) {
                Map map2;
                Object lvlObj2;
                String tagName = entry.getKey();
                TagKey<Block> tag = TAG_CACHE.get(tagName);
                if (tag == null) {
                    ResourceLocation tagLoc = ResourceLocation.m_135820_((String)tagName);
                    TagKey<Block> tagKey = tag = tagLoc != null ? TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tagLoc) : null;
                    if (tag != null) {
                        TAG_CACHE.put(tagName, tag);
                    }
                }
                if (tag == null || !state.m_204336_(tag)) continue;
                Object tagCfg = entry.getValue();
                if (tagCfg instanceof Number) {
                    Number n = (Number)tagCfg;
                    requiredLevel = n.intValue();
                } else if (tagCfg instanceof Map && (lvlObj2 = (map2 = (Map)tagCfg).get("min_level")) != null) {
                    requiredLevel = MineableRestrictionHandler.tryParseInt(lvlObj2);
                }
                if (requiredLevel == null) continue;
                break;
            }
        }
        return requiredLevel != null ? requiredLevel : -1;
    }

    @SubscribeEvent
    public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Player player = event.getEntity();
        BlockState state = event.getLevel().m_8055_(event.getPos());
        int requiredLevel = MineableRestrictionHandler.getRequiredLevel(state);
        if (requiredLevel > 0 && MineableRestrictionHandler.getPlayerLevel(player) < requiredLevel) {
            event.setCanceled(true);
            player.m_5661_((Component)Component.m_237110_((String)"message.levelingrank.mine_block_requirement", (Object[])new Object[]{requiredLevel}).m_130940_(ChatFormatting.RED), true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        BlockState state = event.getState();
        int requiredLevel = MineableRestrictionHandler.getRequiredLevel(state);
        if (requiredLevel > 0 && MineableRestrictionHandler.getPlayerLevel(player) < requiredLevel) {
            event.setCanceled(true);
            player.m_5661_((Component)Component.m_237110_((String)"message.levelingrank.mine_block_requirement", (Object[])new Object[]{requiredLevel}).m_130940_(ChatFormatting.RED), true);
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.m_150109_().m_6596_();
            }
        }
    }

    private static int getPlayerLevel(Player player) {
        int n;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            n = sp.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(ILevelData::getLevel).orElse(1);
        } else {
            n = 1;
        }
        return n;
    }
}

