/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.handler;

import com.everydayxp.levelingrank.attribute.ModAttributes;
import com.everydayxp.levelingrank.capability.ILevelData;
import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.config.LevelingRankConfig;
import com.everydayxp.levelingrank.events.DailyXPBonusHandler;
import com.everydayxp.levelingrank.network.ModNetworkHandler;
import com.everydayxp.levelingrank.network.SyncMobLevelS2CPacket;
import com.everydayxp.levelingrank.sound.ModSounds;
import com.everydayxp.levelingrank.util.AFKTracker;
import com.everydayxp.levelingrank.util.JsonRestrictionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="levelingrank")
public class MobLevelHandler {
    private static final JsonRestrictionUtil.RestrictionData ENTITY_LEVELS_DATA = JsonRestrictionUtil.forType("entity");
    private static final Random LEVEL_RANDOM = new Random();

    private static boolean isLevelledMob(LivingEntity entity) {
        if (entity instanceof Player) {
            return false;
        }
        String entityId = entity.m_6095_().m_204041_().m_205785_().m_135782_().toString();
        return !LevelingRankConfig.getLifeBonusEntityBlacklist().contains(entityId);
    }

    private static boolean isBossFromJson(String entityId) {
        Map m;
        Object data = MobLevelHandler.ENTITY_LEVELS_DATA.items.get(entityId);
        if (data instanceof Map && (m = (Map)data).containsKey("boss")) {
            Object bossObj = m.get("boss");
            return bossObj instanceof Boolean ? (Boolean)bossObj : Boolean.parseBoolean(bossObj.toString());
        }
        return false;
    }

    private static boolean canGiveXP(LivingEntity entity) {
        String entityId = entity.m_6095_().m_204041_().m_205785_().m_135782_().toString();
        if (LevelingRankConfig.getLifeBonusEntityBlacklist().contains(entityId)) {
            return false;
        }
        return MobLevelHandler.isHostileMob(entity) || MobLevelHandler.ENTITY_LEVELS_DATA.items.containsKey(entityId);
    }

    private static boolean isHostileMob(LivingEntity entity) {
        return entity instanceof Monster;
    }

    private static int getFinalMobLevel(LivingEntity mob, ServerLevel serverLevel) {
        int candidate;
        String key = mob.m_6095_().m_204041_().m_205785_().m_135782_().toString();
        Object rangeObj = MobLevelHandler.ENTITY_LEVELS_DATA.items.get(key);
        int minLvl = 1;
        int maxLvl = LevelingRankConfig.getMaxLevel();
        if (rangeObj instanceof Map) {
            Map rangeMap = (Map)rangeObj;
            if (rangeMap.containsKey("min")) {
                Object minObj = rangeMap.get("min");
                try {
                    minLvl = minObj instanceof Number ? ((Number)minObj).intValue() : (int)Double.parseDouble(minObj.toString());
                }
                catch (Exception ignored) {
                    minLvl = 1;
                }
            }
            if (rangeMap.containsKey("max")) {
                Object maxObj = rangeMap.get("max");
                try {
                    int jsonMax = maxObj instanceof Number ? ((Number)maxObj).intValue() : (int)Double.parseDouble(maxObj.toString());
                    maxLvl = Math.min(LevelingRankConfig.getMaxLevel(), jsonMax);
                }
                catch (Exception ignored) {
                    maxLvl = LevelingRankConfig.getMaxLevel();
                }
            }
        }
        double searchRadius = 64.0;
        List nearbyPlayers = serverLevel.m_45976_(ServerPlayer.class, mob.m_20191_().m_82400_(searchRadius));
        int strongestNearby = minLvl;
        if (!nearbyPlayers.isEmpty()) {
            for (ServerPlayer player : nearbyPlayers) {
                int lvl = MobLevelHandler.getPlayerLevel((Player)player);
                if (lvl <= strongestNearby) continue;
                strongestNearby = lvl;
            }
        } else {
            int lvl;
            List dimPlayers = serverLevel.m_6907_();
            double minDist = Double.MAX_VALUE;
            ServerPlayer nearestPlayer = null;
            BlockPos mobPos = mob.m_20183_();
            for (ServerPlayer player : dimPlayers) {
                double dist = player.m_20183_().m_123331_((Vec3i)mobPos);
                if (!(dist < minDist)) continue;
                minDist = dist;
                nearestPlayer = player;
            }
            if (nearestPlayer != null && (lvl = MobLevelHandler.getPlayerLevel(nearestPlayer)) > strongestNearby) {
                strongestNearby = lvl;
            }
        }
        if (strongestNearby <= 10) {
            candidate = strongestNearby;
        } else {
            int maxOverPlayer = strongestNearby + 9;
            candidate = Math.min(maxOverPlayer, maxLvl);
        }
        int finalLevel = Math.max(minLvl, Math.min(candidate, maxLvl));
        boolean canBePowerful = mob instanceof Monster;
        boolean isPowerful = false;
        if (canBePowerful && LEVEL_RANDOM.nextInt(5) == 0) {
            int extraLevels = 1 + LEVEL_RANDOM.nextInt(10);
            finalLevel = Math.min(maxLvl, finalLevel + extraLevels);
            isPowerful = true;
        }
        mob.getPersistentData().m_128379_("levelingrank_is_powerful", isPowerful);
        boolean isSpecial = false;
        if (isPowerful && LEVEL_RANDOM.nextInt(100) < 30) {
            isSpecial = true;
            mob.getPersistentData().m_128379_("levelingrank_is_special_elite", true);
        }
        return finalLevel;
    }

    private static int getPlayerLevel(Player player) {
        return player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(ILevelData::getLevel).orElse(1);
    }

    private static int getMobLevel(LivingEntity mob) {
        return mob.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(ILevelData::getLevel).orElse(1);
    }

    @SubscribeEvent
    public static void onPlayerAttackMob(LivingHurtEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity mob = event.getEntity();
        if (!MobLevelHandler.isLevelledMob(mob)) {
            return;
        }
        if (!mob.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            String uuid;
            String current;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ArrayList<String> attackers = new ArrayList<String>();
            if (mob.getPersistentData().m_128441_("levelingrank_attackers") && !(current = mob.getPersistentData().m_128461_("levelingrank_attackers")).isEmpty()) {
                attackers.addAll(Arrays.asList(current.split(";")));
            }
            if (!attackers.contains(uuid = serverPlayer.m_20148_().toString())) {
                attackers.add(uuid);
                mob.getPersistentData().m_128359_("levelingrank_attackers", String.join((CharSequence)";", attackers));
            }
            mob.getPersistentData().m_128405_("levelingrank_last_hit_tick", mob.f_19797_);
        }
    }

    public static boolean shouldShowLevelName(LivingEntity entity) {
        return MobLevelHandler.isLevelledMob(entity);
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent event) {
        TamableAnimal tamable;
        LivingEntity livingEntity;
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity mob = event.getEntity();
        if (mob instanceof Player) {
            return;
        }
        if (mob.m_9236_().m_5776_() || mob.f_19797_ % 20 != 0) {
            return;
        }
        if (mob instanceof TamableAnimal && (livingEntity = (tamable = (TamableAnimal)mob).m_269323_()) instanceof Player) {
            Player owner = (Player)livingEntity;
            int ownerLevel = MobLevelHandler.getPlayerLevel(owner);
            double scale = (Double)LevelingRankConfig.LIFE_BONUS_SCALE.get();
            double baseHp = mob.getPersistentData().m_128459_("levelingrank_base_health");
            if (baseHp <= 1.0) {
                baseHp = 20.0;
            }
            double expectedHp = baseHp * (1.0 + scale * (double)ownerLevel);
            AttributeInstance healthAttr = mob.m_21051_(Attributes.f_22276_);
            if (healthAttr != null && Math.abs(healthAttr.m_22115_() - expectedHp) > 0.1) {
                healthAttr.m_22100_(expectedHp);
                mob.m_21153_((float)expectedHp);
            }
        }
    }

    @SubscribeEvent
    public static void onMobDeath(LivingDeathEvent event) {
        String attStr;
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        LivingEntity mob = event.getEntity();
        if (!MobLevelHandler.canGiveXP(mob)) {
            return;
        }
        ResourceLocation mobKey = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        String mobId = mobKey != null ? mobKey.toString() : "unknown";
        List nearbyPlayers = mob.m_9236_().m_45976_(Player.class, mob.m_20191_().m_82400_(16.0));
        boolean isBoss = mob.getPersistentData().m_128471_("levelingrank_is_boss");
        if (!isBoss) {
            isBoss = MobLevelHandler.isBossFromJson(mobId);
        }
        boolean isSpecialElite = mob.getPersistentData().m_128471_("levelingrank_is_special_elite");
        HashSet<String> attackers = new HashSet<String>();
        if (mob.getPersistentData().m_128441_("levelingrank_attackers") && !(attStr = mob.getPersistentData().m_128461_("levelingrank_attackers")).isEmpty()) {
            attackers.addAll(Arrays.asList(attStr.split(";")));
        }
        double baseXp = LevelingRankConfig.getMobKillXPBase();
        double maxHpFinal = mob.m_21233_();
        double lifeFactor = maxHpFinal / 20.0;
        double hpScale = (Double)LevelingRankConfig.HP_XP_SCALE.get();
        double lifeBonusXp = lifeFactor * hpScale;
        double dailyMultiplier = DailyXPBonusHandler.getCurrentXPMultiplier();
        ResourceLocation dimId = mob.m_9236_().m_46472_().m_135782_();
        double dimensionMultiplier = LevelingRankConfig.getDimensionXPBonusMap().getOrDefault(dimId.toString(), 1.0);
        for (Player player : nearbyPlayers) {
            if (player instanceof ServerPlayer) {
                boolean afkByMove;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (((Boolean)LevelingRankConfig.ENABLE_AFK_TRACKER.get()).booleanValue() && (afkByMove = AFKTracker.isPlayerAFK_Movement(serverPlayer)) && !isBoss) continue;
            }
            double totalXp = (baseXp + lifeBonusXp) * dailyMultiplier * dimensionMultiplier;
            if (isSpecialElite) {
                totalXp *= 4.0;
            }
            int finalXp = (int)Math.ceil(totalXp);
            player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(cap -> {
                int beforeLevel = cap.getLevel();
                cap.addXP(finalXp);
                cap.tryLevelUp();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (cap.getLevel() > beforeLevel) {
                        serverPlayer.m_6330_((SoundEvent)ModSounds.LEVEL_UP_CUSTOM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    ModNetworkHandler.syncLevelData(serverPlayer, cap);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onMobSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity mob = (LivingEntity)entity;
        if (mob instanceof Player || event.getLevel().m_5776_()) {
            return;
        }
        String entityId = mob.m_6095_().m_204041_().m_205785_().m_135782_().toString();
        mob.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(mobLevel -> {
            AttributeInstance attAttr;
            Level patt15420$temp;
            ServerLevel serverLevel;
            int finalLevel;
            boolean loadedFromDisk = event.loadedFromDisk();
            if (loadedFromDisk) {
                finalLevel = mobLevel.getLevel();
                if (finalLevel <= 0) {
                    finalLevel = 1;
                }
            } else {
                int n;
                Level patt15157$temp = event.getLevel();
                if (patt15157$temp instanceof ServerLevel) {
                    serverLevel = (ServerLevel)patt15157$temp;
                    n = MobLevelHandler.getFinalMobLevel(mob, serverLevel);
                } else {
                    n = 1;
                }
                finalLevel = n;
                mobLevel.setLevel(finalLevel);
                mobLevel.setXP(0);
            }
            if ((patt15420$temp = event.getLevel()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)patt15420$temp;
                ModNetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> mob), (Object)new SyncMobLevelS2CPacket(mob.m_19879_(), finalLevel));
            }
            boolean isBoss = MobLevelHandler.isBossFromJson(entityId);
            mob.getPersistentData().m_128379_("levelingrank_is_boss", isBoss);
            AttributeInstance healthAttr = mob.m_21051_(Attributes.f_22276_);
            if (healthAttr != null && !mob.getPersistentData().m_128441_("levelingrank_base_health")) {
                double vanillaBase = healthAttr.m_22115_();
                if (!healthAttr.m_22122_().isEmpty()) {
                    vanillaBase -= healthAttr.m_22122_().stream().mapToDouble(AttributeModifier::m_22218_).sum();
                }
                mob.getPersistentData().m_128347_("levelingrank_base_health", vanillaBase);
            }
            if ((attAttr = mob.m_21051_(Attributes.f_22281_)) != null && !mob.getPersistentData().m_128441_("levelingrank_base_attack")) {
                double vanillaBase = attAttr.m_22115_();
                if (!attAttr.m_22122_().isEmpty()) {
                    vanillaBase -= attAttr.m_22122_().stream().mapToDouble(AttributeModifier::m_22218_).sum();
                }
                mob.getPersistentData().m_128347_("levelingrank_base_attack", vanillaBase);
            }
            MobLevelHandler.applyAllBonuses(mob, finalLevel, isBoss);
            AttributeInstance armorAttr = mob.m_21051_((Attribute)ModAttributes.ARMOR_SCORE.get());
            AttributeInstance pierceAttr = mob.m_21051_((Attribute)ModAttributes.PIERCE.get());
            if (armorAttr != null && pierceAttr != null && mob instanceof Monster) {
                AttributeModifier oldPierce;
                int cappedLevel = Math.min(finalLevel, 200);
                double finalArmorScore = 35.0 * (double)cappedLevel;
                double finalPierce = 37.0 * (double)cappedLevel;
                UUID armorId = UUID.nameUUIDFromBytes("levelingrank_armor_score_bonus".getBytes());
                UUID pierceId = UUID.nameUUIDFromBytes("levelingrank_pierce_bonus".getBytes());
                AttributeModifier oldArmor = armorAttr.m_22111_(armorId);
                if (oldArmor != null) {
                    armorAttr.m_22130_(oldArmor);
                }
                if ((oldPierce = pierceAttr.m_22111_(pierceId)) != null) {
                    pierceAttr.m_22130_(oldPierce);
                }
                armorAttr.m_22125_(new AttributeModifier(armorId, "levelingrank_armor_score_bonus", finalArmorScore, AttributeModifier.Operation.ADDITION));
                pierceAttr.m_22125_(new AttributeModifier(pierceId, "levelingrank_pierce_bonus", finalPierce, AttributeModifier.Operation.ADDITION));
            }
        });
    }

    @SubscribeEvent
    public static void onMobFirstTick(LivingEvent.LivingTickEvent event) {
        AttributeInstance maxHealth;
        LivingEntity mob = event.getEntity();
        if (mob instanceof Player || mob.m_9236_().m_5776_()) {
            return;
        }
        if (mob.f_19797_ == 1 && (maxHealth = mob.m_21051_(Attributes.f_22276_)) != null && (double)mob.m_21223_() < maxHealth.m_22135_()) {
            mob.m_21153_((float)maxHealth.m_22135_());
        }
    }

    private static void applyAllBonuses(LivingEntity mob, int level, boolean isBoss) {
        AttributeInstance attackAttr;
        AttributeInstance healthAttr = mob.m_21051_(Attributes.f_22276_);
        if (healthAttr != null) {
            double baseHp;
            UUID hpModId = UUID.nameUUIDFromBytes("levelingrank_hp_bonus".getBytes());
            AttributeModifier oldHpMod = healthAttr.m_22111_(hpModId);
            if (oldHpMod != null) {
                healthAttr.m_22130_(oldHpMod);
            }
            if ((baseHp = mob.getPersistentData().m_128459_("levelingrank_base_health")) <= 1.0) {
                baseHp = 20.0;
            }
            double lifeScale = isBoss ? (Double)LevelingRankConfig.LIFE_BONUS_SCALE_BOSS.get() : (Double)LevelingRankConfig.LIFE_BONUS_SCALE.get();
            double bonusHp = baseHp * lifeScale * (double)level;
            healthAttr.m_22125_(new AttributeModifier(hpModId, "levelingrank_hp_bonus", bonusHp, AttributeModifier.Operation.ADDITION));
            mob.m_5634_((float)healthAttr.m_22135_());
        }
        if (((Boolean)LevelingRankConfig.ENABLE_ATTACK_BONUS.get()).booleanValue() && (attackAttr = mob.m_21051_(Attributes.f_22281_)) != null) {
            UUID atkModId = UUID.nameUUIDFromBytes("levelingrank_attack_bonus".getBytes());
            AttributeModifier oldAtkMod = attackAttr.m_22111_(atkModId);
            if (oldAtkMod != null) {
                attackAttr.m_22130_(oldAtkMod);
            }
            double baseAttack = mob.getPersistentData().m_128459_("levelingrank_base_attack");
            double attackScale = (Double)LevelingRankConfig.ATTACK_BONUS_SCALE.get();
            double bonusAttack = baseAttack * attackScale * (double)level;
            if (isBoss) {
                bonusAttack += baseAttack * 0.5;
            }
            attackAttr.m_22125_(new AttributeModifier(atkModId, "levelingrank_attack_bonus", bonusAttack, AttributeModifier.Operation.ADDITION));
        }
    }

    @SubscribeEvent
    public static void onLivingKnockBack(LivingKnockBackEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        boolean isBoss = entity.getPersistentData().m_128471_("levelingrank_is_boss");
        if (!isBoss) {
            String entityId = entity.m_6095_().m_204041_().m_205785_().m_135782_().toString();
            isBoss = MobLevelHandler.isBossFromJson(entityId);
        }
        if (isBoss) {
            event.setCanceled(true);
            return;
        }
        if (MobLevelHandler.isLevelledMob(entity)) {
            event.setStrength(event.getStrength() * 0.5f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (((Boolean)LevelingRankConfig.ENABLE_AFK_TRACKER.get()).booleanValue()) {
            AFKTracker.registerMovement(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onAnimalTame(AnimalTameEvent event) {
        TamableAnimal tamable;
        LivingEntity livingEntity;
        Animal animal = event.getAnimal();
        if (animal.m_9236_().m_5776_()) {
            return;
        }
        if (animal instanceof TamableAnimal && (livingEntity = (tamable = (TamableAnimal)animal).m_269323_()) instanceof Player) {
            Player owner = (Player)livingEntity;
            int ownerLevel = MobLevelHandler.getPlayerLevel(owner);
            double scale = (Double)LevelingRankConfig.LIFE_BONUS_SCALE.get();
            AttributeInstance healthAttr = animal.m_21051_(Attributes.f_22276_);
            double baseHp = healthAttr != null ? healthAttr.m_22115_() : 20.0;
            double recalcHp = baseHp * (1.0 + scale * (double)ownerLevel);
            if (healthAttr != null) {
                healthAttr.m_22100_(recalcHp);
            }
            animal.m_21153_((float)recalcHp);
        }
    }

    @SubscribeEvent
    public static void onAnyDamage(LivingHurtEvent event) {
        LivingEntity mob = event.getEntity();
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        if (!MobLevelHandler.isLevelledMob(mob)) {
            return;
        }
        mob.getPersistentData().m_128405_("levelingrank_last_any_hit_tick", mob.f_19797_);
    }

    @SubscribeEvent
    public static void onMobRegenTick(LivingEvent.LivingTickEvent event) {
        LivingEntity mob = event.getEntity();
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        if (!MobLevelHandler.isLevelledMob(mob)) {
            return;
        }
        if (mob.f_19797_ % 20 != 0) {
            return;
        }
        float maxHealth = mob.m_21233_();
        if (mob.m_21223_() >= maxHealth) {
            return;
        }
        int lastPlayerHitTick = mob.getPersistentData().m_128451_("levelingrank_last_hit_tick");
        int lastAnyHitTick = mob.getPersistentData().m_128451_("levelingrank_last_any_hit_tick");
        int now = mob.f_19797_;
        int ticksSincePlayerHit = lastPlayerHitTick == 0 ? Integer.MAX_VALUE : now - lastPlayerHitTick;
        int ticksSinceAnyHit = lastAnyHitTick == 0 ? Integer.MAX_VALUE : now - lastAnyHitTick;
        int regenDelay = 1200;
        if (ticksSincePlayerHit < regenDelay) {
            return;
        }
        if (ticksSinceAnyHit < regenDelay) {
            return;
        }
        float healAmount = maxHealth * 0.03f;
        float newHealth = Math.min(mob.m_21223_() + healAmount, maxHealth);
        mob.m_21153_(newHealth);
    }
}

