/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.handler;

import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.config.LevelingRankConfig;
import com.everydayxp.levelingrank.handler.ArmorRestrictionHandler;
import com.everydayxp.levelingrank.handler.WeaponRestrictionHandler;
import com.everydayxp.levelingrank.util.ArmorRarityUtil;
import com.everydayxp.levelingrank.util.DurabilityTooltipUtil;
import com.everydayxp.levelingrank.util.JsonRestrictionUtil;
import com.everydayxp.levelingrank.util.RarityColorNameUtil;
import com.everydayxp.levelingrank.util.WeaponRarityUtil;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="levelingrank")
public class TooltipRestrictionHandler {
    private static final Map<String, TagKey<Block>> blockTagCache = new HashMap<String, TagKey<Block>>();

    public static JsonRestrictionUtil.RestrictionData getRestrictions() {
        return JsonRestrictionUtil.forType("gui");
    }

    public static int getPlayerLevel(Player player) {
        return player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(data -> data.getLevel()).orElse(1);
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        Item withTier;
        int tier;
        ItemStack stack = event.getItemStack();
        List tooltip = event.getToolTip();
        if (tooltip.isEmpty()) {
            return;
        }
        tooltip.set(0, RarityColorNameUtil.getColoredName(stack));
        if (stack.m_41782_() && stack.m_41783_().m_128441_("RarityTier") && (tier = stack.m_41783_().m_128451_("RarityTier")) > 0) {
            Component baseName = (Component)tooltip.get(0);
            withTier = baseName.m_6881_().m_130946_(" ").m_7220_((Component)Component.m_237110_((String)"tooltip.levelingrank.tier_suffix", (Object[])new Object[]{tier}).m_130940_(ChatFormatting.AQUA));
            tooltip.set(0, withTier);
        }
        JsonRestrictionUtil.RestrictionData restrictions = TooltipRestrictionHandler.getRestrictions();
        withTier = stack.m_41720_();
        if (withTier instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)withTier;
            Block block = blockItem.m_40614_();
            ResourceLocation blockKey = block.m_204297_().m_205785_().m_135782_();
            Integer guiLevel = null;
            Object configObj = restrictions.items.get(blockKey.toString());
            if (configObj instanceof Number) {
                guiLevel = ((Number)configObj).intValue();
            }
            if (guiLevel == null) {
                for (String tagName : restrictions.tags.keySet()) {
                    Object tagObj;
                    TagKey<Block> tag = blockTagCache.get(tagName);
                    if (tag == null) {
                        ResourceLocation tagLoc = ResourceLocation.m_135820_((String)tagName);
                        TagKey<Block> tagKey = tag = tagLoc != null ? TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tagLoc) : null;
                        if (tag != null) {
                            blockTagCache.put(tagName, tag);
                        }
                    }
                    if (tag == null || !block.m_49966_().m_204336_(tag) || !((tagObj = restrictions.tags.get(tagName)) instanceof Number)) continue;
                    guiLevel = ((Number)tagObj).intValue();
                    break;
                }
            }
            if (guiLevel != null) {
                tooltip.add(Component.m_237110_((String)"tooltip.levelingrank.block_gui_requirement", (Object[])new Object[]{guiLevel}).m_130940_(ChatFormatting.RED));
            }
        } else if (WeaponRestrictionHandler.isWeapon(stack)) {
            if (!((Boolean)LevelingRankConfig.SHOW_VANILLA_ATTRIBUTES.get()).booleanValue()) {
                int HIDE_ATTRIBUTES = 2;
                int currentFlags = stack.m_41784_().m_128451_("HideFlags");
                stack.m_41784_().m_128405_("HideFlags", currentFlags | HIDE_ATTRIBUTES);
            } else {
                int currentFlags = stack.m_41784_().m_128451_("HideFlags");
                stack.m_41784_().m_128405_("HideFlags", currentFlags & 0xFFFFFFFD);
            }
            double atkBase = 1.0;
            double addition = 0.0;
            double multiplyBase = 0.0;
            double multiplyTotal = 0.0;
            double atkSpeed = 4.0;
            Multimap mods = stack.m_41638_(EquipmentSlot.MAINHAND);
            if (mods != null) {
                if (mods.containsKey((Object)Attributes.f_22281_)) {
                    for (AttributeModifier mod : mods.get((Object)Attributes.f_22281_)) {
                        switch (mod.m_22217_()) {
                            case ADDITION: {
                                addition += mod.m_22218_();
                                break;
                            }
                            case MULTIPLY_BASE: {
                                multiplyBase += mod.m_22218_();
                                break;
                            }
                            case MULTIPLY_TOTAL: {
                                multiplyTotal += mod.m_22218_();
                            }
                        }
                    }
                }
                if (mods.containsKey((Object)Attributes.f_22283_)) {
                    double baseSpeed = 4.0;
                    double speedAddition = 0.0;
                    double speedMultBase = 0.0;
                    double speedMultTotal = 0.0;
                    for (AttributeModifier mod : mods.get((Object)Attributes.f_22283_)) {
                        switch (mod.m_22217_()) {
                            case ADDITION: {
                                speedAddition += mod.m_22218_();
                                break;
                            }
                            case MULTIPLY_BASE: {
                                speedMultBase += mod.m_22218_();
                                break;
                            }
                            case MULTIPLY_TOTAL: {
                                speedMultTotal += mod.m_22218_();
                            }
                        }
                    }
                    double resultSpeed = (baseSpeed + speedAddition) * (1.0 + speedMultBase);
                    atkSpeed = resultSpeed * (1.0 + speedMultTotal);
                }
            }
            atkBase = (atkBase + addition) * (1.0 + multiplyBase);
            atkBase *= 1.0 + multiplyTotal;
            int insertIndex = 1;
            tooltip.add(insertIndex++, Component.m_237119_());
            if (stack.m_41782_() && stack.m_41783_().m_128441_("WeaponRarity")) {
                String rarityKey = stack.m_41783_().m_128461_("WeaponRarity");
                int color = WeaponRarityUtil.getRarityColor(rarityKey);
                MutableComponent rarityName = Component.m_237115_((String)rarityKey).m_130938_(style -> style.m_178520_(color));
                MutableComponent rarityText = Component.m_237110_((String)"tooltip.levelingrank.rarity", (Object[])new Object[]{rarityName}).m_130940_(ChatFormatting.GRAY);
                tooltip.add(insertIndex++, Component.m_237113_((String)"").m_7220_((Component)rarityText));
            }
            if (stack.m_41782_() && stack.m_41783_().m_128441_("WeaponRarity")) {
                double pct = stack.m_41783_().m_128459_("WeaponBonusPct");
                double total = stack.m_41783_().m_128459_("WeaponTotalDmg");
                String pctStr = String.format("%d%%", (int)Math.round(pct * 100.0));
                String totalStr = String.format("%.1f", total);
                String atkBaseStr = String.format("%.1f", atkBase);
                tooltip.add(insertIndex++, Component.m_237113_((String)"").m_7220_((Component)Component.m_237115_((String)"tooltip.levelingrank.total_dmg").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)totalStr).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)("(" + atkBaseStr + " + " + pctStr + ")")).m_130940_(ChatFormatting.DARK_GRAY)));
            } else {
                String baseStr = String.format("%.1f", atkBase);
                tooltip.add(insertIndex++, Component.m_237113_((String)"").m_7220_((Component)Component.m_237115_((String)"tooltip.levelingrank.total_dmg").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)baseStr).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})));
            }
            if (stack.m_41782_() && stack.m_41783_().m_128441_("WeaponPierce")) {
                double pierce = stack.m_41783_().m_128459_("WeaponPierce");
                int pierceInt = (int)Math.round(pierce);
                tooltip.add(insertIndex++, Component.m_237110_((String)"tooltip.levelingrank.weapon_pierce", (Object[])new Object[]{pierceInt}).m_130940_(ChatFormatting.DARK_AQUA));
            }
            if (!((Boolean)LevelingRankConfig.SHOW_VANILLA_ATTRIBUTES.get()).booleanValue()) {
                String atkSpeedText = String.format("%.2f", atkSpeed);
                tooltip.add(insertIndex++, Component.m_237115_((String)"tooltip.levelingrank.atk_speed").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)atkSpeedText).m_130940_(ChatFormatting.AQUA)));
            }
            tooltip.add(insertIndex++, Component.m_237119_());
            tooltip.add(Component.m_237119_());
            DurabilityTooltipUtil.addColoredDurabilityLine(stack, tooltip);
            int lvlReq = -1;
            if (stack.m_41782_() && stack.m_41783_().m_128441_("RequiredLevel")) {
                lvlReq = stack.m_41783_().m_128451_("RequiredLevel");
            } else {
                Integer jsonReq = WeaponRestrictionHandler.getWeaponRequiredLevel(stack);
                if (jsonReq != null) {
                    lvlReq = jsonReq;
                }
            }
            if (lvlReq > 0) {
                tooltip.add(Component.m_237113_((String)"").m_7220_((Component)Component.m_237110_((String)"tooltip.levelingrank.weapon_requirement", (Object[])new Object[]{lvlReq})).m_130940_(ChatFormatting.RED));
            }
        } else if (ArmorRestrictionHandler.isArmor(stack)) {
            int insertIndex = 1;
            if (stack.m_41782_() && stack.m_41783_().m_128441_("ArmorRarity")) {
                String rarityKey = stack.m_41783_().m_128461_("ArmorRarity");
                int color = ArmorRarityUtil.getRarityColor(rarityKey);
                MutableComponent rarityName = Component.m_237115_((String)rarityKey).m_130938_(style -> style.m_178520_(color));
                tooltip.add(insertIndex++, Component.m_237113_((String)"").m_7220_((Component)Component.m_237110_((String)"tooltip.levelingrank.armor_rarity", (Object[])new Object[]{rarityName}).m_130940_(ChatFormatting.GRAY)));
            }
            if (stack.m_41782_() && stack.m_41783_().m_128441_("ArmorScore")) {
                int armorScore = stack.m_41783_().m_128451_("ArmorScore");
                tooltip.add(insertIndex++, Component.m_237110_((String)"tooltip.levelingrank.armor_score", (Object[])new Object[]{armorScore}).m_130940_(ChatFormatting.BLUE));
            }
            tooltip.add(insertIndex++, Component.m_237119_());
            tooltip.add(Component.m_237119_());
            int minLevel = ArmorRestrictionHandler.getArmorRequiredLevel(stack);
            if (minLevel > 0) {
                tooltip.add(Component.m_237113_((String)"").m_7220_((Component)Component.m_237110_((String)"tooltip.levelingrank.armor_requirement", (Object[])new Object[]{minLevel})).m_130940_(ChatFormatting.RED));
            }
            DurabilityTooltipUtil.addColoredDurabilityLine(stack, tooltip);
        }
    }
}

