/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.handler;

import com.everydayxp.levelingrank.capability.ILevelData;
import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.config.LevelingRankConfig;
import com.everydayxp.levelingrank.util.JsonRestrictionUtil;
import com.everydayxp.levelingrank.util.WeaponRarityUtil;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="levelingrank")
public class WeaponRestrictionHandler {
    private static final Map<String, TagKey<Item>> itemTagCache = new HashMap<String, TagKey<Item>>();

    public static JsonRestrictionUtil.RestrictionData getRestrictions() {
        return JsonRestrictionUtil.forType("weapon");
    }

    public static boolean isWeapon(ItemStack stack) {
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[LevelingRank DEBUG] Checking if " + stack + " is weapon");
        }
        JsonRestrictionUtil.RestrictionData restrictions = WeaponRestrictionHandler.getRestrictions();
        ResourceLocation itemID = stack.m_41720_().m_204114_().m_205785_().m_135782_();
        if (restrictions.items.containsKey(itemID.toString())) {
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                System.out.println("[LevelingRank DEBUG] " + itemID + " found in items restrictions");
            }
            return true;
        }
        for (String tagName : restrictions.tags.keySet()) {
            TagKey<Item> tag = itemTagCache.get(tagName);
            if (tag == null) {
                ResourceLocation tagLoc = ResourceLocation.m_135820_((String)tagName);
                TagKey<Item> tagKey = tag = tagLoc != null ? TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagLoc) : null;
                if (tag != null) {
                    itemTagCache.put(tagName, tag);
                }
            }
            if (tag == null || !stack.m_204117_(tag)) continue;
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                System.out.println("[LevelingRank DEBUG] " + itemID + " matches tag " + tagName);
            }
            return true;
        }
        return false;
    }

    public static int getWeaponRequiredLevel(ItemStack stack) {
        int result;
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[LevelingRank DEBUG] Getting required level for " + stack);
        }
        JsonRestrictionUtil.RestrictionData restrictions = WeaponRestrictionHandler.getRestrictions();
        ResourceLocation itemID = stack.m_41720_().m_204114_().m_205785_().m_135782_();
        Integer minLevel = null;
        Object configObj = restrictions.items.get(itemID.toString());
        if (configObj instanceof Map) {
            Map configMap = (Map)configObj;
            Object minLevelObj = configMap.get("min_level");
            if (minLevelObj instanceof Number) {
                minLevel = ((Number)minLevelObj).intValue();
            }
        } else if (configObj instanceof Number) {
            minLevel = ((Number)configObj).intValue();
        }
        if (minLevel == null) {
            for (String tagName : restrictions.tags.keySet()) {
                TagKey<Item> tag = itemTagCache.get(tagName);
                if (tag == null) {
                    ResourceLocation tagLoc = ResourceLocation.m_135820_((String)tagName);
                    TagKey<Item> tagKey = tag = tagLoc != null ? TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagLoc) : null;
                    if (tag != null) {
                        itemTagCache.put(tagName, tag);
                    }
                }
                if (tag == null || !stack.m_204117_(tag)) continue;
                Object tagConfig = restrictions.tags.get(tagName);
                if (tagConfig instanceof Map) {
                    Map tagConfigMap = (Map)tagConfig;
                    Object tagMinLevelObj = tagConfigMap.get("min_level");
                    if (tagMinLevelObj instanceof Number) {
                        minLevel = ((Number)tagMinLevelObj).intValue();
                    }
                } else if (tagConfig instanceof Number) {
                    minLevel = ((Number)tagConfig).intValue();
                }
                if (!((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue() || minLevel == null) break;
                System.out.println("[LevelingRank DEBUG] " + itemID + " matches tag " + tagName + " with level " + minLevel);
                break;
            }
        }
        int n = result = minLevel != null ? minLevel : 1;
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[LevelingRank DEBUG] Final required level for " + itemID + ": " + result);
        }
        return result;
    }

    public static void ensurePierce(ItemStack stack) {
        if (!WeaponRestrictionHandler.isWeapon(stack) || stack.m_41619_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("WeaponPierce")) {
            return;
        }
        if (tag.m_128441_("WeaponRarity") && !tag.m_128461_("WeaponRarity").isEmpty()) {
            String rarityKey = tag.m_128461_("WeaponRarity");
            double pierce = WeaponRarityUtil.getTierPierce(rarityKey, 0);
            tag.m_128347_("WeaponPierceBase", pierce);
            tag.m_128347_("WeaponPierce", pierce);
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                System.out.println("[LevelingRank DEBUG] Rarity weapon " + stack + " \u00e2\u2020\u2019 pierce: " + pierce + " (Tier 0, " + rarityKey + ")");
            }
        } else {
            tag.m_128347_("WeaponPierceBase", 37.0);
            tag.m_128347_("WeaponPierce", 37.0);
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                System.out.println("[LevelingRank DEBUG] Crafted weapon " + stack + " \u00e2\u2020\u2019 pierce: 37.0");
            }
        }
        stack.m_41751_(tag);
    }

    public static void attachWeaponNBT(ItemStack stack, int playerLevel, double baseDamage) {
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[LevelingRank DEBUG] Attaching full NBT to " + stack + " for player level " + playerLevel);
        }
        int reqLevel = WeaponRestrictionHandler.getWeaponRequiredLevel(stack);
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("RequiredLevel") && tag.m_128451_("RequiredLevel") == reqLevel && tag.m_128441_("WeaponRarity") && !tag.m_128461_("WeaponRarity").isEmpty() && tag.m_128441_("WeaponBonusPct") && tag.m_128441_("RarityTier")) {
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                System.out.println("[LevelingRank DEBUG] NBT already complete for " + stack);
            }
            return;
        }
        tag.m_128405_("RequiredLevel", reqLevel);
        if (!tag.m_128441_("WeaponRarity") || tag.m_128461_("WeaponRarity").isEmpty()) {
            int raritySeedLevel = Math.max(playerLevel, reqLevel);
            WeaponRarityUtil.RarityData rarityData = WeaponRarityUtil.generateRarity(raritySeedLevel);
            tag.m_128359_("WeaponRarity", rarityData.rarityKey);
            int tier = 0;
            tag.m_128405_("RarityTier", tier);
            tag.m_128347_("WeaponBaseDmg", baseDamage);
            int dmgTierForBonus = 1;
            double tierBonusPct = WeaponRarityUtil.getTierBonusPct(rarityData.rarityKey, dmgTierForBonus);
            tag.m_128347_("WeaponBonusPct", tierBonusPct);
            double bonus = baseDamage * tierBonusPct;
            tag.m_128347_("WeaponBonusDmg", bonus);
            tag.m_128347_("WeaponTotalDmg", baseDamage + bonus);
            double pierce = WeaponRarityUtil.getTierPierce(rarityData.rarityKey, tier);
            tag.m_128347_("WeaponPierce", pierce);
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                System.out.println("[LevelingRank DEBUG] Added rarity " + rarityData.rarityKey + ", bonus " + tierBonusPct + ", tier " + tier + ", pierce " + pierce + " to " + stack);
            }
        }
        stack.m_41751_(tag);
    }

    public static double getWeaponBaseDamage(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return 0.0;
        }
        double base = 1.0;
        Multimap mods = stack.m_41638_(EquipmentSlot.MAINHAND);
        if (mods != null && mods.containsKey((Object)Attributes.f_22281_)) {
            double addition = mods.get((Object)Attributes.f_22281_).stream().filter(mod -> mod.m_22217_() == AttributeModifier.Operation.ADDITION).mapToDouble(AttributeModifier::m_22218_).sum();
            base += addition;
        }
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[LevelingRank DEBUG] Base damage for " + stack + ": " + base);
        }
        return base;
    }

    public static void attachWeaponLevelOnly(ItemStack stack, int playerLevel, double baseDamage) {
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[LevelingRank DEBUG] Attaching only level NBT to " + stack);
        }
        int reqLevel = WeaponRestrictionHandler.getWeaponRequiredLevel(stack);
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("RequiredLevel", reqLevel);
        stack.m_41751_(tag);
    }

    public static int getPlayerLevel(Player player) {
        return player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).map(ILevelData::getLevel).orElse(1);
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack stack = event.getCrafting();
        Player player = event.getEntity();
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[LevelingRank DEBUG] Item crafted: " + stack + " by " + player.m_7755_().getString());
        }
        if (WeaponRestrictionHandler.isWeapon(stack)) {
            stack.m_41784_().m_128379_("PlayerCrafted", true);
            WeaponRestrictionHandler.ensurePierce(stack);
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                System.out.println("[LevelingRank DEBUG] Marked as PlayerCrafted: " + stack);
            }
        }
    }

    @SubscribeEvent
    public static void onSmithingPickup(PlayerContainerEvent.Close event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            AbstractContainerMenu menu = event.getContainer();
            Player player = event.getEntity();
            if (menu.getClass().getSimpleName().toLowerCase().contains("smithing")) {
                if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                    System.out.println("[LevelingRank DEBUG] Smithing table closed by " + player.m_7755_().getString());
                }
                for (int i = 0; i < menu.f_38839_.size(); ++i) {
                    ItemStack stack = ((Slot)menu.f_38839_.get(i)).m_7993_();
                    if (stack == null || stack.m_41619_() || !WeaponRestrictionHandler.isWeapon(stack)) continue;
                    stack.m_41784_().m_128379_("PlayerCrafted", true);
                    int reqLevel = WeaponRestrictionHandler.getWeaponRequiredLevel(stack);
                    int raritySeedLevel = Math.max(WeaponRestrictionHandler.getPlayerLevel(player), reqLevel);
                    WeaponRestrictionHandler.attachWeaponNBT(stack, raritySeedLevel, WeaponRestrictionHandler.getWeaponBaseDamage(stack));
                    WeaponRestrictionHandler.ensurePierce(stack);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void applyRestrictionAndBonus(LivingHurtEvent event) {
        String weaponRarityKey;
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack stack = player.m_21205_();
        if (!WeaponRestrictionHandler.isWeapon(stack)) {
            return;
        }
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[LevelingRank DEBUG] Applying restrictions/bonus for " + stack + " by " + player.m_7755_().getString());
        }
        WeaponRestrictionHandler.attachWeaponLevelOnly(stack, WeaponRestrictionHandler.getPlayerLevel(player), WeaponRestrictionHandler.getWeaponBaseDamage(stack));
        int requiredLevel = stack.m_41782_() ? stack.m_41783_().m_128451_("RequiredLevel") : WeaponRestrictionHandler.getWeaponRequiredLevel(stack);
        int playerLevel = WeaponRestrictionHandler.getPlayerLevel(player);
        if (playerLevel < requiredLevel) {
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                System.out.println("[LevelingRank DEBUG] Player level " + playerLevel + " < required " + requiredLevel + " for " + stack);
            }
            event.setCanceled(true);
            player.m_5661_((Component)Component.m_237110_((String)"message.levelingrank.weapon_level_requirement", (Object[])new Object[]{requiredLevel}).m_130940_(ChatFormatting.RED), true);
            return;
        }
        String string = weaponRarityKey = stack.m_41782_() ? stack.m_41783_().m_128461_("WeaponRarity") : "";
        if (weaponRarityKey == null || weaponRarityKey.isEmpty()) {
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                System.out.println("[LevelingRank DEBUG] No rarity on " + stack + ", using base damage only");
            }
            return;
        }
        List<WeaponRarityUtil.RarityData> allowedRarities = WeaponRarityUtil.getAllowedRarities(playerLevel);
        boolean rarityAllowed = allowedRarities.stream().anyMatch(r -> r.rarityKey.equals(weaponRarityKey));
        if (!rarityAllowed) {
            if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                System.out.println("[LevelingRank DEBUG] Rarity " + weaponRarityKey + " not allowed for player level " + playerLevel);
            }
            event.setCanceled(true);
            int colorHex = WeaponRarityUtil.getRarityColor(weaponRarityKey);
            MutableComponent rarityName = Component.m_237115_((String)weaponRarityKey).m_130948_(Style.f_131099_.m_178520_(colorHex));
            player.m_5661_((Component)Component.m_237110_((String)"message.levelingrank.weapon_rarity_requirement", (Object[])new Object[]{rarityName}).m_130940_(ChatFormatting.RED), true);
            return;
        }
        double weaponBonus = stack.m_41783_().m_128459_("WeaponBonusDmg");
        if (((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
            System.out.println("[LevelingRank DEBUG] Adding weapon bonus: " + weaponBonus + " (damage was: " + event.getAmount() + ")");
        }
        event.setAmount(event.getAmount() + (float)weaponBonus);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (player.f_19797_ % 40 != 0) {
            return;
        }
        int level = WeaponRestrictionHandler.getPlayerLevel(player);
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!WeaponRestrictionHandler.isWeapon(stack)) continue;
            WeaponRestrictionHandler.attachWeaponLevelOnly(stack, level, WeaponRestrictionHandler.getWeaponBaseDamage(stack));
            WeaponRestrictionHandler.ensurePierce(stack);
        }
    }
}

