/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.items.deconstructorblock;

import com.everydayxp.levelingrank.items.ModItems;
import com.everydayxp.levelingrank.items.deconstructorblock.RarityDeconstructorBlockEntity;
import com.everydayxp.levelingrank.menu.ModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RarityDeconstructorMenu
extends AbstractContainerMenu {
    private final SimpleContainer privateItems = new SimpleContainer(2);
    @Nullable
    private final RarityDeconstructorBlockEntity blockEntity;
    private final ContainerLevelAccess access;

    public RarityDeconstructorMenu(int id, Inventory playerInv, @Nullable RarityDeconstructorBlockEntity blockEntity, @Nullable ContainerData data) {
        super((MenuType)ModMenus.RARITY_DECONSTRUCTOR_MENU.get(), id);
        this.blockEntity = blockEntity;
        this.access = blockEntity != null ? ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_()) : ContainerLevelAccess.f_39287_;
        ContainerData usedData = data != null ? data : new SimpleContainerData(1);
        this.m_38897_(new Slot((Container)this.privateItems, 0, 44, 35){

            public void m_6654_() {
                super.m_6654_();
                RarityDeconstructorMenu.this.updatePreview();
            }
        });
        this.m_38897_(new Slot((Container)this.privateItems, 1, 116, 35){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack takenStack) {
                super.m_142406_(player, takenStack);
                RarityDeconstructorMenu.this.privateItems.m_6836_(0, ItemStack.f_41583_);
                RarityDeconstructorMenu.this.privateItems.m_6836_(1, ItemStack.f_41583_);
            }
        });
        this.addPlayerInventory(playerInv);
        this.addPlayerHotbar(playerInv);
        this.m_38884_(usedData);
    }

    private void updatePreview() {
        int fragmentCount;
        ItemStack input = this.privateItems.m_8020_(0);
        if (input.m_41619_() || !input.m_41782_()) {
            this.privateItems.m_6836_(1, ItemStack.f_41583_);
            return;
        }
        String rarityKey = this.getRarityKey(input);
        int n = fragmentCount = rarityKey != null ? this.getFragmentCount(rarityKey) : 0;
        if (rarityKey == null || rarityKey.isEmpty() || fragmentCount <= 0) {
            this.privateItems.m_6836_(1, ItemStack.f_41583_);
        } else {
            ItemStack fragment = new ItemStack((ItemLike)ModItems.FUSION_FRAGMENT.get(), fragmentCount);
            this.privateItems.m_6836_(1, fragment);
        }
    }

    private String getRarityKey(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        if (tag.m_128441_("WeaponRarity") && !tag.m_128461_("WeaponRarity").isEmpty()) {
            return tag.m_128461_("WeaponRarity");
        }
        if (tag.m_128441_("ArmorRarity") && !tag.m_128461_("ArmorRarity").isEmpty()) {
            return tag.m_128461_("ArmorRarity");
        }
        return null;
    }

    private int getFragmentCount(String rarityKey) {
        return switch (rarityKey) {
            case "rarity.levelingrank.common" -> 1;
            case "rarity.levelingrank.uncommon" -> 2;
            case "rarity.levelingrank.rare" -> 3;
            case "rarity.levelingrank.epic" -> 4;
            case "rarity.levelingrank.legendary" -> 5;
            case "rarity.levelingrank.mythic" -> 6;
            case "rarity.levelingrank.divine" -> 7;
            case "rarity.levelingrank.exotic" -> 8;
            case "rarity.levelingrank.celestial" -> 9;
            case "rarity.levelingrank.infernal" -> 10;
            default -> 0;
        };
    }

    public boolean m_6875_(Player player) {
        return (Boolean)this.access.m_39299_((level, pos) -> player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    private void addPlayerInventory(Inventory playerInv) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInv) {
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 142));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }
}

