/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.network;

import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.handler.LevelRewardHandler;
import com.everydayxp.levelingrank.network.ModNetworkHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ClaimLevelRewardC2SPacket {
    private final int rewardLevel;

    public ClaimLevelRewardC2SPacket(int rewardLevel) {
        this.rewardLevel = rewardLevel;
    }

    public ClaimLevelRewardC2SPacket(FriendlyByteBuf buf) {
        this.rewardLevel = buf.m_130242_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(this.rewardLevel);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null || player.m_9236_().m_5776_()) {
                return;
            }
            player.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> {
                if (data.hasClaimedRewardLevel(this.rewardLevel)) {
                    return;
                }
                LevelRewardHandler.LevelReward reward = LevelRewardHandler.getAllRewards().stream().filter(r -> r.level == this.rewardLevel).findFirst().orElse(null);
                if (reward == null) {
                    return;
                }
                ItemStack stack = LevelRewardHandler.toStack(reward);
                if (stack.m_41619_()) {
                    return;
                }
                if (!player.m_36356_(stack)) {
                    player.m_36176_(stack, false);
                }
                data.addClaimedRewardLevel(this.rewardLevel);
                ModNetworkHandler.syncLevelData(player, data);
            });
        });
        context.setPacketHandled(true);
    }
}

