/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.network;

import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.network.ModNetworkHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="levelingrank")
public class DelayedSyncHandler {
    private static final Map<UUID, Integer> syncQueue = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            syncQueue.put(serverPlayer.m_20148_(), 5);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (syncQueue.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<UUID, Integer>> it = syncQueue.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, Integer> entry = it.next();
            int ticks = entry.getValue() - 1;
            if (ticks <= 0) {
                ServerPlayer found = null;
                for (ServerPlayer p : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                    if (!p.m_20148_().equals(entry.getKey())) continue;
                    found = p;
                    break;
                }
                if (found != null) {
                    ServerPlayer serverPlayer = found;
                    serverPlayer.getCapability(LevelDataProvider.LEVEL_CAPABILITY).ifPresent(data -> ModNetworkHandler.syncLevelData(serverPlayer, data.getLevel(), data.getXP()));
                }
                it.remove();
                continue;
            }
            entry.setValue(ticks);
        }
    }
}

