/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.network;

import com.everydayxp.levelingrank.capability.ILevelData;
import com.everydayxp.levelingrank.network.ClaimLevelRewardC2SPacket;
import com.everydayxp.levelingrank.network.SetCustomTitleC2SPacket;
import com.everydayxp.levelingrank.network.SyncAllJsonConfigsS2CPacket;
import com.everydayxp.levelingrank.network.SyncDailyQuestS2CPacket;
import com.everydayxp.levelingrank.network.SyncLevelDataS2CPacket;
import com.everydayxp.levelingrank.network.SyncMobLevelS2CPacket;
import com.everydayxp.levelingrank.network.SyncOtherPlayerLevelPacket;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ModNetworkHandler {
    private static final String PROTOCOL = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("levelingrank", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int id = 0;

    public static void register() {
        CHANNEL.registerMessage(id++, SyncLevelDataS2CPacket.class, SyncLevelDataS2CPacket::encode, SyncLevelDataS2CPacket::decode, SyncLevelDataS2CPacket::handle);
        CHANNEL.registerMessage(id++, SyncOtherPlayerLevelPacket.class, SyncOtherPlayerLevelPacket::encode, SyncOtherPlayerLevelPacket::decode, SyncOtherPlayerLevelPacket::handle);
        CHANNEL.registerMessage(id++, SyncMobLevelS2CPacket.class, SyncMobLevelS2CPacket::encode, SyncMobLevelS2CPacket::decode, SyncMobLevelS2CPacket::handle);
        CHANNEL.registerMessage(id++, SyncAllJsonConfigsS2CPacket.class, SyncAllJsonConfigsS2CPacket::encode, SyncAllJsonConfigsS2CPacket::decode, SyncAllJsonConfigsS2CPacket::handle);
        CHANNEL.registerMessage(id++, ClaimLevelRewardC2SPacket.class, ClaimLevelRewardC2SPacket::toBytes, ClaimLevelRewardC2SPacket::new, ClaimLevelRewardC2SPacket::handle);
        CHANNEL.registerMessage(id++, SetCustomTitleC2SPacket.class, SetCustomTitleC2SPacket::toBytes, SetCustomTitleC2SPacket::new, SetCustomTitleC2SPacket::handle);
        CHANNEL.messageBuilder(SyncDailyQuestS2CPacket.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncDailyQuestS2CPacket::encode).decoder(SyncDailyQuestS2CPacket::decode).consumerMainThread(SyncDailyQuestS2CPacket::handle).add();
    }

    public static void syncLevelData(ServerPlayer player, ILevelData data) {
        if (player == null || player.f_8906_ == null) {
            return;
        }
        ArrayList<Integer> claimed = new ArrayList<Integer>(data.getClaimedRewardLevels());
        CHANNEL.sendTo((Object)new SyncLevelDataS2CPacket(data.getLevel(), data.getXP(), data.getCustomTitle(), data.isCustomTitleEnabled(), claimed), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void syncLevelData(ServerPlayer player, int level, int xp) {
    }

    public static void syncPlayerLevelToOthers(ServerPlayer player, int level) {
        if (player == null) {
            return;
        }
        CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncOtherPlayerLevelPacket(player.m_20148_(), level));
    }

    public static void sendClaimReward(int rewardLevel) {
        CHANNEL.sendToServer((Object)new ClaimLevelRewardC2SPacket(rewardLevel));
    }

    public static void sendSetCustomTitle(String title, boolean enabled) {
        CHANNEL.sendToServer((Object)new SetCustomTitleC2SPacket(title, enabled));
    }
}

