/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.network;

import com.everydayxp.levelingrank.capability.ILevelData;
import com.everydayxp.levelingrank.capability.LevelDataProvider;
import com.everydayxp.levelingrank.network.ModNetworkHandler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class SetCustomTitleC2SPacket {
    private final String title;
    private final boolean enabled;

    public SetCustomTitleC2SPacket(String title, boolean enabled) {
        this.title = title;
        this.enabled = enabled;
    }

    public SetCustomTitleC2SPacket(FriendlyByteBuf buf) {
        this.title = buf.m_130136_(64);
        this.enabled = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130072_(this.title, 64);
        buf.writeBoolean(this.enabled);
    }

    public static void handle(SetCustomTitleC2SPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            String clean;
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            String string = clean = msg.title == null ? "" : msg.title.trim();
            if (clean.length() > 64) {
                clean = clean.substring(0, 64);
            }
            String finalClean = clean;
            Optional optCap = sender.getCapability(LevelDataProvider.LEVEL_CAPABILITY).resolve();
            if (optCap.isPresent()) {
                ILevelData data = (ILevelData)optCap.get();
                data.setCustomTitle(finalClean);
                data.setCustomTitleEnabled(msg.enabled);
                ModNetworkHandler.syncLevelData(sender, data);
                sender.refreshDisplayName();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

