/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.levelingrank.network;

import com.everydayxp.levelingrank.client.quest.DailyQuestOverlay;
import com.everydayxp.levelingrank.config.LevelingRankConfig;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkEvent;

public class SyncDailyQuestS2CPacket {
    private final boolean hasQuest;
    private final String targetName;
    private final int required;
    private final int progress;
    private final int rewardXp;
    private final int rewardItemCount;
    private final Component rewardItemName;

    public SyncDailyQuestS2CPacket(boolean hasQuest, String targetName, int required, int progress, int rewardXp, int rewardItemCount, Component rewardItemName) {
        this.hasQuest = hasQuest;
        this.targetName = targetName;
        this.required = required;
        this.progress = progress;
        this.rewardXp = rewardXp;
        this.rewardItemCount = rewardItemCount;
        this.rewardItemName = rewardItemName;
    }

    public static void encode(SyncDailyQuestS2CPacket msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.hasQuest);
        buf.m_130070_(msg.targetName);
        buf.m_130130_(msg.required);
        buf.m_130130_(msg.progress);
        buf.m_130130_(msg.rewardXp);
        buf.m_130130_(msg.rewardItemCount);
        buf.m_130083_(msg.rewardItemName);
    }

    public static SyncDailyQuestS2CPacket decode(FriendlyByteBuf buf) {
        boolean hasQuest = buf.readBoolean();
        String targetName = buf.m_130277_();
        int required = buf.m_130242_();
        int progress = buf.m_130242_();
        int rewardXp = buf.m_130242_();
        int rewardItemCount = buf.m_130242_();
        Component itemName = buf.m_130238_();
        return new SyncDailyQuestS2CPacket(hasQuest, targetName, required, progress, rewardXp, rewardItemCount, itemName);
    }

    public static void handle(SyncDailyQuestS2CPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && ((Boolean)LevelingRankConfig.ENABLE_DEBUG_LOGS.get()).booleanValue()) {
                mc.f_91074_.m_213846_((Component)Component.m_237113_((String)("[DQ-DEBUG] S2C quest: hasQuest=" + msg.hasQuest + " target=" + msg.targetName + " req=" + msg.required + " prog=" + msg.progress + " xp=" + msg.rewardXp + " reward=" + msg.rewardItemCount + "x " + msg.rewardItemName.getString())));
            }
            DailyQuestOverlay.setQuest(msg.hasQuest, msg.targetName, msg.required, msg.progress, msg.rewardXp, msg.rewardItemCount, msg.rewardItemName);
        });
        context.setPacketHandled(true);
    }
}

