/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.MobsPrank;

import com.j2k.MobsPrank.PrankSnowballGoal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class MobAIHandler {
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("99999999-0000-0000-0000-000000000000");

    @SubscribeEvent
    public void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Monster) {
            Monster monster = (Monster)entity;
            if (!event.getLevel().m_5776_()) {
                this.boostSpeed(monster);
                this.removeVanillaAttackGoals(monster);
                this.addPrankGoals(monster);
            }
        }
    }

    private void boostSpeed(Monster mob) {
        if (mob.m_21051_(Attributes.f_22279_) != null && mob.m_21051_(Attributes.f_22279_).m_22111_(SPEED_MODIFIER_UUID) == null) {
            mob.m_21051_(Attributes.f_22279_).m_22118_(new AttributeModifier(SPEED_MODIFIER_UUID, "Prank Speed", 0.35, AttributeModifier.Operation.ADDITION));
        }
    }

    private void removeVanillaAttackGoals(Monster mob) {
        try {
            Set goals = (Set)ObfuscationReflectionHelper.getPrivateValue(GoalSelector.class, (Object)mob.f_21345_, (String)"f_25353_");
            ArrayList<Goal> toRemove = new ArrayList<Goal>();
            List<Class> bannedGoals = Arrays.asList(MeleeAttackGoal.class, ZombieAttackGoal.class, RangedBowAttackGoal.class, SwellGoal.class, LeapAtTargetGoal.class);
            block2: for (WrappedGoal wrapped : goals) {
                Goal innerGoal = wrapped.m_26015_();
                for (Class banned : bannedGoals) {
                    if (!banned.isAssignableFrom(innerGoal.getClass())) continue;
                    toRemove.add(innerGoal);
                    continue block2;
                }
            }
            toRemove.forEach(arg_0 -> ((GoalSelector)mob.f_21345_).m_25363_(arg_0));
        }
        catch (Exception e) {
            System.out.println("MobsPrank: Could not remove goals for " + mob.m_7755_().getString());
        }
    }

    private void addPrankGoals(Monster mob) {
        mob.f_21345_.m_25352_(0, (Goal)new PrankSnowballGoal((PathfinderMob)mob, 1.3, 20, 20.0f));
        mob.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)mob, Monster.class, true));
    }
}

